/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardColumnOperation;

public class DisconnectLeaderboardColumnFromTrackedRace
extends AbstractLeaderboardColumnOperation<Void> {
    private static final long serialVersionUID = -5822713961135743309L;
    private final String fleetName;

    public DisconnectLeaderboardColumnFromTrackedRace(String leaderboardName, String columnName, String fleetName) {
        super(leaderboardName, columnName);
        this.fleetName = fleetName;
    }

    public Void internalApplyTo(RacingEventService toState) {
        RaceColumn raceColumn;
        Leaderboard leaderboard = toState.getLeaderboardByName(this.getLeaderboardName());
        if (leaderboard != null) {
            raceColumn = leaderboard.getRaceColumnByName(this.getColumnName());
            if (raceColumn == null) {
                throw new IllegalArgumentException("Didn't find race " + this.getColumnName() + " in leaderboard " + this.getLeaderboardName());
            }
        } else {
            throw new IllegalArgumentException("Didn't find leaderboard " + this.getLeaderboardName());
        }
        raceColumn.removeRaceIdentifier(raceColumn.getFleetByName(this.fleetName));
        this.updateDB(toState, leaderboard, raceColumn);
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

