/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardOperation;

public abstract class AbstractLeaderboardColumnOperation<ResultType>
extends AbstractLeaderboardOperation<ResultType> {
    private static final long serialVersionUID = 8577267743945864388L;
    private final String columnName;

    public AbstractLeaderboardColumnOperation(String leaderboardName, String columnName) {
        super(leaderboardName);
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    protected boolean affectsSameColumn(AbstractLeaderboardColumnOperation<?> other) {
        return this.affectsSameLeaderboard(other) && this.getColumnName().equals(other.getColumnName());
    }

    protected void updateDB(RacingEventService toState, Leaderboard leaderboard, RaceColumn raceColumn) {
        if (raceColumn instanceof RaceColumnInSeries) {
            toState.updateStoredRegatta(((RaceColumnInSeries)raceColumn).getSeries().getRegatta());
        } else {
            toState.updateStoredLeaderboard(leaderboard);
        }
    }
}

