/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.interfaces;

import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class DataImportLockWithProgress
extends NamedReentrantReadWriteLock {
    private static final int TIME_TO_DELETE_PROGRESS_ENTRY_AFTER_OPERATION_FINISHED_IN_MILLIS = 3600000;
    private static final long serialVersionUID = -3527221613483691340L;
    private final Map<UUID, DataImportProgress> progressPerId = new HashMap<UUID, DataImportProgress>();
    private final NamedReentrantReadWriteLock mapLock = new NamedReentrantReadWriteLock("mapLock in " + ((Object)((Object)this)).getClass().getName(), false);

    public DataImportLockWithProgress() {
        super(DataImportLockWithProgress.class.getName(), true);
    }

    public void setDeleteFromMapTimer(final UUID progressIDToDelete) {
        TimerTask deleteTask = new TimerTask(){

            @Override
            public void run() {
                LockUtil.lockForWrite((NamedReentrantReadWriteLock)DataImportLockWithProgress.this.mapLock);
                try {
                    DataImportLockWithProgress.this.progressPerId.remove(progressIDToDelete);
                }
                finally {
                    LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)DataImportLockWithProgress.this.mapLock);
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(deleteTask, 3600000L);
    }

    public DataImportProgress getProgress(UUID operationId) {
        DataImportProgress progress;
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.mapLock);
        try {
            progress = this.progressPerId.get(operationId);
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.mapLock);
        }
        return progress;
    }

    public void addProgress(UUID operationId, DataImportProgress progress) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.mapLock);
        try {
            this.progressPerId.put(operationId, progress);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.mapLock);
        }
    }
}

