/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.windfinder;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.windfinder.SpotBase;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.NamedImpl;

public class SpotDTO
extends NamedImpl
implements SpotBase {
    private static final long serialVersionUID = 1642900468710612984L;
    private static final String BASE_URL = "https://www.windfinder.com";
    private static final String BASE_REPORT_URL = "https://www.windfinder.com/report";
    private static final String BASE_FORECAST_URL = "https://www.windfinder.com/forecast";
    private static final String BASE_STATISTICS_URL = "https://www.windfinder.com/windstatistics";
    private static final Duration FORECAST_DURATION = Duration.ONE_DAY.times(9L);
    private static final Duration REPORT_LOOKBACK = Duration.ONE_DAY.times(7L);
    private final String id;
    private final String keyword;
    private final String englishCountryName;
    private final Position position;

    public SpotDTO(String name, String id, String keyword, String englishCountryName, Position position) {
        super(name);
        this.id = id;
        this.keyword = keyword;
        this.englishCountryName = englishCountryName;
        this.position = position;
    }

    public SpotDTO(SpotBase spot) {
        this(spot.getName(), spot.getId(), spot.getKeyword(), spot.getEnglishCountryName(), spot.getPosition());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpotDTO other = (SpotDTO)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getEnglishCountryName() {
        return this.englishCountryName;
    }

    @Override
    public String getReportUrl() {
        return "https://www.windfinder.com/report/" + this.getKeyword();
    }

    @Override
    public String getForecastUrl() {
        return "https://www.windfinder.com/forecast/" + this.getKeyword();
    }

    @Override
    public String getStatisticsUrl() {
        return "https://www.windfinder.com/windstatistics/" + this.getKeyword();
    }

    @Override
    public String getCurrentlyMostAppropriateUrl(TimePoint timePoint) {
        TimePoint now = MillisecondsTimePoint.now();
        String result = timePoint.compareTo((Object)now.plus(Duration.ONE_MINUTE)) <= 0 ? (timePoint.compareTo((Object)now.minus(REPORT_LOOKBACK)) >= 0 ? this.getReportUrl() : this.getStatisticsUrl()) : (timePoint.compareTo((Object)now.plus(FORECAST_DURATION)) <= 0 ? this.getForecastUrl() : this.getStatisticsUrl());
        return result;
    }
}

