/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.sensordata;

import com.sap.sailing.domain.common.sensordata.ColumnMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum BravoSensorDataMetadata implements ColumnMetadata
{
    RIDE_HEIGHT_PORT_HULL("RideHeightPortHull"),
    RIDE_HEIGHT_STBD_HULL("RideHeightStbdHull"),
    HEEL("Heel"),
    PITCH("ImuSensor_Pitch");

    private String columnName;
    public static final int HEADER_COLUMN_OFFSET = 3;

    private BravoSensorDataMetadata(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public int getColumnIndex() {
        return this.ordinal();
    }

    public static BravoSensorDataMetadata byColumnName(String valueName) {
        BravoSensorDataMetadata[] values;
        BravoSensorDataMetadata[] bravoSensorDataMetadataArray = values = BravoSensorDataMetadata.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            BravoSensorDataMetadata item = bravoSensorDataMetadataArray[n2];
            if (Objects.equals(item.getColumnName(), valueName)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public static int getTrackColumnCount() {
        return BravoSensorDataMetadata.values().length;
    }

    public static List<String> getTrackColumnNames() {
        ArrayList<String> colNames = new ArrayList<String>(BravoSensorDataMetadata.getTrackColumnCount());
        BravoSensorDataMetadata[] bravoSensorDataMetadataArray = BravoSensorDataMetadata.values();
        int n = bravoSensorDataMetadataArray.length;
        int n2 = 0;
        while (n2 < n) {
            BravoSensorDataMetadata item = bravoSensorDataMetadataArray[n2];
            colNames.add(item.getColumnName());
            ++n2;
        }
        return colNames;
    }

    public static Map<String, Integer> getColumnNamesToIndexInDoubleFix() {
        HashMap<String, Integer> columnNamesToIndexInDoubleFix = new HashMap<String, Integer>();
        BravoSensorDataMetadata[] bravoSensorDataMetadataArray = BravoSensorDataMetadata.values();
        int n = bravoSensorDataMetadataArray.length;
        int n2 = 0;
        while (n2 < n) {
            BravoSensorDataMetadata column = bravoSensorDataMetadataArray[n2];
            columnNamesToIndexInDoubleFix.put(column.getColumnName(), column.getColumnIndex());
            ++n2;
        }
        return columnNamesToIndexInDoubleFix;
    }
}

