/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.scalablevalue.impl;

import com.sap.sailing.domain.common.DoubleTriple;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.RadianPosition;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.common.scalablevalue.ScalableValueWithDistance;

public class ScalablePosition
implements ScalableValueWithDistance<ScalablePosition, Position> {
    private final double x;
    private final double y;
    private final double z;

    public ScalablePosition(Position position) {
        this(Math.cos(position.getLatRad()) * Math.cos(position.getLngRad()), Math.cos(position.getLatRad()) * Math.sin(position.getLngRad()), Math.sin(position.getLatRad()));
    }

    public ScalablePosition(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public ScalablePosition multiply(double factor) {
        return new ScalablePosition(factor * this.x, factor * this.y, factor * this.z);
    }

    public ScalablePosition add(ScalableValue<ScalablePosition, Position> t) {
        ScalablePosition result = t == null ? this : new ScalablePosition(this.x + ((ScalablePosition)t.getValue()).x, this.y + ((ScalablePosition)t.getValue()).y, this.z + ((ScalablePosition)t.getValue()).z);
        return result;
    }

    public Position divide(double divisor) {
        RadianPosition result;
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            result = null;
        } else {
            double hyp = Math.sqrt(this.x * this.x + this.y * this.y);
            double latRad = Math.atan2(this.z, hyp);
            double lngRad = Math.atan2(this.y, this.x);
            result = new RadianPosition(latRad, lngRad);
        }
        return result;
    }

    public ScalablePosition getValue() {
        return this;
    }

    public double getDistance(Position other) {
        return this.divide(1.0).getDistance(other).getCentralAngleDeg();
    }

    public DoubleTriple getValueAsTriple() {
        return new DoubleTriple(this.x, this.y, this.z);
    }
}

