/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LeaderboardDTO
extends AbstractLeaderboardDTO
implements Serializable {
    private static final long serialVersionUID = -520930809792750648L;
    private String id;
    public List<CompetitorDTO> competitors;
    private List<CompetitorDTO> suppressedCompetitors;
    private Map<String, List<CompetitorDTO>> competitorOrderingPerRaceColumnName;
    private Date timePoint;
    private Date timePointOfLastCorrectionsValidity;
    private String comment;
    private boolean higherScoresIsBetter;
    private boolean hasOverallDetails;

    @Deprecated
    LeaderboardDTO() {
    }

    public LeaderboardDTO(String name, Date timepoint, Date timePointOfLastCorrectionsValidity, String comment, ScoringSchemeType scoringScheme, boolean higherScoreIsBetter, UUIDGenerator uuidGenerator, boolean hasOverallDetails, BoatClassDTO boatClass) {
        super(name, boatClass);
        this.initCollections();
        this.id = uuidGenerator.generateRandomUUID();
        this.timePoint = timepoint;
        this.timePointOfLastCorrectionsValidity = timePointOfLastCorrectionsValidity;
        this.scoringScheme = scoringScheme;
        this.comment = comment;
        this.higherScoresIsBetter = higherScoreIsBetter;
        this.hasOverallDetails = hasOverallDetails;
    }

    private void initCollections() {
        this.competitorOrderingPerRaceColumnName = new HashMap<String, List<CompetitorDTO>>();
        this.suppressedCompetitors = new ArrayList<CompetitorDTO>();
    }

    protected LeaderboardDTO(String id, BoatClassDTO boatClass) {
        super(boatClass);
        this.initCollections();
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Iterable<CompetitorDTO> getSuppressedCompetitors() {
        return this.suppressedCompetitors;
    }

    public void setSuppressedCompetitors(List<CompetitorDTO> suppressedCompetitors) {
        this.suppressedCompetitors = suppressedCompetitors;
    }

    public void setSuppressed(CompetitorDTO competitor, boolean suppressed) {
        if (suppressed && !this.suppressedCompetitors.contains(competitor)) {
            this.suppressedCompetitors.add(competitor);
        } else {
            this.suppressedCompetitors.remove(competitor);
        }
    }

    public boolean isHigherScoreBetter() {
        return this.higherScoresIsBetter;
    }

    public BoatDTO getBoatOfCompetitor(String raceColumnName, CompetitorDTO competitor) {
        LeaderboardRowDTO leaderboardRow;
        BoatDTO result = null;
        if (this.rows != null && (leaderboardRow = (LeaderboardRowDTO)this.rows.get(competitor)) != null) {
            if (this.canBoatsOfCompetitorsChangePerRace) {
                LeaderboardEntryDTO leaderboardEntry = leaderboardRow.fieldsByRaceColumnName.get(raceColumnName);
                if (leaderboardEntry != null) {
                    result = leaderboardEntry.boat;
                }
            } else {
                result = leaderboardRow.boat;
            }
        }
        return result;
    }

    public void setBoatOfCompetitor(CompetitorWithBoatDTO competitor, BoatDTO boat) {
        LeaderboardRowDTO leaderboardRowDTO;
        if (this.rows != null && !this.canBoatsOfCompetitorsChangePerRace && (leaderboardRowDTO = (LeaderboardRowDTO)this.rows.get(competitor)) != null) {
            leaderboardRowDTO.boat = boat;
        }
    }

    public void setBoatOfCompetitorForRace(String raceColumnName, CompetitorWithBoatDTO competitor, BoatDTO boat) {
        LeaderboardEntryDTO leaderboardEntry;
        LeaderboardRowDTO leaderboardRow;
        if (this.rows != null && this.canBoatsOfCompetitorsChangePerRace && (leaderboardRow = (LeaderboardRowDTO)this.rows.get(competitor)) != null && (leaderboardEntry = leaderboardRow.fieldsByRaceColumnName.get(raceColumnName)) != null) {
            leaderboardEntry.boat = boat;
        }
    }

    public void setCompetitorsFromBestToWorst(String raceColumnName, List<CompetitorDTO> orderedCompetitors) {
        this.competitorOrderingPerRaceColumnName.put(raceColumnName, orderedCompetitors);
    }

    public void setCompetitorsFromBestToWorst(RaceColumnDTO raceColumn, List<CompetitorDTO> newOrdering) {
        this.setCompetitorsFromBestToWorst(raceColumn.getName(), newOrdering);
    }

    public void setCompetitorOrderingPerRace(Map<String, List<CompetitorDTO>> competitorOrderingPerRaceColumnName) {
        this.competitorOrderingPerRaceColumnName = competitorOrderingPerRaceColumnName;
    }

    public Map<String, List<CompetitorDTO>> getCompetitorOrderingPerRaceColumnName() {
        return this.competitorOrderingPerRaceColumnName;
    }

    public List<CompetitorDTO> getCompetitorsFromBestToWorst(String raceColumnName) {
        return this.competitorOrderingPerRaceColumnName.get(raceColumnName);
    }

    public List<CompetitorDTO> getCompetitorsFromBestToWorst(RaceColumnDTO raceColumn) {
        return this.competitorOrderingPerRaceColumnName.get(raceColumn.getName());
    }

    public int getTotalRank(CompetitorDTO competitor) {
        return this.competitors.indexOf(competitor) + 1;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getTimePointOfLastCorrectionsValidity() {
        return this.timePointOfLastCorrectionsValidity;
    }

    public Date getTimePoint() {
        return this.timePoint;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (this.competitors == null ? 0 : this.competitors.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && (this.competitors != null || (LeaderboardDTO)((Object)this.competitors) == null && this.competitors.equals(((LeaderboardDTO)obj).competitors));
        {
        }
    }

    public void setTimePointOfLastCorrectionsValidity(Date timePointOfLastCorrectionsValidity) {
        this.timePointOfLastCorrectionsValidity = timePointOfLastCorrectionsValidity;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean hasOverallDetails() {
        return this.hasOverallDetails;
    }

    public static interface UUIDGenerator {
        public String generateRandomUUID();
    }
}

