/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sse.common.Distance;

public enum RowingBoatClassMasterdata {
    ROWING_BOAT("Rowing Boat", 8.0, 0.8, 2, "RowingBoat");

    private final String displayName;
    private final String[] alternativeNames;
    private final double hullLengthInMeter;
    private final double hullBeamInMeter;
    private final int seats;

    private RowingBoatClassMasterdata(String displayName, double hullLengthInMeter, double hullBeamInMeter, int seats, String ... alternativeNames) {
        this.displayName = displayName;
        this.hullLengthInMeter = hullLengthInMeter;
        this.hullBeamInMeter = hullBeamInMeter;
        this.seats = seats;
        this.alternativeNames = alternativeNames;
    }

    private RowingBoatClassMasterdata(String displayName, double hullLengthInMeter, double hullBeamInMeter, int seats) {
        this.displayName = displayName;
        this.hullLengthInMeter = hullLengthInMeter;
        this.hullBeamInMeter = hullBeamInMeter;
        this.seats = seats;
        this.alternativeNames = null;
    }

    public static RowingBoatClassMasterdata resolveBoatClass(String boatClassName) {
        String boatClassNameToResolve = RowingBoatClassMasterdata.unifyBoatClassName(boatClassName);
        RowingBoatClassMasterdata[] rowingBoatClassMasterdataArray = RowingBoatClassMasterdata.values();
        int n = rowingBoatClassMasterdataArray.length;
        int n2 = 0;
        while (n2 < n) {
            RowingBoatClassMasterdata boatClass = rowingBoatClassMasterdataArray[n2];
            if (RowingBoatClassMasterdata.unifyBoatClassName(boatClass.displayName).equals(boatClassNameToResolve)) {
                return boatClass;
            }
            if (boatClass.alternativeNames != null) {
                String[] stringArray = boatClass.alternativeNames;
                int n3 = boatClass.alternativeNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name = stringArray[n4];
                    if (RowingBoatClassMasterdata.unifyBoatClassName(name).equals(boatClassNameToResolve)) {
                        return boatClass;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public static String unifyBoatClassName(String boatClassName) {
        return boatClassName == null ? null : boatClassName.toUpperCase().replaceAll("\\s+", "");
    }

    public Distance getHullLength() {
        return new MeterDistance(this.hullLengthInMeter);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String[] getAlternativeNames() {
        return this.alternativeNames == null ? new String[]{} : this.alternativeNames;
    }

    public Distance getHullBeam() {
        return new MeterDistance(this.hullBeamInMeter);
    }

    public int getSeats() {
        return this.seats;
    }
}

