/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared;

import com.sap.sse.common.NamedWithID;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.WildcardPermission;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public abstract class RolePrototype
implements NamedWithID {
    private static final long serialVersionUID = -3911998376131317304L;
    private final UUID id;
    private final String name;
    private final Set<WildcardPermission> permissions;

    protected RolePrototype(String name, String uuidAsString, Iterable<? extends HasPermissions> permissions) {
        this(name, uuidAsString, RolePrototype.getWildcardPermissions(permissions));
    }

    private static WildcardPermission[] getWildcardPermissions(Iterable<? extends HasPermissions> permissions) {
        WildcardPermission[] result = new WildcardPermission[Util.size(permissions)];
        int i = 0;
        for (HasPermissions hasPermissions : permissions) {
            result[i++] = hasPermissions.getPermission(new HasPermissions.Action[0]);
        }
        return result;
    }

    protected RolePrototype(String name, String uuidAsString, WildcardPermission ... permissions) {
        this.name = name;
        this.id = UUID.fromString(uuidAsString);
        this.permissions = new HashSet<WildcardPermission>();
        WildcardPermission[] wildcardPermissionArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            WildcardPermission p = wildcardPermissionArray[n2];
            this.permissions.add(p);
            ++n2;
        }
    }

    public String getName() {
        return this.name;
    }

    public UUID getId() {
        return this.id;
    }

    public Set<WildcardPermission> getPermissions() {
        return this.permissions;
    }

    public void setName(String newName) {
        throw new UnsupportedOperationException("Cannot change the name of role " + this.getName());
    }

    public void setPermissions(Iterable<WildcardPermission> permissions) {
        throw new UnsupportedOperationException("Cannot change the permissions of role " + this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RolePrototype other = (RolePrototype)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

