/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.operationaltransformation;

import com.sap.sse.operationaltransformation.ClientServerOperationPair;
import com.sap.sse.operationaltransformation.Operation;
import com.sap.sse.operationaltransformation.Peer;
import com.sap.sse.operationaltransformation.Transformer;
import com.sap.sse.operationaltransformation.UnmergedOperationsQueue;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PeerImpl<O extends Operation<S>, S>
implements Peer<O, S> {
    private static final Logger logger = Logger.getLogger(PeerImpl.class.getName());
    private final String name;
    private volatile S currentState;
    private final Peer.Role role;
    private volatile int scheduledOrRunning = 0;
    private final ConcurrentMap<Peer<O, S>, UnmergedOperationsQueue<O, S>> unmergedOperationsForPeer = new ConcurrentHashMap<Peer<O, S>, UnmergedOperationsQueue<O, S>>();
    private final Map<Peer<O, S>, Integer> numberOfMergedOperations = new HashMap<Peer<O, S>, Integer>();
    private final Transformer<S, O> transformer;
    private final ExecutorService merger;

    public PeerImpl(Transformer<S, O> transformer, S initialState, Peer.Role role) {
        this(null, transformer, initialState, role);
    }

    public PeerImpl(String name, Transformer<S, O> transformer, S initialState, Peer.Role role) {
        this.transformer = transformer;
        this.currentState = initialState;
        this.role = role;
        this.merger = this.createMerger();
        this.name = name;
    }

    public PeerImpl(Transformer<S, O> transformer, Peer<O, S> server) {
        this(null, transformer, server);
    }

    public PeerImpl(String name, Transformer<S, O> transformer, Peer<O, S> server) {
        this(name, transformer, null, Peer.Role.CLIENT);
        this.currentState = server.addPeer(this);
        this.addPeer(server);
    }

    public void finalize() {
        this.merger.shutdown();
    }

    private ExecutorService createMerger() {
        return ThreadPoolUtil.INSTANCE.createForegroundTaskThreadPoolExecutor(1, String.valueOf(this.getClass().getName()) + " " + this.name + " " + UUID.randomUUID());
    }

    private Transformer<S, O> getTransformer() {
        return this.transformer;
    }

    @Override
    public S addPeer(Peer<O, S> peer) {
        if (this.role == Peer.Role.CLIENT && this.getPeers().size() > 0) {
            throw new RuntimeException("A client must be connected to at most one server");
        }
        this.unmergedOperationsForPeer.put(peer, new UnmergedOperationsQueue());
        this.numberOfMergedOperations.put(peer, 0);
        return this.getCurrentState();
    }

    private Collection<Peer<O, S>> getPeers() {
        return this.unmergedOperationsForPeer.keySet();
    }

    @Override
    public S getCurrentState() {
        return this.currentState;
    }

    @Override
    public synchronized void apply(O operation) {
        this.taskScheduled();
        try {
            try {
                this.currentState = operation.applyTo(this.currentState);
                this.updatePeers(operation, null);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception during executing task in peer " + this, e);
                throw e;
            }
        }
        finally {
            this.taskFinished();
        }
    }

    @Override
    public synchronized void apply(final Peer<O, S> source, O operation, int numberOfOperationsSourceHasMergedFromThis) {
        this.taskScheduled();
        try {
            try {
                if (!this.getPeers().contains(source)) {
                    throw new RuntimeException("Peer " + source + " not registered with peer " + this);
                }
                Object transformedOp = operation;
                UnmergedOperationsQueue unmergedOperationsForSource = (UnmergedOperationsQueue)this.unmergedOperationsForPeer.get(source);
                int localOpNumber = numberOfOperationsSourceHasMergedFromThis;
                for (Operation unconfirmedOperation : unmergedOperationsForSource.getUnmergedOperations(numberOfOperationsSourceHasMergedFromThis)) {
                    ClientServerOperationPair pair;
                    if (this.role == Peer.Role.SERVER) {
                        pair = transformedOp == null || unconfirmedOperation == null ? new ClientServerOperationPair((Operation)transformedOp, unconfirmedOperation) : this.getTransformer().transform((Operation)transformedOp, unconfirmedOperation);
                        transformedOp = pair.getClientOp();
                        unmergedOperationsForSource.updateWithTransformed(localOpNumber, pair.getServerOp());
                    } else {
                        pair = transformedOp == null || unconfirmedOperation == null ? new ClientServerOperationPair(unconfirmedOperation, (Operation)transformedOp) : this.getTransformer().transform(unconfirmedOperation, (Operation)transformedOp);
                        transformedOp = pair.getServerOp();
                        unmergedOperationsForSource.updateWithTransformed(localOpNumber, pair.getClientOp());
                    }
                    ++localOpNumber;
                }
                if (transformedOp != null) {
                    this.currentState = transformedOp.applyTo(this.currentState);
                }
                final int numberOfMergedOperationsFromSource = this.numberOfMergedOperations.get(source) + 1;
                this.numberOfMergedOperations.put(source, numberOfMergedOperationsFromSource);
                this.scheduleTask(new Runnable(){

                    @Override
                    public void run() {
                        source.confirm(PeerImpl.this, numberOfMergedOperationsFromSource);
                    }
                });
                this.updatePeers(transformedOp, source);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception during executing task in peer " + this, e);
                throw e;
            }
        }
        finally {
            this.taskFinished();
        }
    }

    private synchronized void updatePeers(O operation, Peer<O, S> except) {
        for (final Peer<O, S> peer : this.getPeers()) {
            if (except != null && except.equals(peer)) continue;
            ((UnmergedOperationsQueue)this.unmergedOperationsForPeer.get(peer)).sentOutOperation(operation);
            int numberOfMergedOpsForPeer = this.numberOfMergedOperations.get(peer);
            this.scheduleTask(new Runnable((Operation)operation, numberOfMergedOpsForPeer){
                private final /* synthetic */ Operation val$operation;
                private final /* synthetic */ int val$numberOfMergedOpsForPeer;
                {
                    this.val$operation = operation;
                    this.val$numberOfMergedOpsForPeer = n;
                }

                @Override
                public void run() {
                    peer.apply(PeerImpl.this, this.val$operation, this.val$numberOfMergedOpsForPeer);
                }
            });
        }
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return String.valueOf(this.role == Peer.Role.SERVER ? "server" : "client") + " " + super.toString();
    }

    @Override
    public synchronized void confirm(Peer<O, S> source, int numberOfMergedOperations) {
        ((UnmergedOperationsQueue)this.unmergedOperationsForPeer.get(source)).confirm(numberOfMergedOperations);
    }

    private void scheduleTask(final Runnable runnable) {
        this.taskScheduled();
        this.merger.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Exception during executing task in peer " + PeerImpl.this, e);
                        throw e;
                    }
                }
                finally {
                    PeerImpl.this.taskFinished();
                }
            }
        });
    }

    private synchronized void taskScheduled() {
        logger.fine(this + " taskScheduled incrementing scheduleOrRunning from " + this.scheduledOrRunning + " to " + (this.scheduledOrRunning + 1));
        ++this.scheduledOrRunning;
    }

    private synchronized void taskFinished() {
        logger.fine(this + " taskFinished decrementing scheduleOrRunning from " + this.scheduledOrRunning + " to " + (this.scheduledOrRunning - 1));
        --this.scheduledOrRunning;
        if (this.scheduledOrRunning == 0) {
            logger.fine(this + " taskFinished notifying waiters");
            this.notifyAll();
        }
    }

    @Override
    public synchronized void waitForNotRunning() {
        while (this.scheduledOrRunning > 0) {
            try {
                this.wait();
                logger.fine(this + " waitForNotRunning scheduleOrRunning: " + this.scheduledOrRunning);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

