/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.shared.util.impl;

import com.sap.sse.common.ReverseRandomAccessList;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class ArrayListNavigableSet<E>
extends AbstractSet<E>
implements NavigableSet<E>,
Serializable {
    private static final long serialVersionUID = 6923963699509907975L;
    private final List<E> list;
    private final Comparator<? super E> comparator;

    public ArrayListNavigableSet(Comparator<? super E> comparator) {
        this.list = new ArrayList();
        this.comparator = comparator;
    }

    public ArrayListNavigableSet(int initialSize, Comparator<? super E> comparator) {
        this.list = new ArrayList(initialSize);
        this.comparator = comparator;
    }

    private ArrayListNavigableSet(List<E> list, Comparator<? super E> comparator) {
        this.list = list;
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public E first() {
        try {
            return this.list.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    @Override
    public E last() {
        try {
            return this.list.get(this.list.size() - 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.binarySearch(o) >= 0;
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean result;
        int pos = this.binarySearch(e);
        if (pos >= 0) {
            result = false;
        } else {
            this.list.add(-pos - 1, e);
            result = true;
        }
        return result;
    }

    private int binarySearch(E e) {
        int result = this.list.isEmpty() || this.comparator().compare(e, this.first()) < 0 ? -1 : (this.comparator().compare(e, this.last()) > 0 ? -this.size() - 1 : Collections.binarySearch(this.list, e, this.comparator()));
        return result;
    }

    @Override
    public boolean remove(Object o) {
        int pos = this.binarySearch(o);
        if (pos >= 0) {
            this.list.remove(pos);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = false;
        for (E e : c) {
            boolean bl = result = this.add(e) || result;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public E lower(E e) {
        int pos = this.binarySearch(e);
        Object result = pos >= 0 ? (pos > 0 ? this.list.get(pos - 1) : null) : (-pos - 2 >= 0 ? this.list.get(-pos - 2) : null);
        return result;
    }

    @Override
    public E floor(E e) {
        int pos = this.binarySearch(e);
        Object result = pos >= 0 ? this.list.get(pos) : (-pos - 2 >= 0 ? this.list.get(-pos - 2) : null);
        return result;
    }

    @Override
    public E ceiling(E e) {
        int pos = this.binarySearch(e);
        Object result = pos >= 0 ? this.list.get(pos) : (-pos - 1 < this.list.size() ? this.list.get(-pos - 1) : null);
        return result;
    }

    @Override
    public E higher(E e) {
        int pos = this.binarySearch(e);
        E result = pos >= 0 ? (pos < this.list.size() - 1 ? (E)this.list.get(pos + 1) : null) : (-pos - 1 < this.list.size() ? (E)this.list.get(-pos - 1) : null);
        return result;
    }

    @Override
    public E pollFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.list.remove(0);
    }

    @Override
    public E pollLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.list.remove(this.list.size() - 1);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < ArrayListNavigableSet.this.list.size();
            }

            @Override
            public E next() {
                if (this.i >= ArrayListNavigableSet.this.list.size()) {
                    throw new NoSuchElementException();
                }
                return ArrayListNavigableSet.this.list.get(this.i++);
            }

            @Override
            public void remove() {
                if (this.i == 0) {
                    throw new IllegalStateException();
                }
                ArrayListNavigableSet.this.list.remove(--this.i);
            }
        };
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new ArrayListNavigableSet<E>(new ReverseRandomAccessList(this.list), this.comparator());
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new Iterator<E>(){
            private int i;
            {
                this.i = ArrayListNavigableSet.this.list.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public E next() {
                if (this.i < 0) {
                    throw new NoSuchElementException();
                }
                return ArrayListNavigableSet.this.list.get(this.i--);
            }

            @Override
            public void remove() {
                if (this.i == ArrayListNavigableSet.this.list.size() - 1) {
                    throw new IllegalStateException();
                }
                ArrayListNavigableSet.this.list.remove(this.i);
            }
        };
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        int from = this.binarySearch(fromElement);
        if (from < 0) {
            from = -from - 1;
        } else if (!fromInclusive) {
            ++from;
        }
        int to = this.binarySearch(toElement);
        if (to < 0) {
            to = -to - 1;
        } else if (toInclusive) {
            ++to;
        }
        if (to < from) {
            to = from;
        }
        return new ArrayListNavigableSet<E>(this.subList(from, to), this.comparator());
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        int to = this.binarySearch(toElement);
        if (to < 0) {
            to = -to - 1;
        } else if (inclusive) {
            ++to;
        }
        if (to < 0) {
            to = 0;
        }
        return new ArrayListNavigableSet<E>(this.subList(0, to), this.comparator());
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        int from = this.binarySearch(fromElement);
        if (from < 0) {
            from = -from - 1;
        } else if (!inclusive) {
            ++from;
        }
        if (from > this.list.size()) {
            from = this.list.size();
        }
        return new ArrayListNavigableSet<E>(this.subList(from, this.list.size()), this.comparator());
    }

    private List<E> subList(int from, int to) {
        return this.list.subList(from, to);
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, false);
    }

    @Override
    public String toString() {
        return this.list.toString();
    }
}

