/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.shared.media.impl;

import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.impl.AbstractMediaDescriptor;
import java.net.URL;

public class ImageDescriptorImpl
extends AbstractMediaDescriptor
implements ImageDescriptor {
    private static final long serialVersionUID = -702731462768602331L;
    private Integer widthInPx;
    private Integer heightInPx;

    public ImageDescriptorImpl(URL imageURL, TimePoint createdAtDate) {
        super(imageURL, MimeType.image, createdAtDate);
    }

    @Override
    public Integer getWidthInPx() {
        return this.widthInPx;
    }

    @Override
    public Integer getHeightInPx() {
        return this.heightInPx;
    }

    @Override
    public void setSize(Util.Pair<Integer, Integer> size) {
        if (size != null) {
            this.widthInPx = (Integer)size.getA();
            this.heightInPx = (Integer)size.getB();
        } else {
            this.widthInPx = null;
            this.heightInPx = null;
        }
    }

    @Override
    public void setSize(Integer widthInPx, Integer heightInPx) {
        this.widthInPx = widthInPx;
        this.heightInPx = heightInPx;
    }

    @Override
    public boolean hasSize() {
        return this.widthInPx != null && this.heightInPx != null;
    }

    @Override
    public int getArea() {
        if (this.hasSize()) {
            return this.widthInPx * this.heightInPx;
        }
        return 0;
    }
}

