/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.shared.media.impl;

import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.shared.media.MediaDescriptor;
import java.io.Serializable;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractMediaDescriptor
implements MediaDescriptor,
Serializable {
    private static final long serialVersionUID = -6671425870632517274L;
    protected String title;
    protected String subtitle;
    protected TimePoint createdAtDate;
    protected String copyright;
    protected MimeType mimeType;
    protected Set<String> tags = new LinkedHashSet<String>();
    protected URL url;
    protected Locale locale;

    public AbstractMediaDescriptor(URL url, MimeType mimeType, TimePoint createdAtDate) {
        this.mimeType = mimeType;
        this.url = url;
        this.createdAtDate = createdAtDate;
    }

    @Override
    public MimeType getMimeType() {
        return this.mimeType;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(Iterable<String> tags) {
        this.tags.clear();
        if (tags != null) {
            Util.addAll(tags, this.tags);
        }
    }

    @Override
    public boolean addTag(String tagName) {
        return this.tags.add(tagName);
    }

    @Override
    public boolean removeTag(String tagName) {
        return this.tags.remove(tagName);
    }

    @Override
    public String getSubtitle() {
        return this.subtitle;
    }

    @Override
    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    @Override
    public TimePoint getCreatedAtDate() {
        return this.createdAtDate;
    }

    @Override
    public void setCreatedAtDate(TimePoint createdAtDate) {
        this.createdAtDate = createdAtDate;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public boolean hasTag(String tagName) {
        return this.tags.contains(tagName);
    }
}

