/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.trackfiles.impl;

import com.sap.sailing.server.gateway.trackfiles.impl.ImportResult;
import com.sap.sse.common.Util;
import java.util.List;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class ImportResultSerializer {
    ImportResultSerializer() {
    }

    static JSONObject serializeImportResult(ImportResult result) {
        JSONObject json = new JSONObject();
        json.put((Object)"errors", (Object)ImportResultSerializer.serializeErrorList(result.getErrorList()));
        json.put((Object)"uploads", (Object)ImportResultSerializer.serializeTrackList(result.getImportResult()));
        return json;
    }

    static <R> JSONArray serializeIterable(Iterable<? extends R> list, Function<? super R, ?> mapping) {
        JSONArray json = new JSONArray();
        StreamSupport.stream(list.spliterator(), false).map(mapping).forEach(arg_0 -> json.add(arg_0));
        return json;
    }

    static JSONArray serializeTrackList(List<ImportResult.TrackImportDTO> trackList) {
        return ImportResultSerializer.serializeIterable(trackList, track -> track.getDevice().toString());
    }

    static JSONArray serializeErrorList(List<ImportResult.ErrorImportDTO> errorList) {
        return ImportResultSerializer.serializeIterable(errorList, ImportResultSerializer::serializeError);
    }

    public static JSONArray serializeRaceList(List<Util.Triple<String, String, String>> raceNameRaceColumnNameFleetnameList) {
        return ImportResultSerializer.serializeIterable(raceNameRaceColumnNameFleetnameList, ImportResultSerializer::serializeRaceEntry);
    }

    private static JSONObject serializeRaceEntry(Util.Triple<String, String, String> entry) {
        JSONObject json = new JSONObject();
        json.put((Object)"raceName", entry.getA());
        json.put((Object)"raceColumnName", entry.getB());
        json.put((Object)"fleetName", entry.getC());
        return json;
    }

    private static JSONObject serializeError(ImportResult.ErrorImportDTO error) {
        JSONObject json = new JSONObject();
        json.put((Object)"filename", (Object)error.getFilename());
        json.put((Object)"requestedImporter", (Object)error.getRequestedImporter());
        json.put((Object)"exUUID", (Object)error.getExUUID());
        json.put((Object)"className", (Object)error.getName());
        json.put((Object)"message", (Object)error.getMessage());
        return json;
    }
}

