/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.base.LeaderboardSearchResult;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.server.gateway.serialization.impl.CourseAreaJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.EventBaseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.LeaderboardGroupBaseJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.LeaderboardSearchResultJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.TrackingConnectorInfoJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.VenueJsonSerializer;
import com.sap.sailing.server.interfaces.KeywordQueryWithOptionalEventQualification;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.Util;
import com.sap.sse.common.search.Result;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.json.simple.JSONArray;

@Path(value="/v1/search")
public class SearchResource
extends AbstractSailingServerResource {
    private final JsonSerializer<LeaderboardSearchResult> serializer;

    public SearchResource() {
        LeaderboardGroupBaseJsonSerializer leaderboardGroupSerializer = new LeaderboardGroupBaseJsonSerializer();
        CourseAreaJsonSerializer courseAreaSerializer = new CourseAreaJsonSerializer();
        this.serializer = new LeaderboardSearchResultJsonSerializer((JsonSerializer)new EventBaseJsonSerializer((JsonSerializer)new VenueJsonSerializer((JsonSerializer)courseAreaSerializer), (JsonSerializer)leaderboardGroupSerializer, (JsonSerializer)new TrackingConnectorInfoJsonSerializer()), (JsonSerializer)leaderboardGroupSerializer);
    }

    private Result<LeaderboardSearchResult> search(KeywordQueryWithOptionalEventQualification query) {
        return this.getService().search(query);
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response search(@QueryParam(value="q") String keywords, @QueryParam(value="include") Boolean include, @QueryParam(value="eventId") List<UUID> eventIds) {
        KeywordQueryWithOptionalEventQualification query = new KeywordQueryWithOptionalEventQualification(Util.splitAlongWhitespaceRespectingDoubleQuotedPhrases((String)keywords), include == null ? false : include, eventIds);
        Iterable searchResults = this.search(query).getHits();
        JSONArray jsonSearchResults = new JSONArray();
        for (LeaderboardSearchResult searchResult : searchResults) {
            if (searchResult.getLeaderboard() != null && !this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)searchResult.getLeaderboard()) || searchResult.getRegatta() != null && !this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)searchResult.getRegatta()) || searchResult.getLeaderboard() != null && !this.checkAll(searchResult.getLeaderboardGroups())) continue;
            jsonSearchResults.add((Object)this.serializer.serialize((Object)searchResult));
        }
        return Response.ok((Object)jsonSearchResults.toJSONString()).header("Content-Type", (Object)"application/json;charset=UTF-8").build();
    }

    private boolean checkAll(Iterable<LeaderboardGroup> leaderboardGroups) {
        boolean result = true;
        for (LeaderboardGroup leaderboardGroup : leaderboardGroups) {
            if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroup)) continue;
            result = false;
        }
        return result;
    }
}

