/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.jaxrs.api;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.MetaLeaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.gateway.jaxrs.api.AbstractLeaderboardsResource;
import com.sap.sailing.server.hierarchy.SailingHierarchyOwnershipUpdater;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.util.RaceBoardLinkFactory;
import com.sap.sailing.shared.server.gateway.jaxrs.AbstractSailingServerResource;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.util.impl.UUIDHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.function.Function;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

@Path(value="/v1/leaderboardgroups")
public class LeaderboardGroupsResource
extends AbstractSailingServerResource {
    public static final String IDENTIFIABLE = "/identifiable";
    public static final String V1_LEADERBOARDGROUPS = "/v1/leaderboardgroups";
    protected static final String NAME_OR_UUID_PATH_PARAM = "nameOrUUID";
    protected static final String COPY_MEMBERS_AND_ROLES_QUERY_PARAM = "copyMembersAndRoles";
    protected static final String MIGRATE_BOATS_QUERY_PARAM = "migrateBoats";
    protected static final String MIGRATE_COMPETITORS_QUERY_PARAM = "migrateCompetitors";
    protected static final String NEW_GROUP_NAME_QUERY_PARAM = "newGroupName";
    protected static final String EXISTING_GROUP_ID_QUERY_PARAM = "existingGroupId";
    protected static final String CREATE_NEW_GROUP_QUERY_PARAM = "createNewGroup";
    protected static final String NAME_PATH_PARAM = "name";

    @POST
    @Path(value="/{name}/migrate")
    public Response migrateOwnershipForLeaderboardGroup(@PathParam(value="name") String leaderboardGroupName, @QueryParam(value="createNewGroup") Boolean createNewGroup, @QueryParam(value="existingGroupId") UUID existingGroupIdOrNull, @QueryParam(value="newGroupName") String newGroupName, @QueryParam(value="migrateCompetitors") Boolean migrateCompetitors, @QueryParam(value="migrateBoats") Boolean migrateBoats, @QueryParam(value="copyMembersAndRoles") Boolean copyMembersAndRoles) throws ParseException, JsonDeserializationException {
        LeaderboardGroup leaderboardGroup = this.getService().getLeaderboardGroupByName(leaderboardGroupName);
        SailingHierarchyOwnershipUpdater updater = SailingHierarchyOwnershipUpdater.createOwnershipUpdater((boolean)createNewGroup, (UUID)existingGroupIdOrNull, (String)newGroupName, (boolean)migrateCompetitors, (boolean)migrateBoats, (boolean)(copyMembersAndRoles == null ? true : copyMembersAndRoles), (RacingEventService)this.getService());
        updater.updateGroupOwnershipForLeaderboardGroupHierarchy(leaderboardGroup);
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getLeaderboardGroups() {
        JSONArray jsonLeaderboardGroups = this.getLeaderboardGroups(leaderboardGroup -> leaderboardGroup.getName());
        return Response.ok((Object)this.streamingOutput(jsonLeaderboardGroups)).build();
    }

    private JSONArray getLeaderboardGroups(Function<LeaderboardGroup, Object> resultObjectSupplier) {
        JSONArray jsonLeaderboardGroups = new JSONArray();
        for (LeaderboardGroup leaderboardGroupEntry : this.getService().getLeaderboardGroups().values()) {
            if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroupEntry)) continue;
            jsonLeaderboardGroups.add(resultObjectSupplier.apply(leaderboardGroupEntry));
        }
        return jsonLeaderboardGroups;
    }

    @GET
    @Path(value="/identifiable")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getLeaderboardGroupsIdentifiable() {
        JSONArray jsonLeaderboardGroups = this.getLeaderboardGroups(leaderboardGroup -> {
            JSONObject leaderboardGroupObject = new JSONObject();
            leaderboardGroupObject.put((Object)"id", (Object)leaderboardGroup.getId().toString());
            leaderboardGroupObject.put((Object)NAME_PATH_PARAM, (Object)leaderboardGroup.getName());
            return leaderboardGroupObject;
        });
        return Response.ok((Object)this.streamingOutput(jsonLeaderboardGroups)).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="{nameOrUUID}")
    public Response getLeaderboardGroup(@PathParam(value="nameOrUUID") String leaderboardGroupName) {
        Response response;
        Serializable uuid = UUIDHelper.tryUuidConversion((Serializable)((Object)leaderboardGroupName));
        LeaderboardGroup leaderboardGroup = uuid != leaderboardGroupName ? this.getService().getLeaderboardGroupByID((UUID)uuid) : this.getService().getLeaderboardGroupByName(leaderboardGroupName);
        if (leaderboardGroup == null) {
            response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Could not find a leaderboard group with name '" + StringEscapeUtils.escapeHtml((String)leaderboardGroupName) + "'.")).type("text/plain").build();
        } else if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboardGroup)) {
            TimePoint timePoint = MillisecondsTimePoint.now();
            JSONObject jsonLeaderboardGroup = new JSONObject();
            jsonLeaderboardGroup.put((Object)NAME_PATH_PARAM, (Object)leaderboardGroup.getName());
            jsonLeaderboardGroup.put((Object)"id", (Object)leaderboardGroup.getId().toString());
            jsonLeaderboardGroup.put((Object)"displayName", (Object)leaderboardGroup.getDisplayName());
            jsonLeaderboardGroup.put((Object)"description", (Object)leaderboardGroup.getDescription());
            jsonLeaderboardGroup.put((Object)"timepoint", (Object)timePoint.toString());
            jsonLeaderboardGroup.put((Object)"timepoint-ms", (Object)timePoint.asMillis());
            jsonLeaderboardGroup.put((Object)"hasOverallLeaderboard", (Object)leaderboardGroup.hasOverallLeaderboard());
            if (leaderboardGroup.hasOverallLeaderboard()) {
                jsonLeaderboardGroup.put((Object)"overallLeaderboardName", (Object)leaderboardGroup.getOverallLeaderboardName());
            }
            HashSet<Event> eventsReferencingLeaderboardGroup = new HashSet<Event>();
            JSONArray idsOfEventsReferencingLeaderboardGroup = new JSONArray();
            for (Event event : this.getService().getAllEvents()) {
                if (!Util.contains((Iterable)event.getLeaderboardGroups(), (Object)leaderboardGroup)) continue;
                eventsReferencingLeaderboardGroup.add(event);
                idsOfEventsReferencingLeaderboardGroup.add((Object)event.getId().toString());
            }
            jsonLeaderboardGroup.put((Object)"events", (Object)idsOfEventsReferencingLeaderboardGroup);
            JSONArray jsonLeaderboardEntries = new JSONArray();
            jsonLeaderboardGroup.put((Object)"leaderboards", (Object)jsonLeaderboardEntries);
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                if (!this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard)) continue;
                boolean isMetaLeaderboard = leaderboard instanceof MetaLeaderboard;
                boolean isRegattaLeaderboard = leaderboard instanceof RegattaLeaderboard;
                JSONObject jsonLeaderboard = new JSONObject();
                jsonLeaderboard.put((Object)NAME_PATH_PARAM, (Object)leaderboard.getName());
                jsonLeaderboard.put((Object)"displayName", (Object)leaderboard.getDisplayName());
                jsonLeaderboard.put((Object)"isMetaLeaderboard", (Object)isMetaLeaderboard);
                jsonLeaderboard.put((Object)"isRegattaLeaderboard", (Object)isRegattaLeaderboard);
                JSONArray discardIndices = AbstractLeaderboardsResource.getDiscardingRuleAsJson(leaderboard);
                if (discardIndices != null) {
                    jsonLeaderboard.put((Object)"discardIndexResultsStartingWithHowManyRaces", (Object)discardIndices);
                }
                jsonLeaderboardEntries.add((Object)jsonLeaderboard);
                SettableScoreCorrection scoreCorrection = leaderboard.getScoreCorrection();
                if (scoreCorrection != null) {
                    jsonLeaderboard.put((Object)"scoringComment", (Object)scoreCorrection.getComment());
                    TimePoint lastUpdateTimepoint = scoreCorrection.getTimePointOfLastCorrectionsValidity();
                    jsonLeaderboard.put((Object)"lastScoringUpdate", lastUpdateTimepoint != null ? lastUpdateTimepoint.asDate().toString() : null);
                    jsonLeaderboard.put((Object)"lastScoringUpdate-ms", lastUpdateTimepoint != null ? Long.valueOf(lastUpdateTimepoint.asMillis()) : null);
                } else {
                    jsonLeaderboard.put((Object)"scoringComment", null);
                    jsonLeaderboard.put((Object)"lastScoringUpdate", null);
                }
                ArrayList<Util.Triple> seriesNameAndFleetsAndRaceColumnsOfSeries = new ArrayList<Util.Triple>();
                HashMap<String, Boolean> medalSeriesNames = new HashMap<String, Boolean>();
                if (isRegattaLeaderboard) {
                    RegattaLeaderboard regattaLeaderboard = (RegattaLeaderboard)leaderboard;
                    Regatta regatta = regattaLeaderboard.getRegatta();
                    jsonLeaderboard.put((Object)"scoringScheme", (Object)leaderboard.getScoringScheme().getType());
                    jsonLeaderboard.put((Object)"regattaName", (Object)regatta.getName());
                    for (Series series : regatta.getSeries()) {
                        ArrayList fleets = new ArrayList();
                        Util.addAll((Iterable)series.getFleets(), fleets);
                        seriesNameAndFleetsAndRaceColumnsOfSeries.add(new Util.Triple((Object)series.getName(), fleets, (Object)series.getRaceColumns()));
                        medalSeriesNames.put(series.getName(), series.isMedal());
                    }
                } else {
                    jsonLeaderboard.put((Object)"scoringScheme", (Object)leaderboard.getScoringScheme().getType());
                    jsonLeaderboard.put((Object)"regattaName", null);
                    seriesNameAndFleetsAndRaceColumnsOfSeries.add(new Util.Triple((Object)"Default", Collections.singleton(leaderboard.getFleet("Default")), (Object)leaderboard.getRaceColumns()));
                }
                JSONArray jsonSeriesEntries = new JSONArray();
                jsonLeaderboard.put((Object)"series", (Object)jsonSeriesEntries);
                for (Util.Triple e : seriesNameAndFleetsAndRaceColumnsOfSeries) {
                    JSONObject jsonSeries = new JSONObject();
                    jsonSeriesEntries.add((Object)jsonSeries);
                    jsonSeries.put((Object)NAME_PATH_PARAM, e.getA());
                    jsonSeries.put((Object)"isMedalSeries", medalSeriesNames.get(e.getA()));
                    JSONArray jsonFleetsEntries = new JSONArray();
                    jsonSeries.put((Object)"fleets", (Object)jsonFleetsEntries);
                    for (Fleet fleet : (Iterable)e.getB()) {
                        if (fleet == null) continue;
                        JSONObject jsonFleet = new JSONObject();
                        jsonFleet.put((Object)NAME_PATH_PARAM, (Object)fleet.getName());
                        jsonFleet.put((Object)"color", fleet.getColor() != null ? fleet.getColor().getAsHtml() : null);
                        jsonFleet.put((Object)"ordering", (Object)fleet.getOrdering());
                        jsonFleetsEntries.add((Object)jsonFleet);
                        JSONArray jsonRacesEntries = new JSONArray();
                        jsonFleet.put((Object)"races", (Object)jsonRacesEntries);
                        for (RaceColumn raceColumn : (Iterable)e.getC()) {
                            JSONObject jsonRaceColumn = new JSONObject();
                            jsonRaceColumn.put((Object)NAME_PATH_PARAM, (Object)raceColumn.getName());
                            jsonRaceColumn.put((Object)"isMedalRace", (Object)raceColumn.isMedalRace());
                            TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                            if (trackedRace != null) {
                                jsonRaceColumn.put((Object)"isTracked", (Object)true);
                                jsonRaceColumn.put((Object)"regattaName", (Object)trackedRace.getTrackedRegatta().getRegatta().getName());
                                jsonRaceColumn.put((Object)"trackedRaceName", (Object)trackedRace.getRace().getName());
                                jsonRaceColumn.put((Object)"trackingProviderType", (Object)trackedRace.getTrackingConnectorInfo().getTrackingConnectorName());
                                jsonRaceColumn.put((Object)"raceId", (Object)trackedRace.getRace().getId().toString());
                                JSONObject raceBoardURLsByEventID = new JSONObject();
                                for (Event event : eventsReferencingLeaderboardGroup) {
                                    if (!Util.containsAny((Iterable)event.getVenue().getCourseAreas(), (Iterable)leaderboard.getCourseAreas())) continue;
                                    raceBoardURLsByEventID.put((Object)event.getId().toString(), (Object)RaceBoardLinkFactory.createRaceBoardLink((TrackedRace)trackedRace, (Leaderboard)leaderboard, (Event)event, (LeaderboardGroup)leaderboardGroup, (String)"PLAYER", null));
                                }
                                jsonRaceColumn.put((Object)"raceViewerUrls", (Object)raceBoardURLsByEventID);
                                jsonRaceColumn.put((Object)"hasGpsData", (Object)trackedRace.hasGPSData());
                                jsonRaceColumn.put((Object)"hasWindData", (Object)trackedRace.hasWindData());
                            } else {
                                jsonRaceColumn.put((Object)"isTracked", (Object)false);
                                jsonRaceColumn.put((Object)"trackedRaceName", null);
                                jsonRaceColumn.put((Object)"trackingProviderType", null);
                                jsonRaceColumn.put((Object)"raceId", null);
                                jsonRaceColumn.put((Object)"hasGpsData", (Object)false);
                                jsonRaceColumn.put((Object)"hasWindData", (Object)false);
                            }
                            jsonRacesEntries.add((Object)jsonRaceColumn);
                        }
                    }
                }
            }
            response = Response.ok((Object)this.streamingOutput(jsonLeaderboardGroup)).build();
        } else {
            response = Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        return response;
    }
}

