/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway;

import com.sap.sailing.server.gateway.AbstractHttpPostServlet;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.Base64Utils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;

public abstract class HttpMessageSenderServletRequestHandler {
    private static final Logger logger = Logger.getLogger(AbstractHttpPostServlet.class.getName());
    private static final long timeoutInMilliseconds = 60000L;
    private long timeInMillisOfLastExpeditionMessageReceived;
    private boolean stop;
    private final PrintWriter writer;
    private final AbstractHttpPostServlet owner;

    public HttpMessageSenderServletRequestHandler(HttpServletResponse resp, AbstractHttpPostServlet owner) throws IOException {
        this.owner = owner;
        this.writer = resp.getWriter();
    }

    protected BundleContext getContext() {
        return this.owner.getContext();
    }

    protected RacingEventService getService() {
        return this.owner.getService();
    }

    protected PrintWriter getWriter() {
        return this.writer;
    }

    protected synchronized void stop() {
        this.stop = true;
        this.notifyAll();
    }

    private boolean isStopped() {
        return this.stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest() throws ServletException, IOException {
        this.stop = false;
        HeartbeatHandler heartbeat = new HeartbeatHandler(this.writer);
        Thread heartbeatHandler = new Thread((Runnable)heartbeat, String.valueOf(this.getClass().getName()) + " HeartbeatHandler " + Thread.currentThread().getId());
        heartbeatHandler.start();
        try {
            HttpMessageSenderServletRequestHandler httpMessageSenderServletRequestHandler = this;
            synchronized (httpMessageSenderServletRequestHandler) {
                this.timeInMillisOfLastExpeditionMessageReceived = System.currentTimeMillis();
                while (!this.isStopped() && System.currentTimeMillis() - this.timeInMillisOfLastExpeditionMessageReceived < 60000L) {
                    this.wait(this.timeInMillisOfLastExpeditionMessageReceived + 60000L - System.currentTimeMillis());
                }
            }
            if (this.isStopped()) {
                logger.info(String.valueOf(this.getClass().getName()) + " was explicitly stopped, e.g., because client closed connection");
            }
            logger.info("Terminating " + this.getClass().getName() + " doPost after not receiving anything for " + 60000L + "ms");
            heartbeat.stop();
            heartbeatHandler.join();
            if (!this.isStopped()) {
                this.stop();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void send(Writer writer, byte[] message) {
        String bytes = Base64Utils.toBase64((byte[])message);
        this.sendString(writer, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendString(Writer writer, String s) {
        this.timeInMillisOfLastExpeditionMessageReceived = System.currentTimeMillis();
        try {
            Writer writer2 = writer;
            synchronized (writer2) {
                writer.write(s);
                writer.write(0);
                writer.flush();
            }
        }
        catch (IOException e) {
            this.stop();
        }
    }

    private class HeartbeatHandler
    implements Runnable {
        private boolean stop = false;
        private final PrintWriter responseWriter;

        public HeartbeatHandler(PrintWriter responseWriter) {
            this.responseWriter = responseWriter;
        }

        public void stop() {
            this.stop = true;
        }

        @Override
        public void run() {
            try {
                while (!this.stop) {
                    HttpMessageSenderServletRequestHandler.this.sendString(this.responseWriter, "<pong>");
                    Thread.sleep(5000L);
                }
            }
            catch (Exception e) {
                logger.info("Terminating heartbeat on " + HttpMessageSenderServletRequestHandler.this.getClass().getName() + " because of exception " + e);
                logger.log(Level.SEVERE, "run", e);
            }
            HttpMessageSenderServletRequestHandler.this.stop();
        }
    }
}

