/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining.data.impl;

import com.sap.sse.common.Util;
import com.sap.sse.security.datamining.data.HasPreferenceContext;
import com.sap.sse.serialization.Base64SerializerDeserializer;
import com.sap.sse.shared.classloading.JoinedClassLoader;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Level;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class AbstractPreferenceWithContext
implements HasPreferenceContext {
    private static final JoinedClassLoader joinedClassLoader = new JoinedClassLoader(Collections.singleton(AbstractPreferenceWithContext.class.getClassLoader()));
    private final String preferenceName;
    private final String preferenceValue;

    public AbstractPreferenceWithContext(String preferenceName, String preferenceValue) {
        this.preferenceName = preferenceName;
        this.preferenceValue = preferenceValue;
    }

    @Override
    public String getPreferenceName() {
        return this.preferenceName;
    }

    @Override
    public String getPreferenceValue() {
        return this.preferenceValue;
    }

    @Override
    public int getNumberOfObjectsContained() {
        String stringValue = this.getPreferenceValue();
        int result = this.getNumberOfObjectsContained(stringValue);
        return result;
    }

    private int getNumberOfObjectsContained(Object o) {
        int result = 0;
        if (o instanceof String) {
            result = this.getNumberOfObjectsContained((String)o);
        } else if (o instanceof JSONArray) {
            JSONArray array = (JSONArray)o;
            for (Object a : array) {
                if (a == null) continue;
                if (a instanceof String) {
                    result += this.getNumberOfObjectsContained((String)a);
                    continue;
                }
                if (a instanceof JSONObject) {
                    result += this.getNumberOfObjectsContained((JSONObject)a);
                    continue;
                }
                ++result;
            }
        } else {
            result = o instanceof JSONObject ? this.getNumberOfObjectsContained((JSONObject)o) : 1;
        }
        return result;
    }

    private int getNumberOfObjectsContained(String stringValueMaybeBase64SerializedMaybeJson) {
        int result = 0;
        if (Util.hasLength((String)stringValueMaybeBase64SerializedMaybeJson)) {
            Serializable fromBase64 = Base64SerializerDeserializer.fromBase64((String)stringValueMaybeBase64SerializedMaybeJson, (JoinedClassLoader)joinedClassLoader, (Level)Level.FINEST);
            if (fromBase64 == null) {
                JSONParser jsonParser = new JSONParser();
                try {
                    result += this.getNumberOfObjectsContained(jsonParser.parse(stringValueMaybeBase64SerializedMaybeJson));
                }
                catch (ParseException e) {
                    result = 1;
                }
            } else {
                result = fromBase64 instanceof Iterable ? Util.size((Iterable)((Iterable)((Object)fromBase64))) : 1;
            }
        }
        return result;
    }

    private int getNumberOfObjectsContained(JSONObject a) {
        int result = 0;
        for (Object o : a.values()) {
            result += this.getNumberOfObjectsContained(o);
        }
        return result;
    }
}

