/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.filestorage.impl;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.Util;
import com.sap.sse.filestorage.FileStorageService;
import com.sap.sse.filestorage.InvalidPropertiesException;
import com.sap.sse.filestorage.OperationFailedException;
import com.sap.sse.filestorage.impl.BaseFileStorageServiceImpl;
import com.sap.sse.filestorage.impl.FileStorageServicePropertyImpl;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthorizedException;
import org.osgi.framework.BundleContext;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class AmazonS3FileStorageServiceImpl
extends BaseFileStorageServiceImpl
implements FileStorageService {
    private static final long serialVersionUID = -2406798172882732531L;
    public static final String NAME = "Amazon S3";
    private static final Logger logger = Logger.getLogger(AmazonS3FileStorageServiceImpl.class.getName());
    private static final String retrievalProtocol = "https";
    private static final String regionRetrievalHost = "s3-eu-west-1.amazonaws.com";
    private final FileStorageServicePropertyImpl accessId = new FileStorageServicePropertyImpl("accessId", false, false, "s3AccessIdDesc");
    private final FileStorageServicePropertyImpl accessKey = new FileStorageServicePropertyImpl("accessKey", false, true, "s3AccessKeyDesc");
    private final FileStorageServicePropertyImpl bucketName = new FileStorageServicePropertyImpl("bucketName", true, false, "s3BucketNameDesc");

    public AmazonS3FileStorageServiceImpl(BundleContext bundleContext) {
        super(NAME, "s3Desc", bundleContext);
        this.addProperties(this.accessId, this.accessKey, this.bucketName);
    }

    private S3Client createS3Client() throws InvalidPropertiesException {
        ProfileCredentialsProvider credsProvider;
        if (this.accessId.getValue() != null && this.accessKey.getValue() != null) {
            credsProvider = () -> AwsBasicCredentials.create((String)this.accessId.getValue(), (String)this.accessKey.getValue());
        } else {
            try {
                credsProvider = ProfileCredentialsProvider.create();
            }
            catch (Exception e) {
                throw new InvalidPropertiesException("credentials in ~/.aws/credentials seem to be invalid (tried this as fallback because properties were empty)", e);
            }
        }
        return (S3Client)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)credsProvider)).build();
    }

    private URI getUri(String key) {
        try {
            return new URI(retrievalProtocol, regionRetrievalHost, "/" + this.bucketName.getValue() + "/" + key, null);
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, "Could not create URI for uploaded file with key " + key, e);
            return null;
        }
    }

    @Override
    public URI storeFile(InputStream is, String fileExtension, long lengthInBytes) throws InvalidPropertiesException, OperationFailedException, UnauthorizedException {
        String key = AmazonS3FileStorageServiceImpl.getKey(fileExtension);
        return (URI)this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.FILE_STORAGE, new TypeRelativeObjectIdentifier(new String[]{key}), key, () -> {
            PutObjectRequest request = (PutObjectRequest)PutObjectRequest.builder().contentLength(Long.valueOf(lengthInBytes)).bucket(this.bucketName.getValue()).key(key).acl(ObjectCannedACL.PUBLIC_READ).build();
            this.createS3Client().putObject(request, RequestBody.fromInputStream((InputStream)is, (long)lengthInBytes));
            URI uri = this.getUri(key);
            logger.info("Stored file " + uri);
            return uri;
        });
    }

    @Override
    public void removeFile(URI uri) throws InvalidPropertiesException, OperationFailedException, UnauthorizedException {
        String key = uri.getPath().substring(uri.getPath().lastIndexOf("/") + 1);
        this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval(SecuredDomainType.FILE_STORAGE.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{key})), () -> {
            S3Client s3Client = this.createS3Client();
            s3Client.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(this.bucketName.getValue()).key(key).build());
            logger.info("Removed file " + uri);
        });
    }

    @Override
    public void testProperties() throws InvalidPropertiesException {
        S3Client s3 = this.createS3Client();
        if (this.bucketName.getValue().equals("")) {
            throw new InvalidPropertiesException("empty bucketname is not allowed");
        }
        try {
            s3.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(this.bucketName.getValue()).build());
        }
        catch (NoSuchBucketException nsbe) {
            throw new InvalidPropertiesException("invalid bucket", new Util.Pair((Object)this.bucketName, (Object)"bucket does not exist"));
        }
        catch (Exception e) {
            throw new InvalidPropertiesException("invalid credentials or not enough access rights for the bucket: " + e.getCause(), (Throwable)e, new Util.Pair((Object)this.accessId, (Object)"seems to be invalid"), new Util.Pair((Object)this.accessKey, (Object)"seems to be invalid"));
        }
    }

    @Override
    public void doPermissionCheckForGetFile(URI uri) throws UnauthorizedException {
        String key = uri.getPath().substring(uri.getPath().lastIndexOf("/") + 1);
        SecurityUtils.getSubject().checkPermission(SecuredDomainType.FILE_STORAGE.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)HasPermissions.DefaultActions.READ, new TypeRelativeObjectIdentifier(new String[]{key})));
    }
}

