/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator.util;

import com.sap.sailing.gwt.ui.simulator.util.ColorPalette;

public class WindGridColorPalette
implements ColorPalette {
    public int minColor = 255;
    public int maxColor = 0;
    public int rminColor = 255;
    public int rmaxColor = 75;
    public int gminColor = 255;
    public int gmaxColor = 127;
    public int bminColor = 255;
    public int bmaxColor = 187;
    private double min;
    private double max;

    public WindGridColorPalette(double min, double max) {
        this.min = min;
        this.max = max;
    }

    public String getNextColor() {
        throw new UnsupportedOperationException();
    }

    public String getColor(int idx) {
        return this.getColor((double)idx * 1.0);
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public String getGreyColor(double value) {
        if (this.min <= value && value <= this.max) {
            int colorValue = (int)((double)this.minColor + (value - this.min) / Math.max(1.0, this.max - this.min) * (double)(this.maxColor - this.minColor));
            String colorValueHex = Integer.toHexString(colorValue).toUpperCase();
            if (colorValueHex.length() < 2) {
                colorValueHex = "0" + colorValueHex;
            }
            String rgb = "#" + colorValueHex + colorValueHex + colorValueHex;
            return rgb;
        }
        return null;
    }

    public String getColor(double value) {
        if (this.min <= value && value <= this.max) {
            String bcolorValueHex;
            String gcolorValueHex;
            int bColorValue;
            int gColorValue;
            int rColorValue;
            int rbase = (this.rminColor + this.rmaxColor) / 2;
            int gbase = (this.gminColor + this.gmaxColor) / 2;
            int bbase = (this.bminColor + this.bmaxColor) / 2;
            double avgValue = (this.max + this.min) / 2.0;
            if (value <= avgValue) {
                rColorValue = (int)((double)rbase - (avgValue - value) / Math.max(1.0, avgValue - this.min) * (double)(rbase - this.rminColor));
                gColorValue = (int)((double)gbase - (avgValue - value) / Math.max(1.0, avgValue - this.min) * (double)(gbase - this.gminColor));
                bColorValue = (int)((double)bbase - (avgValue - value) / Math.max(1.0, avgValue - this.min) * (double)(bbase - this.bminColor));
            } else {
                rColorValue = (int)((double)rbase + (value - avgValue) / Math.max(1.0, this.max - avgValue) * (double)(this.rmaxColor - rbase));
                gColorValue = (int)((double)gbase + (value - avgValue) / Math.max(1.0, this.max - avgValue) * (double)(this.gmaxColor - gbase));
                bColorValue = (int)((double)bbase + (value - avgValue) / Math.max(1.0, this.max - avgValue) * (double)(this.bmaxColor - bbase));
            }
            String rcolorValueHex = Integer.toHexString(rColorValue).toUpperCase();
            if (rcolorValueHex.length() < 2) {
                rcolorValueHex = "0" + rcolorValueHex;
            }
            if ((gcolorValueHex = Integer.toHexString(gColorValue).toUpperCase()).length() < 2) {
                gcolorValueHex = "0" + gcolorValueHex;
            }
            if ((bcolorValueHex = Integer.toHexString(bColorValue).toUpperCase()).length() < 2) {
                bcolorValueHex = "0" + bcolorValueHex;
            }
            String rgb = "#" + rcolorValueHex + gcolorValueHex + bcolorValueHex;
            return rgb;
        }
        return null;
    }
}

