/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator.streamlets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.LatLngBounds;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.gwt.ui.shared.WindFieldDTO;
import com.sap.sailing.gwt.ui.shared.WindFieldGenParamsDTO;
import com.sap.sailing.gwt.ui.simulator.StreamletParameters;
import com.sap.sailing.gwt.ui.simulator.streamlets.Index;
import com.sap.sailing.gwt.ui.simulator.streamlets.Neighbors;
import com.sap.sailing.gwt.ui.simulator.streamlets.Vector;
import com.sap.sailing.gwt.ui.simulator.streamlets.VectorField;
import com.sap.sse.common.Duration;
import java.util.Date;
import java.util.List;

public class SimulatorField
implements VectorField {
    private boolean swarmDebug = false;
    private Position rcStart;
    private Position rcEnd;
    private final int resY;
    private final int resX;
    private final int borderY;
    private final int borderX;
    private final Position bdA;
    private final Position bdB;
    private final Position bdC;
    private final double xScale;
    private double motionFactor;
    private double lineBase;
    private double lineScale;
    private final double maxLength;
    private final double particleFactor;
    private final double lngScale;
    private final Position nvY;
    private final Position nvX;
    private final double[][][] data;
    private final Date startTime;
    private final Duration timeStep;
    private final CoordinateSystem coordinateSystem;

    public SimulatorField(WindFieldDTO windData, WindFieldGenParamsDTO windParams, StreamletParameters parameters, CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
        this.startTime = windParams.getStartTime();
        this.timeStep = windParams.getTimeStep();
        this.rcStart = new DegreePosition(windData.windData.rcStart.getLatDeg(), windData.windData.rcStart.getLngDeg());
        this.rcEnd = new DegreePosition(windData.windData.rcEnd.getLatDeg(), windData.windData.rcEnd.getLngDeg());
        this.resX = windData.windData.resX;
        this.resY = windData.windData.resY;
        this.borderX = windData.windData.borderX;
        this.borderY = windData.windData.borderY;
        double bdXi = ((double)this.borderY + 0.5) / (double)(this.resY - 1);
        double bdPhi = 1.0 + 2.0 * bdXi;
        this.bdA = new DegreePosition(this.rcEnd.getLatDeg() + (this.rcEnd.getLatDeg() - this.rcStart.getLatDeg()) * bdXi, this.rcEnd.getLngDeg() + (this.rcEnd.getLngDeg() - this.rcStart.getLngDeg()) * bdXi);
        this.bdB = new DegreePosition((this.rcStart.getLatDeg() - this.rcEnd.getLatDeg()) * bdPhi, (this.rcStart.getLngDeg() - this.rcEnd.getLngDeg()) * bdPhi);
        this.xScale = windData.windData.xScale;
        this.motionFactor = 7.0E-4 * parameters.motionScale;
        this.lineBase = parameters.lineBase;
        this.lineScale = parameters.lineScale;
        List gridData = windData.getMatrix();
        int p = 0;
        int imax = windParams.getyRes() + 2 * windParams.getBorderY();
        int jmax = windParams.getxRes() + 2 * windParams.getBorderX();
        int steps = gridData.size() / (imax * jmax);
        this.data = new double[steps][imax][2 * jmax];
        double maxWindSpeed = 0.0;
        double minWindSpeed = Double.MAX_VALUE;
        int s = 0;
        while (s < steps) {
            int i = 0;
            while (i < imax) {
                int j = 0;
                while (j < jmax) {
                    SimulatorWindDTO wind = (SimulatorWindDTO)gridData.get(p);
                    ++p;
                    if (wind.trueWindSpeedInKnots > maxWindSpeed) {
                        maxWindSpeed = wind.trueWindSpeedInKnots;
                    }
                    if (wind.trueWindSpeedInKnots < minWindSpeed) {
                        minWindSpeed = wind.trueWindSpeedInKnots;
                    }
                    this.data[s][i][2 * j + 1] = wind.trueWindSpeedInKnots * Math.cos(wind.trueWindBearingDeg * Math.PI / 180.0);
                    this.data[s][i][2 * j] = wind.trueWindSpeedInKnots * Math.sin(wind.trueWindBearingDeg * Math.PI / 180.0);
                    ++j;
                }
                ++i;
            }
            ++s;
        }
        this.maxLength = maxWindSpeed;
        this.particleFactor = 1.0;
        double latAvg = (this.rcEnd.getLatDeg() + this.rcStart.getLatDeg()) / 2.0;
        this.lngScale = Math.cos(latAvg * Math.PI / 180.0);
        double difLat = this.rcEnd.getLatDeg() - this.rcStart.getLatDeg();
        double difLng = (this.rcEnd.getLngDeg() - this.rcStart.getLngDeg()) * this.lngScale;
        double difLen = Math.sqrt(difLat * difLat + difLng * difLng);
        this.nvY = new DegreePosition(difLat / difLen / difLen * (double)(this.resY - 1), difLng / difLen / difLen * (double)(this.resY - 1));
        double nrmLat = -difLng / difLen;
        double nrmLng = difLat / difLen;
        this.nvX = new DegreePosition(nrmLat / this.xScale / difLen * (double)(this.resX - 1), nrmLng / this.xScale / difLen * (double)(this.resX - 1));
        DegreePosition gvX = new DegreePosition(nrmLat * this.xScale * difLen, nrmLng / this.lngScale * this.xScale * difLen);
        this.bdC = new DegreePosition(gvX.getLatDeg() * (double)(this.resX + 2 * this.borderX - 1) / (double)(this.resX - 1), gvX.getLngDeg() * (double)(this.resX + 2 * this.borderX - 1) / (double)(this.resX - 1));
    }

    private LatLng getInnerPosition(double factX, double factY) {
        double latDeg = this.bdA.getLatDeg() + factY * this.bdB.getLatDeg() + factX * this.bdC.getLatDeg();
        double lngDeg = this.bdA.getLngDeg() + factY * this.bdB.getLngDeg() + factX * this.bdC.getLngDeg();
        LatLng result = LatLng.newInstance((double)latDeg, (double)lngDeg);
        if (this.swarmDebug && !this.inBounds(result)) {
            GWT.log((String)"random-position: out of bounds");
        }
        return result;
    }

    public boolean inBounds(Position p) {
        Index idx = this.getIndex(p);
        boolean inBool = idx.x >= 0L && idx.x < (long)(this.resX + 2 * this.borderX) && idx.y >= 0L && idx.y < (long)(this.resY + 2 * this.borderY);
        return inBool;
    }

    public boolean inBounds(LatLng p) {
        return this.inBounds(this.coordinateSystem.getPosition(p));
    }

    private Vector interpolate(Position p, Date at) {
        int step = (int)((at.getTime() - this.startTime.getTime()) / this.timeStep.asMillis());
        if (step >= this.data.length) {
            step = this.data.length - 1;
        }
        Neighbors idx = this.getNeighbors(p);
        if (this.swarmDebug && (idx.xTop >= this.resX + 2 * this.borderX || idx.yTop >= this.resY + 2 * this.borderY)) {
            GWT.log((String)("interpolate: out of range: " + idx.xTop + "  " + idx.yTop));
        }
        double[][] dataAtStep = this.data[step];
        double avgX = dataAtStep[idx.yBot][2 * idx.xBot] * (1.0 - idx.yMod) * (1.0 - idx.xMod) + dataAtStep[idx.yTop][2 * idx.xBot] * idx.yMod * (1.0 - idx.xMod) + dataAtStep[idx.yBot][2 * idx.xTop] * (1.0 - idx.yMod) * idx.xMod + dataAtStep[idx.yTop][2 * idx.xTop] * idx.yMod * idx.xMod;
        double avgY = dataAtStep[idx.yBot][2 * idx.xBot + 1] * (1.0 - idx.yMod) * (1.0 - idx.xMod) + dataAtStep[idx.yTop][2 * idx.xBot + 1] * idx.yMod * (1.0 - idx.xMod) + dataAtStep[idx.yBot][2 * idx.xTop + 1] * (1.0 - idx.yMod) * idx.xMod + dataAtStep[idx.yTop][2 * idx.xTop + 1] * idx.yMod * idx.xMod;
        return new Vector(avgX, avgY);
    }

    public Vector getVector(LatLng p, Date at) {
        return this.interpolate(this.coordinateSystem.getPosition(p), at);
    }

    private Index getIndex(Position p) {
        double latOffset = p.getLatDeg() - this.rcStart.getLatDeg();
        double lngOffset = (p.getLngDeg() - this.rcStart.getLngDeg()) * this.lngScale;
        long yIdx = Math.round(latOffset * this.nvY.getLatDeg() + lngOffset * this.nvY.getLngDeg()) + (long)this.borderY;
        long xIdx = Math.round(latOffset * this.nvX.getLatDeg() + lngOffset * this.nvX.getLngDeg() + (double)(this.resX - 1) / 2.0) + (long)this.borderX;
        return new Index(xIdx, yIdx);
    }

    private Neighbors getNeighbors(Position p) {
        DegreePosition posR = new DegreePosition(p.getLatDeg() - this.rcStart.getLatDeg(), (p.getLngDeg() - this.rcStart.getLngDeg()) * this.lngScale);
        double yFlt = posR.getLatDeg() * this.nvY.getLatDeg() + posR.getLngDeg() * this.nvY.getLngDeg() + (double)this.borderY;
        double xFlt = posR.getLatDeg() * this.nvX.getLatDeg() + posR.getLngDeg() * this.nvX.getLngDeg() + (double)(this.resX - 1) / 2.0 + (double)this.borderX;
        double yBot = Math.floor(yFlt);
        double xBot = Math.floor(xFlt);
        double yTop = Math.ceil(yFlt);
        double xTop = Math.ceil(xFlt);
        if (xBot < 0.0) {
            xFlt = xBot = 0.0;
            xTop = 1.0;
        }
        if (yBot < 0.0) {
            yFlt = yBot = 0.0;
            yTop = 1.0;
        }
        if (xTop >= (double)(this.resX + 2 * this.borderX)) {
            xFlt = xTop = (double)(this.resX + 2 * this.borderX - 1);
            xBot = xTop - 1.0;
        }
        if (yTop >= (double)(this.resY + 2 * this.borderY)) {
            yFlt = yTop = (double)(this.resY + 2 * this.borderY - 1);
            yBot = yTop - 1.0;
        }
        double yMod = yFlt - yBot;
        double xMod = xFlt - xBot;
        return new Neighbors((int)xTop, (int)yTop, (int)xBot, (int)yBot, xMod, yMod);
    }

    public double getMotionScale(int zoomLevel) {
        return this.motionFactor * Math.pow(1.6, Math.min(1.0, 6.0 - (double)zoomLevel));
    }

    public double getParticleWeight(LatLng p, Vector v) {
        return v == null ? 0.0 : v.length() / this.maxLength + 0.1;
    }

    public double getLineWidth(double speed) {
        return Math.max(0.01, (double)Math.round((this.lineBase + this.lineScale * (speed - 12.0) / 8.0) * 100.0) / 100.0);
    }

    public LatLngBounds getFieldCorners() {
        LatLng fieldNE = this.getInnerPosition(0.5, 1.0);
        LatLng fieldSW = this.getInnerPosition(-0.5, 0.0);
        LatLng fieldSE = this.getInnerPosition(0.5, 0.0);
        LatLng fieldNW = this.getInnerPosition(-0.5, 1.0);
        double minLat = Math.min(Math.min(fieldNE.getLatitude(), fieldSW.getLatitude()), Math.min(fieldNW.getLatitude(), fieldSE.getLatitude()));
        double minLng = Math.min(Math.min(fieldNE.getLongitude(), fieldSW.getLongitude()), Math.min(fieldNW.getLongitude(), fieldSE.getLongitude()));
        LatLng sw = LatLng.newInstance((double)minLat, (double)minLng);
        double maxLat = Math.max(Math.max(fieldNE.getLatitude(), fieldSW.getLatitude()), Math.max(fieldNW.getLatitude(), fieldSE.getLatitude()));
        double maxLng = Math.max(Math.max(fieldNE.getLongitude(), fieldSW.getLongitude()), Math.max(fieldNW.getLongitude(), fieldSE.getLongitude()));
        LatLng ne = LatLng.newInstance((double)maxLat, (double)maxLng);
        return LatLngBounds.newInstance((LatLng)sw, (LatLng)ne);
    }

    public double getParticleFactor() {
        return this.particleFactor;
    }
}

