/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator.racemap;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.ImageData;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.streamlets.Vector;

public abstract class MovingCanvasOverlay
extends FullCanvasOverlay {
    private LatLng nw;

    public MovingCanvasOverlay(MapWidget map, int zIndex, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
    }

    public void setCanvasSettings() {
        if (this.mapProjection != null) {
            int canvasWidth = this.getMap().getDiv().getClientWidth();
            int canvasHeight = this.getMap().getDiv().getClientHeight();
            Point nwOldPx = this.nw == null ? null : this.mapProjection.fromLatLngToDivPixel(this.nw);
            this.nw = LatLng.newInstance((double)this.getMap().getBounds().getNorthEast().getLatitude(), (double)this.getMap().getBounds().getSouthWest().getLongitude());
            Point nwNewPx = this.mapProjection.fromLatLngToDivPixel(this.nw);
            this.widgetPosLeft = Math.round(nwNewPx.getX());
            this.widgetPosTop = Math.round(nwNewPx.getY());
            if (nwOldPx == null) {
                this.diffPx = new Vector(0.0, 0.0);
            } else {
                double oldPosLeft = Math.round(nwOldPx.getX());
                double oldPosTop = Math.round(nwOldPx.getY());
                this.diffPx = new Vector(oldPosLeft - this.widgetPosLeft, oldPosTop - this.widgetPosTop);
            }
            Context2d ctxt = this.canvas.getContext2d();
            ImageData canvasContent = ctxt.getImageData(0.0, 0.0, (double)this.canvas.getElement().getClientWidth(), (double)this.canvas.getElement().getClientHeight());
            this.canvas.setWidth(String.valueOf(canvasWidth));
            this.canvas.setHeight(String.valueOf(canvasHeight));
            this.canvas.setCoordinateSpaceWidth(canvasWidth);
            this.canvas.setCoordinateSpaceHeight(canvasHeight);
            ctxt = this.canvas.getContext2d();
            ctxt.putImageData(canvasContent, this.diffPx.x, this.diffPx.y);
            this.setCanvasPosition(this.widgetPosLeft, this.widgetPosTop);
        }
    }

    protected void draw() {
    }

    public void initCanvasOrigin() {
        this.nw = null;
    }
}

