/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.core.client.GWT;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.WindFieldDTO;
import com.sap.sailing.gwt.ui.shared.WindFieldGenParamsDTO;
import com.sap.sailing.gwt.ui.simulator.SimulatorMap;
import com.sap.sailing.gwt.ui.simulator.StreamletParameters;
import com.sap.sailing.gwt.ui.simulator.TimeListenerWithStoppingCriteria;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.streamlets.RectField;
import com.sap.sailing.gwt.ui.simulator.streamlets.SimulatorField;
import com.sap.sailing.gwt.ui.simulator.streamlets.SimulatorJSBundle;
import com.sap.sailing.gwt.ui.simulator.streamlets.Swarm;
import com.sap.sailing.gwt.ui.simulator.streamlets.VectorField;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import java.util.Date;

public class WindStreamletsCanvasOverlay
extends FullCanvasOverlay
implements TimeListenerWithStoppingCriteria {
    private WindFieldDTO windFieldDTO;
    private final WindFieldGenParamsDTO windParams;
    private final SimulatorMap simulatorMap;
    private StreamletParameters streamletPars;
    private boolean visible = false;
    private final Timer timer;
    private Date endDate;
    private boolean macroWeather;
    private Swarm swarm;

    public WindStreamletsCanvasOverlay(SimulatorMap simulatorMap, int zIndex, Timer timer, StreamletParameters streamletPars, WindFieldGenParamsDTO windParams, CoordinateSystem coordinateSystem) {
        super(simulatorMap.getMap(), zIndex, coordinateSystem);
        this.simulatorMap = simulatorMap;
        this.timer = timer;
        this.windParams = windParams;
        this.streamletPars = streamletPars;
        this.macroWeather = this.simulatorMap.getMainPanel().macroWeather;
        this.windFieldDTO = null;
        this.getCanvas().getElement().setId("swarm-display");
    }

    public WindFieldDTO getWindFieldDTO() {
        return this.windFieldDTO;
    }

    public WindFieldGenParamsDTO getWindParams() {
        return this.windParams;
    }

    public void startStreamlets() {
        if (this.swarm == null) {
            SimulatorField field = new SimulatorField(this.getWindFieldDTO(), this.getWindParams(), this.streamletPars, this.coordinateSystem);
            this.setCanvasSettings();
            this.swarm = new Swarm((FullCanvasOverlay)this, this.map, this.timer, (VectorField)field, this.streamletPars);
        }
        this.swarm.start(40);
    }

    public void stopStreamlets() {
        if (this.swarm != null) {
            this.swarm.stop();
        }
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void setWindField(WindFieldDTO windFieldDTO) {
        this.windFieldDTO = windFieldDTO;
        this.swarm = null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean isVisible) {
        if (this.getCanvas() != null) {
            if (isVisible) {
                this.startStreamlets();
                if (this.timer.getTime().compareTo(this.windParams.getStartTime()) != 0) {
                    this.timeChanged(this.timer.getTime(), null);
                }
                this.visible = isVisible;
            } else {
                this.stopStreamlets();
                this.visible = isVisible;
            }
        }
    }

    public void addToMap() {
        if (this.timer != null) {
            this.timer.addTimeListener((TimeListener)this);
        }
    }

    public void removeFromMap() {
        if (this.timer != null) {
            this.timer.removeTimeListener((TimeListener)this);
        }
        this.setVisible(false);
    }

    protected void drawCenterChanged() {
    }

    protected void draw() {
        super.draw();
        if (this.mapProjection != null && this.macroWeather && this.swarm == null) {
            this.macroWeather = false;
            SimulatorJSBundle bundle = (SimulatorJSBundle)GWT.create(SimulatorJSBundle.class);
            String jsonStr = bundle.windStreamletsDataJS().getText();
            RectField f = RectField.read((String)jsonStr, (boolean)false, (StreamletParameters)this.streamletPars, (CoordinateSystem)this.coordinateSystem);
            this.map.setZoom(5);
            this.map.panTo(f.getCenter());
            this.swarm = new Swarm((FullCanvasOverlay)this, this.map, this.timer, (VectorField)f, this.streamletPars);
            this.swarm.start(40);
        }
    }

    public Swarm getSwarm() {
        return this.swarm;
    }

    public void timeChanged(Date newDate, Date oldDate) {
    }

    public boolean shallStop() {
        return this.timer.getTime().getTime() >= this.endDate.getTime();
    }
}

