/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.gwt.ui.shared.WindFieldDTO;
import com.sap.sailing.gwt.ui.simulator.TimeListenerWithStoppingCriteria;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.util.ToolTip;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class WindLineGuidesCanvasOverlay
extends FullCanvasOverlay
implements TimeListenerWithStoppingCriteria {
    private WindFieldDTO windFieldDTO;
    private SortedMap<Long, List<SimulatorWindDTO>> timePointWindDTOMap;
    private Map<ToolTip, SimulatorWindDTO> windFieldPoints;
    private String arrowColor = "Black";
    private String arrowHeadColor = "Blue";
    private int xRes;
    private Timer timer;
    private static Logger logger = Logger.getLogger(WindLineGuidesCanvasOverlay.class.getName());

    public WindLineGuidesCanvasOverlay(MapWidget map, int zIndex, Timer timer, int xRes, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.timer = timer;
        this.xRes = xRes;
        this.windFieldDTO = null;
        this.windFieldPoints = new HashMap();
        this.timePointWindDTOMap = new TreeMap();
    }

    public WindLineGuidesCanvasOverlay(MapWidget map, int zIndex, CoordinateSystem coordinateSystem) {
        this(map, zIndex, null, 0, coordinateSystem);
    }

    public void addToMap() {
        super.addToMap();
        if (this.timer != null) {
            this.timer.addTimeListener((TimeListener)this);
        }
    }

    public void removeFromMap() {
        super.removeFromMap();
        if (this.timer != null) {
            this.timer.removeTimeListener((TimeListener)this);
        }
    }

    public void setWindField(WindFieldDTO windField) {
        this.windFieldDTO = windField;
        this.timePointWindDTOMap.clear();
        if (windField != null) {
            for (SimulatorWindDTO w : windField.getMatrix()) {
                if (!this.timePointWindDTOMap.containsKey(w.timepoint.asMillis())) {
                    this.timePointWindDTOMap.put(w.timepoint.asMillis(), new LinkedList());
                }
                ((List)this.timePointWindDTOMap.get(w.timepoint.asMillis())).add(w);
            }
        }
    }

    public void setArrowColor(String arrowColor, String arrowHeadColor) {
        this.arrowColor = arrowColor;
        this.arrowHeadColor = arrowHeadColor;
    }

    protected void draw() {
        super.draw();
        if (this.mapProjection != null && this.windFieldDTO != null) {
            this.clear();
            this.drawWindField();
        }
    }

    private void clear() {
        this.canvas.getContext2d().clearRect(0.0, 0.0, (double)this.canvas.getCoordinateSpaceWidth(), (double)this.canvas.getCoordinateSpaceHeight());
        this.windFieldPoints.clear();
    }

    protected void drawWindField() {
        if (this.timer != null) {
            this.timeChanged(this.timer.getTime(), null);
        } else {
            this.drawWindField(this.windFieldDTO.getMatrix());
        }
    }

    protected void drawScaledArrow(SimulatorWindDTO windDTO, double angle, int index, double pxLength, boolean drawHead) {
        double aWidth = 1.0;
        this.drawArrow(windDTO, angle, pxLength, 1.0, index, drawHead);
    }

    protected void drawWindField(List<SimulatorWindDTO> windDTOList) {
        boolean drawHead = false;
        this.clear();
        Context2d context2d = this.canvas.getContext2d();
        context2d.setGlobalAlpha(0.4);
        if (windDTOList != null && windDTOList.size() > 0) {
            Iterator<SimulatorWindDTO> windDTOIter = windDTOList.iterator();
            SimulatorWindDTO w0 = windDTOIter.next();
            SimulatorWindDTO w1 = windDTOIter.next();
            LatLng pg0 = this.coordinateSystem.toLatLng(w0.position);
            LatLng pg1 = this.coordinateSystem.toLatLng(w1.position);
            Point px0 = this.mapProjection.fromLatLngToDivPixel(pg0);
            Point px1 = this.mapProjection.fromLatLngToDivPixel(pg1);
            double dx = px0.getX() - px1.getX();
            double dy = px0.getY() - px1.getY();
            double pxLength = Math.sqrt(dx * dx + dy * dy);
            logger.fine("pxLength = " + pxLength);
            windDTOIter = windDTOList.iterator();
            int index = 0;
            while (windDTOIter.hasNext()) {
                SimulatorWindDTO windDTO = windDTOIter.next();
                if (index % this.xRes > 0 && index % this.xRes < this.xRes - 1) {
                    DegreeBearingImpl dbi = new DegreeBearingImpl(windDTO.trueWindBearingDeg.doubleValue());
                    this.drawScaledArrow(windDTO, dbi.getRadians(), index, pxLength, false);
                }
                ++index;
            }
            String title = "Wind Field at " + windDTOList.size() + " points.";
            this.getCanvas().setTitle(title);
        }
    }

    protected void drawArrow(SimulatorWindDTO windDTO, double angle, double length, double weight, int index, boolean drawHead) {
        String msg = "Wind @ P" + index + ": time : " + windDTO.timepoint + " speed: " + windDTO.trueWindSpeedInKnots + "knots " + windDTO.trueWindBearingDeg;
        logger.fine(msg);
        Context2d context2d = this.canvas.getContext2d();
        context2d.setGlobalAlpha(0.2);
        Position position = windDTO.position;
        LatLng positionLatLng = this.coordinateSystem.toLatLng(position);
        Point canvasPositionInPx = this.mapProjection.fromLatLngToDivPixel(positionLatLng);
        double x = canvasPositionInPx.getX() - this.getWidgetPosLeft();
        double y = canvasPositionInPx.getY() - this.getWidgetPosTop();
        this.windFieldPoints.put(new ToolTip(x, y), windDTO);
        double dx = length * Math.sin(angle);
        double dy = -length * Math.cos(angle);
        double x1 = x + dx / 2.0;
        double y1 = y + dy / 2.0;
        this.drawLine(x - dx / 2.0, y - dy / 2.0, x1, y1, weight, this.arrowColor);
        double theta = Math.atan2(-dy, dx);
        double hLength = Math.max(6.0, 6.0 + 0.2 * Math.max(length - 6.0, 0.0));
        logger.finer("headlength: " + hLength + ", arrowlength: " + length);
        if (drawHead) {
            this.drawHead(x1, y1, theta, hLength, weight);
        }
        context2d.setGlobalAlpha(0.4);
    }

    protected void drawHead(double x, double y, double theta, double headLength, double weight) {
        double t2;
        double t = theta + 0.7853981633974483;
        if (t > Math.PI) {
            t -= Math.PI * 2;
        }
        if ((t2 = theta - 0.7853981633974483) <= -Math.PI) {
            t2 += Math.PI * 2;
        }
        double x1 = x - Math.cos(t) * headLength;
        double y1 = y + Math.sin(t) * headLength;
        double x1o = x + Math.cos(t) * weight / 2.0;
        double y1o = y - Math.sin(t) * weight / 2.0;
        double x2 = x - Math.cos(t2) * headLength;
        double y2 = y + Math.sin(t2) * headLength;
        double x2o = x + Math.cos(t2) * weight / 2.0;
        double y2o = y - Math.sin(t2) * weight / 2.0;
        this.drawLine(x1o, y1o, x1, y1, weight, this.arrowHeadColor);
        this.drawLine(x2o, y2o, x2, y2, weight, this.arrowHeadColor);
    }

    public void timeChanged(Date newDate, Date oldDate) {
        List windDTOToDraw = new ArrayList();
        SortedMap headMap = this.timePointWindDTOMap.headMap(newDate.getTime() + 1L);
        if (!headMap.isEmpty()) {
            windDTOToDraw = (List)headMap.get(headMap.lastKey());
        }
        logger.info("In WindFieldCanvasOverlay.drawWindField drawing " + windDTOToDraw.size() + " points" + " @ " + newDate);
        this.drawWindField(windDTOToDraw);
    }

    public boolean shallStop() {
        if (!this.isVisible() || this.timePointWindDTOMap == null || this.timer == null || this.timePointWindDTOMap.isEmpty()) {
            return true;
        }
        return (Long)this.timePointWindDTOMap.lastKey() < this.timer.getTime().getTime();
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Timer getTimer() {
        return this.timer;
    }
}

