/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.maps.client.MapWidget;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.gwt.ui.shared.WindFieldDTO;
import com.sap.sailing.gwt.ui.shared.WindFieldGenParamsDTO;
import com.sap.sailing.gwt.ui.simulator.PathPolyline;
import com.sap.sailing.gwt.ui.simulator.TimeListenerWithStoppingCriteria;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.util.ToolTip;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class WindFieldCanvasOverlay
extends FullCanvasOverlay
implements TimeListenerWithStoppingCriteria {
    protected WindFieldDTO windFieldDTO;
    protected SortedMap<Long, List<SimulatorWindDTO>> timePointWindDTOMap;
    protected Map<ToolTip, SimulatorWindDTO> windFieldPoints;
    protected String arrowColor = "Blue";
    protected String arrowHeadColor = "Blue";
    protected double arrowLength = 15.0;
    protected WindFieldGenParamsDTO windParams = null;
    private HandlerRegistration mouseMoveHandlerRegistration;
    private Timer timer;
    private static Logger logger = Logger.getLogger(WindFieldCanvasOverlay.class.getName());

    public WindFieldCanvasOverlay(MapWidget map, int zIndex, Timer timer, WindFieldGenParamsDTO windParams, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.timer = timer;
        this.windParams = windParams;
        this.windFieldDTO = null;
        this.windFieldPoints = new HashMap();
        this.timePointWindDTOMap = new TreeMap();
    }

    public WindFieldCanvasOverlay(MapWidget map, int zIndex, CoordinateSystem coordinateSystem) {
        this(map, zIndex, null, null, coordinateSystem);
    }

    public void setWindField(WindFieldDTO windFieldDTO) {
        this.windFieldDTO = windFieldDTO;
        this.timePointWindDTOMap.clear();
        if (windFieldDTO != null) {
            for (SimulatorWindDTO w : windFieldDTO.getMatrix()) {
                if (!this.timePointWindDTOMap.containsKey(w.timepoint.asMillis())) {
                    this.timePointWindDTOMap.put(w.timepoint.asMillis(), new LinkedList());
                }
                ((List)this.timePointWindDTOMap.get(w.timepoint.asMillis())).add(w);
            }
        }
    }

    public void setArrowColor(String arrowColor, String arrowHeadColor) {
        this.arrowColor = arrowColor;
        this.arrowHeadColor = arrowHeadColor;
    }

    public void addToMap() {
        super.addToMap();
        if (this.timer != null) {
            this.timer.addTimeListener((TimeListener)this);
        }
    }

    public void removeFromMap() {
        super.removeFromMap();
        if (this.mouseMoveHandlerRegistration != null) {
            this.mouseMoveHandlerRegistration.removeHandler();
        }
        if (this.timer != null) {
            this.timer.removeTimeListener((TimeListener)this);
        }
    }

    protected void draw() {
        super.draw();
        if (this.mapProjection != null && this.windFieldDTO != null) {
            this.clear();
            this.drawWindField();
        }
    }

    private void clear() {
        this.canvas.getContext2d().clearRect(0.0, 0.0, (double)this.canvas.getCoordinateSpaceWidth(), (double)this.canvas.getCoordinateSpaceHeight());
        this.windFieldPoints.clear();
    }

    protected void drawWindField() {
        if (this.timer != null) {
            this.timeChanged(this.timer.getTime(), null);
        } else {
            this.drawWindField(this.windFieldDTO.getMatrix());
        }
    }

    protected void drawScaledArrow(SimulatorWindDTO windDTO, double angle, int index, boolean drawHead) {
        double aWidth = Math.max(1.0, PathPolyline.knotsToMetersPerSecond((double)windDTO.trueWindSpeedInKnots) / 2.0);
        double aLength = Math.max(10.0, 4.0 * PathPolyline.knotsToMetersPerSecond((double)windDTO.trueWindSpeedInKnots));
        this.drawArrow(windDTO, angle, aLength, aWidth, this.arrowColor, index, drawHead);
    }

    protected void drawWindField(List<SimulatorWindDTO> windDTOList) {
        boolean drawHead = true;
        this.clear();
        Context2d context2d = this.canvas.getContext2d();
        context2d.setGlobalAlpha(0.4);
        if (windDTOList != null && windDTOList.size() > 0) {
            Iterator<SimulatorWindDTO> windDTOIter = windDTOList.iterator();
            int index = 0;
            while (windDTOIter.hasNext()) {
                SimulatorWindDTO windDTO = windDTOIter.next();
                DegreeBearingImpl dbi = new DegreeBearingImpl(windDTO.trueWindBearingDeg.doubleValue());
                this.drawScaledArrow(windDTO, dbi.getRadians(), ++index, true);
            }
            String title = "Wind Field at " + windDTOList.size() + " points.";
            this.getCanvas().setTitle(title);
        }
    }

    public void timeChanged(Date newTime, Date oldTime) {
        List windDTOToDraw = new ArrayList();
        SortedMap headMap = this.timePointWindDTOMap.headMap(newTime.getTime() + 1L);
        if (!headMap.isEmpty()) {
            windDTOToDraw = (List)headMap.get(headMap.lastKey());
        }
        logger.info("In WindFieldCanvasOverlay.drawWindField drawing " + windDTOToDraw.size() + " points" + " @ " + newTime);
        this.drawWindField(windDTOToDraw);
    }

    public boolean shallStop() {
        if (!this.isVisible() || this.timePointWindDTOMap == null || this.timer == null || this.timePointWindDTOMap.isEmpty()) {
            return true;
        }
        return (Long)this.timePointWindDTOMap.lastKey() < this.timer.getTime().getTime();
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Timer getTimer() {
        return this.timer;
    }
}

