/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.common.authentication.FixedSailingAuthentication;
import com.sap.sailing.gwt.common.authentication.SAPSailingHeaderWithAuthentication;
import com.sap.sailing.gwt.ui.client.AbstractSailingReadEntryPoint;
import com.sap.sailing.gwt.ui.client.SimulatorService;
import com.sap.sailing.gwt.ui.client.SimulatorServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.simulator.StreamletParameters;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.EntryPointHelper;
import com.sap.sse.gwt.client.ServerInfoDTO;
import com.sap.sse.gwt.resources.Highcharts;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.NamedSecuredObjectDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.authentication.decorator.WidgetFactory;
import com.sap.sse.security.ui.authentication.generic.GenericAuthentication;
import com.sap.sse.security.ui.authentication.generic.GenericAuthorizedContentDecorator;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import java.util.logging.Logger;

public class SimulatorEntryPoint
extends AbstractSailingReadEntryPoint {
    private final SimulatorServiceAsync simulatorService = (SimulatorServiceAsync)GWT.create(SimulatorService.class);
    private int xRes = 40;
    private int yRes = 20;
    private int border = 0;
    private StreamletParameters streamletPars = new StreamletParameters();
    private boolean autoUpdate = false;
    private char mode = (char)101;
    private char event = (char)107;
    private boolean showArrows = false;
    private boolean showGrid = false;
    private boolean showLines = false;
    private boolean showMapControls = true;
    private char seedLines = (char)98;
    private boolean showLineGuides = false;
    private boolean showStreamlets = true;
    private static Logger logger = Logger.getLogger(SimulatorEntryPoint.class.getName());

    protected void doOnModuleLoad() {
        Highcharts.ensureInjectedWithExport();
        super.doOnModuleLoad();
        EntryPointHelper.registerASyncService((ServiceDefTarget)((ServiceDefTarget)this.simulatorService), (String)"service/simulator", (Util.Pair[])new Util.Pair[]{HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA});
        this.checkUrlParameters();
        this.getUserService().executeWithServerInfo(serverInfo -> this.createSimulatorPanel(serverInfo));
    }

    private void checkUrlParameters() {
        String horizontalRes = Window.Location.getParameter((String)"horizontalRes");
        if (horizontalRes == null || horizontalRes.isEmpty()) {
            logger.config("Using default horizontal resolution " + this.xRes);
        } else {
            this.xRes = Integer.parseInt(horizontalRes);
        }
        String verticalRes = Window.Location.getParameter((String)"verticalRes");
        if (verticalRes == null || verticalRes.isEmpty()) {
            logger.config("Using default horizontal resolution " + this.yRes);
        } else {
            this.yRes = Integer.parseInt(verticalRes);
        }
        String border = Window.Location.getParameter((String)"border");
        if (border == null || border.isEmpty()) {
            logger.config("Using default border " + this.border);
        } else {
            this.border = Integer.parseInt(border);
        }
        this.streamletPars.macroWeather = false;
        this.streamletPars.motionScale = 1.0;
        this.streamletPars.swarmScale = 1.0;
        this.streamletPars.detailZoom = 15;
        String tmpStr = Window.Location.getParameter((String)"motionScale");
        if (tmpStr == null || tmpStr.isEmpty()) {
            logger.config("Using default motionScale.");
        } else {
            this.streamletPars.motionScale = Double.parseDouble(tmpStr);
        }
        tmpStr = Window.Location.getParameter((String)"swarmScale");
        if (tmpStr == null || tmpStr.isEmpty()) {
            logger.config("Using default swarmScale.");
        } else {
            this.streamletPars.swarmScale = Double.parseDouble(tmpStr);
        }
        tmpStr = Window.Location.getParameter((String)"lineBase");
        if (tmpStr == null || tmpStr.isEmpty()) {
            logger.config("Using default lineBase.");
        } else {
            this.streamletPars.lineBase = Double.parseDouble(tmpStr);
        }
        tmpStr = Window.Location.getParameter((String)"lineScale");
        if (tmpStr == null || tmpStr.isEmpty()) {
            logger.config("Using default lineScale.");
        } else {
            this.streamletPars.lineScale = Double.parseDouble(tmpStr);
        }
        tmpStr = Window.Location.getParameter((String)"detailZoom");
        if (tmpStr == null || tmpStr.isEmpty()) {
            logger.config("Using default detailZoom.");
        } else {
            this.streamletPars.detailZoom = Integer.parseInt(tmpStr);
        }
        String autoUpdateStr = Window.Location.getParameter((String)"autoUpdate");
        if (autoUpdateStr == null || autoUpdateStr.isEmpty()) {
            logger.config("Using default auto update " + this.autoUpdate);
        } else {
            this.autoUpdate = Boolean.parseBoolean(autoUpdateStr);
        }
        String showMapControlsStr = Window.Location.getParameter((String)"showMapControls");
        if (showMapControlsStr == null || showMapControlsStr.isEmpty()) {
            logger.config("Using default showMapControls " + this.showMapControls);
        } else {
            this.showMapControls = Boolean.parseBoolean(showMapControlsStr);
        }
        String modeStr = Window.Location.getParameter((String)"mode");
        if (modeStr == null || modeStr.isEmpty()) {
            logger.config("Using default mode " + this.mode);
        } else {
            this.mode = modeStr.charAt(0);
            if (this.mode == 'm') {
                this.showArrows = true;
                this.showGrid = false;
                this.showLines = false;
                this.showLineGuides = false;
            }
        }
        String eventStr = Window.Location.getParameter((String)"event");
        if (eventStr == null || eventStr.isEmpty()) {
            logger.config("Using default event: " + this.event);
        } else {
            this.event = eventStr.charAt(0);
        }
        String windDisplayStr = Window.Location.getParameter((String)"windDisplay");
        if (windDisplayStr == null || windDisplayStr.isEmpty()) {
            logger.config("Using default showGrid " + this.showGrid + " & default showArrows " + this.showArrows);
        } else {
            this.showGrid = windDisplayStr.contains("g");
            this.showLines = windDisplayStr.contains("l");
            this.showArrows = windDisplayStr.contains("a");
            this.showLineGuides = windDisplayStr.contains("s");
            this.showStreamlets = windDisplayStr.contains("z");
            if (windDisplayStr.contains("b")) {
                this.seedLines = (char)98;
            }
            if (windDisplayStr.contains("f")) {
                this.seedLines = (char)102;
            }
            if (windDisplayStr.contains("m")) {
                this.streamletPars.macroWeather = true;
            }
        }
        if (this.showStreamlets && border == null) {
            this.border = 10;
        }
    }

    private void createSimulatorPanel(ServerInfoDTO serverInfo) {
        SAPSailingHeaderWithAuthentication header = new SAPSailingHeaderWithAuthentication(((StringMessages)this.getStringMessages()).strategySimulatorTitle());
        PaywallResolverImpl paywallResolver = new PaywallResolverImpl(this.getUserService(), this.getSubscriptionServiceFactory());
        FixedSailingAuthentication genericSailingAuthentication = new FixedSailingAuthentication(this.getUserService(), (PaywallResolver)paywallResolver, header.getAuthenticationMenuView());
        GenericAuthorizedContentDecorator authorizedContentDecorator = new GenericAuthorizedContentDecorator((GenericAuthentication)genericSailingAuthentication);
        String serverName = serverInfo.getName();
        authorizedContentDecorator.setPermissionToCheck((SecuredDTO)NamedSecuredObjectDTO.create((String)serverName, (HasPermissions)SecuredDomainType.SIMULATOR, (TypeRelativeObjectIdentifier)new TypeRelativeObjectIdentifier(new String[]{serverName})), (HasPermissions.Action)HasPermissions.DefaultActions.READ);
        authorizedContentDecorator.setContentWidgetFactory((WidgetFactory)new /* Unavailable Anonymous Inner Class!! */);
        RootLayoutPanel rootPanel = RootLayoutPanel.get();
        DockLayoutPanel panel = new DockLayoutPanel(Style.Unit.PX);
        panel.addNorth((Widget)header, 75.0);
        panel.add((Widget)authorizedContentDecorator);
        panel.addStyleName("dockLayoutPanel");
        rootPanel.add((Widget)panel);
    }

    static /* synthetic */ SimulatorServiceAsync access$0(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.simulatorService;
    }

    static /* synthetic */ com.sap.sse.gwt.client.StringMessages access$1(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.getStringMessages();
    }

    static /* synthetic */ int access$2(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.xRes;
    }

    static /* synthetic */ int access$3(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.yRes;
    }

    static /* synthetic */ int access$4(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.border;
    }

    static /* synthetic */ StreamletParameters access$5(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.streamletPars;
    }

    static /* synthetic */ boolean access$6(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.autoUpdate;
    }

    static /* synthetic */ char access$7(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.mode;
    }

    static /* synthetic */ char access$8(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.event;
    }

    static /* synthetic */ boolean access$9(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.showGrid;
    }

    static /* synthetic */ boolean access$10(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.showLines;
    }

    static /* synthetic */ char access$11(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.seedLines;
    }

    static /* synthetic */ boolean access$12(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.showArrows;
    }

    static /* synthetic */ boolean access$13(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.showLineGuides;
    }

    static /* synthetic */ boolean access$14(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.showStreamlets;
    }

    static /* synthetic */ boolean access$15(SimulatorEntryPoint simulatorEntryPoint) {
        return simulatorEntryPoint.showMapControls;
    }
}

