/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.simulator.CourseAreaDescriptor;
import com.sap.sailing.gwt.ui.simulator.RaceCourseCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.SimulatorMap;
import com.sap.sailing.gwt.ui.simulator.VenueDescriptor;
import com.sap.sailing.gwt.ui.simulator.VenueDescriptorFactory;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;

public class RegattaAreaCanvasOverlay
extends FullCanvasOverlay {
    private SimulatorMap simulatorMap;
    private RaceCourseCanvasOverlay raceCourseCanvasOverlay;
    private VenueDescriptor venue;
    private CourseAreaDescriptor currentCourseArea = null;
    private boolean initial;
    private double raceBearing = 0.0;
    private double diffBearing = 0.0;

    public RegattaAreaCanvasOverlay(MapWidget map, int zIndex, char event, SimulatorMap simulatorMap, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.simulatorMap = simulatorMap;
        this.venue = VenueDescriptorFactory.createVenue((char)event, (CoordinateSystem)coordinateSystem);
        this.currentCourseArea = this.venue.getDefaultCourseArea();
    }

    public void addToMap() {
        super.addToMap();
        int counter = 0;
        for (CourseAreaDescriptor courseArea : this.venue.getCourseAreas()) {
            this.simulatorMap.drawCircleFromRadius(counter++, courseArea);
        }
        this.map.panTo(this.venue.getCenterPos());
        this.initial = true;
    }

    protected void draw() {
        super.draw();
        if (this.mapProjection != null) {
            this.clearCanvas();
            this.drawRegattaAreas();
            if (this.initial) {
                this.updateRaceCourse(0, 0.0);
                this.initial = false;
            }
        }
    }

    private void clearCanvas() {
        this.canvas.getContext2d().clearRect(0.0, 0.0, (double)this.canvas.getCoordinateSpaceWidth(), (double)this.canvas.getCoordinateSpaceHeight());
    }

    protected void drawRegattaAreas() {
        LatLng cPos = this.coordinateSystem.toLatLng((Position)new DegreePosition(54.4344, 10.19659167));
        Point centerPoint = this.mapProjection.fromLatLngToDivPixel(cPos);
        Point borderPoint = this.mapProjection.fromLatLngToDivPixel(this.getEdgePoint(cPos, 0.015));
        double pxStroke = Math.pow(2.0, ((double)this.getMap().getZoom() - 10.0) / 2.0);
        Context2d context2d = this.canvas.getContext2d();
        context2d.setLineWidth(3.0);
        context2d.setStrokeStyle("Black");
        for (CourseAreaDescriptor courseArea : this.venue.getCourseAreas()) {
            centerPoint = this.mapProjection.fromLatLngToDivPixel(courseArea.getCenterPos());
            borderPoint = this.mapProjection.fromLatLngToDivPixel(courseArea.getEdgePos());
            this.drawCourseArea(courseArea.getName(), context2d, centerPoint, borderPoint, courseArea.getColor(), courseArea.getColorText(), pxStroke);
        }
    }

    protected void updateRaceCourse(int type, double bearing) {
        if (type == 1) {
            this.raceBearing = bearing;
            this.simulatorMap.getWindNeedleCanvasOverlay().setBearing(this.raceBearing + 180.0);
        } else if (type == 2) {
            this.diffBearing = bearing;
        }
        if (this.currentCourseArea != null) {
            LatLng endPoint;
            LatLng startPoint;
            this.simulatorMap.getMainPanel().setUpdateButtonEnabled(true);
            if (this.raceCourseCanvasOverlay.raceCourseDirection == 'd') {
                startPoint = this.getDistantPoint(this.currentCourseArea.getCenterPos(), 0.9 * this.currentCourseArea.getRadius(), 0.0 + this.raceBearing - this.diffBearing);
                endPoint = this.getDistantPoint(this.currentCourseArea.getCenterPos(), 0.9 * this.currentCourseArea.getRadius(), 180.0 + this.raceBearing - this.diffBearing);
            } else {
                startPoint = this.getDistantPoint(this.currentCourseArea.getCenterPos(), 0.9 * this.currentCourseArea.getRadius(), 180.0 + this.raceBearing - this.diffBearing);
                endPoint = this.getDistantPoint(this.currentCourseArea.getCenterPos(), 0.9 * this.currentCourseArea.getRadius(), 0.0 + this.raceBearing - this.diffBearing);
            }
            this.raceCourseCanvasOverlay.setStartEndPoint(startPoint, endPoint);
        } else {
            this.simulatorMap.getMainPanel().setUpdateButtonEnabled(false);
        }
    }

    public CourseAreaDescriptor getCurrentCourseArea() {
        return this.currentCourseArea;
    }

    public void setCurrentCourseArea(CourseAreaDescriptor courseArea) {
        this.currentCourseArea = courseArea;
    }

    protected void drawCourseArea(String name, Context2d context2d, Point centerPoint, Point borderPoint, String color, String colorText, double pxStroke) {
        Point diffPoint = Point.newInstance((double)(centerPoint.getX() - borderPoint.getX()), (double)(centerPoint.getY() - borderPoint.getY()));
        double pxRadius = Math.sqrt(diffPoint.getX() * diffPoint.getX() + diffPoint.getY() * diffPoint.getY());
        String bgColor = this.simulatorMap.getWindParams().isShowStreamlets() ? "#505050" : "#DEDEDE";
        context2d.setGlobalAlpha(1.0);
        context2d.setFillStyle(bgColor);
        context2d.beginPath();
        context2d.arc(centerPoint.getX() - this.getWidgetPosLeft(), centerPoint.getY() - this.getWidgetPosTop(), pxRadius, 0.0, Math.PI * 2);
        context2d.closePath();
        context2d.fill();
        context2d.setGlobalAlpha(0.5);
        context2d.setFillStyle(color);
        context2d.beginPath();
        context2d.arc(centerPoint.getX() - this.getWidgetPosLeft(), centerPoint.getY() - this.getWidgetPosTop(), pxRadius, 0.0, Math.PI * 2);
        context2d.closePath();
        context2d.fill();
        context2d.setGlobalAlpha(1.0);
        context2d.setLineWidth(pxStroke);
        context2d.setStrokeStyle(bgColor);
        context2d.beginPath();
        context2d.arc(centerPoint.getX() - this.getWidgetPosLeft(), centerPoint.getY() - this.getWidgetPosTop(), pxRadius, 0.0, Math.PI * 2);
        context2d.closePath();
        context2d.stroke();
        context2d.setGlobalAlpha((double)0.8f);
        context2d.setLineWidth(pxStroke);
        context2d.setStrokeStyle(color);
        context2d.beginPath();
        context2d.arc(centerPoint.getX() - this.getWidgetPosLeft(), centerPoint.getY() - this.getWidgetPosTop(), pxRadius, 0.0, Math.PI * 2);
        context2d.closePath();
        context2d.stroke();
        if (this.getMap().getZoom() >= 11) {
            context2d.setGlobalAlpha((double)0.8f);
            context2d.setFillStyle(colorText);
            double fontsize = 14.0 + 18.0 * ((double)this.getMap().getZoom() - 11.0) / 3.0;
            context2d.setFont("normal " + fontsize + "px Calibri");
            context2d.setTextAlign(Context2d.TextAlign.CENTER);
            context2d.fillText(name, centerPoint.getX() - this.getWidgetPosLeft(), centerPoint.getY() + 0.32 * fontsize - this.getWidgetPosTop());
        }
        context2d.setGlobalAlpha(1.0);
    }

    protected LatLng getEdgePoint(LatLng pos, double dist) {
        return this.getDistantPoint(pos, dist, 0.0);
    }

    protected LatLng getDistantPoint(LatLng pos, double dist, double degBear) {
        double lat1 = pos.getLatitude() / 180.0 * Math.PI;
        double lon1 = pos.getLongitude() / 180.0 * Math.PI;
        double brng = degBear * Math.PI / 180.0;
        double R = 6371.0;
        double d = 1.852 * dist;
        double lat2 = Math.asin(Math.sin(lat1) * Math.cos(d / R) + Math.cos(lat1) * Math.sin(d / R) * Math.cos(brng));
        double lon2 = lon1 + Math.atan2(Math.sin(brng) * Math.sin(d / R) * Math.cos(lat1), Math.cos(d / R) - Math.sin(lat1) * Math.sin(lat2));
        lon2 = (lon2 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        double lat2deg = lat2 / Math.PI * 180.0;
        double lon2deg = lon2 / Math.PI * 180.0;
        LatLng result = LatLng.newInstance((double)lat2deg, (double)lon2deg);
        return result;
    }

    public void setRaceCourseCanvas(RaceCourseCanvasOverlay rcCanvas) {
        this.raceCourseCanvasOverlay = rcCanvas;
    }

    public VenueDescriptor getVenue() {
        return this.venue;
    }
}

