/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.i18n.shared.TimeZone;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.geometrylib.SphericalUtils;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.gwt.ui.shared.WindFieldGenParamsDTO;
import com.sap.sailing.gwt.ui.simulator.WindFieldCanvasOverlay;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Named;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.gwt.client.player.Timer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class PathCanvasOverlay
extends WindFieldCanvasOverlay
implements Named {
    private static final long serialVersionUID = -6284996043723173190L;
    private static int MinimumPxDistanceBetweenArrows = 60;
    private LatLng startPoint;
    private LatLng endPoint;
    private boolean totalTimeIsGiven = false;
    private long totalTimeMilliseconds = 0L;
    private String name;
    private boolean algorithmTimedOut;
    private boolean mixedLeg;
    private String pathColor = "Green";
    public boolean displayWindAlongPath = true;

    public PathCanvasOverlay(MapWidget map, int zIndex, String name, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.name = name;
    }

    public PathCanvasOverlay(MapWidget map, int zIndex, String name, Timer timer, WindFieldGenParamsDTO windParams, boolean algorithmTimedOut, boolean mixedLeg, CoordinateSystem coordinateSystem) {
        super(map, zIndex, timer, windParams, coordinateSystem);
        this.name = name;
        this.algorithmTimedOut = algorithmTimedOut;
        this.mixedLeg = mixedLeg;
    }

    public PathCanvasOverlay(MapWidget map, int zIndex, String name, long totalTimeMilliseconds, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.name = name;
        this.totalTimeIsGiven = true;
        this.totalTimeMilliseconds = totalTimeMilliseconds;
    }

    public PathCanvasOverlay(MapWidget map, int zIndex, String name, long totalTimeMilliseconds, String color, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.name = name;
        this.totalTimeIsGiven = true;
        this.totalTimeMilliseconds = totalTimeMilliseconds;
        this.pathColor = color;
    }

    public PathCanvasOverlay(MapWidget map, int zIndex, String name, Timer timer, WindFieldGenParamsDTO windParams, long totalTimeMilliseconds, CoordinateSystem coordinateSystem) {
        super(map, zIndex, timer, windParams, coordinateSystem);
        this.name = name;
        this.totalTimeIsGiven = true;
        this.totalTimeMilliseconds = totalTimeMilliseconds;
    }

    public PathCanvasOverlay(MapWidget map, int zIndex, String name, Timer timer, WindFieldGenParamsDTO windParams, long totalTimeMilliseconds, String color, CoordinateSystem coordinateSystem) {
        super(map, zIndex, timer, windParams, coordinateSystem);
        this.name = name;
        this.totalTimeIsGiven = true;
        this.totalTimeMilliseconds = totalTimeMilliseconds;
        this.pathColor = color;
    }

    public void setTotalTimeMilliseconds(long totalTimeMilliseconds) {
        this.totalTimeIsGiven = true;
        this.totalTimeMilliseconds = totalTimeMilliseconds;
    }

    public long getTotalTimeMilliseconds() {
        return this.totalTimeMilliseconds;
    }

    public void setRaceCourse(LatLng startPoint, LatLng endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }

    protected void drawWindField(List<SimulatorWindDTO> windDTOList) {
        int numPoints = windDTOList.size();
        if (numPoints < 1) {
            return;
        }
        Duration totalDuration = windDTOList.get((int)0).timepoint.until(windDTOList.get((int)(numPoints - 1)).timepoint);
        double distance = SphericalUtils.computeDistanceBetween((LatLng)this.startPoint, (LatLng)this.endPoint) / 1852.0;
        if (windDTOList != null && windDTOList.size() > 0) {
            Context2d context2d = this.canvas.getContext2d();
            context2d.setGlobalAlpha(0.8);
            Iterator<SimulatorWindDTO> windDTOIter = windDTOList.iterator();
            SimulatorWindDTO prevWindDTO = null;
            while (windDTOIter.hasNext()) {
                SimulatorWindDTO windDTO = windDTOIter.next();
                if (prevWindDTO != null) {
                    this.drawLine(prevWindDTO, windDTO);
                }
                prevWindDTO = windDTO;
            }
            windDTOIter = windDTOList.iterator();
            int index = 0;
            TimePoint startTime = windDTOList.get((int)0).timepoint;
            prevWindDTO = null;
            while (windDTOIter.hasNext()) {
                SimulatorWindDTO windDTO = windDTOIter.next();
                if (this.displayWindAlongPath && this.checkPointsAreFarEnough(windDTO, prevWindDTO)) {
                    DegreeBearingImpl dbi = new DegreeBearingImpl(windDTO.trueWindBearingDeg.doubleValue());
                    this.drawScaledArrow(windDTO, dbi.getRadians(), index, true);
                    prevWindDTO = windDTO;
                }
                ++index;
                long timeStep = this.windParams.getTimeStep().asMillis();
                if (startTime.until(windDTO.timepoint).asMillis() % timeStep != 0L) continue;
                this.drawPoint(windDTO);
            }
            context2d.setGlobalAlpha(1.0);
            Date timeDiffDate = new Date(totalDuration.asMillis());
            com.google.gwt.i18n.client.TimeZone gmt = com.google.gwt.i18n.client.TimeZone.createTimeZone((int)0);
            this.getCanvas().setTitle(StringMessages.INSTANCE.pathCanvasOverlayTitle(numPoints, NumberFormat.getFormat((String)"0.00").format(distance), DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.HOUR24_MINUTE_SECOND).format(timeDiffDate, (TimeZone)gmt)));
        }
    }

    private void drawLine(SimulatorWindDTO p1, SimulatorWindDTO p2) {
        double weight = 3.0;
        LatLng positionLatLng = this.coordinateSystem.toLatLng(p1.position);
        Point canvasPositionInPx = this.mapProjection.fromLatLngToDivPixel(positionLatLng);
        double x1 = canvasPositionInPx.getX() - this.getWidgetPosLeft();
        double y1 = canvasPositionInPx.getY() - this.getWidgetPosTop();
        positionLatLng = this.coordinateSystem.toLatLng(p2.position);
        canvasPositionInPx = this.mapProjection.fromLatLngToDivPixel(positionLatLng);
        double x2 = canvasPositionInPx.getX() - this.getWidgetPosLeft();
        double y2 = canvasPositionInPx.getY() - this.getWidgetPosTop();
        this.drawLine(x1, y1, x2, y2, weight, this.pathColor);
    }

    private void drawPoint(SimulatorWindDTO p) {
        double weight = 3.0;
        LatLng positionLatLng = this.coordinateSystem.toLatLng(p.position);
        Point canvasPositionInPx = this.mapProjection.fromLatLngToDivPixel(positionLatLng);
        double x1 = canvasPositionInPx.getX() - this.getWidgetPosLeft();
        double y1 = canvasPositionInPx.getY() - this.getWidgetPosTop();
        this.drawCircle(x1, y1, weight / 2.0, this.pathColor);
    }

    private boolean checkPointsAreFarEnough(SimulatorWindDTO p1, SimulatorWindDTO p2) {
        if (p1 == null || p2 == null) {
            return true;
        }
        LatLng positionLatLng = this.coordinateSystem.toLatLng(p1.position);
        Point canvasPositionInPx = this.mapProjection.fromLatLngToDivPixel(positionLatLng);
        double x1 = canvasPositionInPx.getX();
        double y1 = canvasPositionInPx.getY();
        positionLatLng = this.coordinateSystem.toLatLng(p2.position);
        canvasPositionInPx = this.mapProjection.fromLatLngToDivPixel(positionLatLng);
        double x2 = canvasPositionInPx.getX();
        double y2 = canvasPositionInPx.getY();
        double pxDistance = Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0));
        return pxDistance >= (double)MinimumPxDistanceBetweenArrows;
    }

    public String getName() {
        return this.name;
    }

    public boolean getAlgorithmTimedOut() {
        return this.algorithmTimedOut;
    }

    public boolean getMixedLeg() {
        return this.mixedLeg;
    }

    public long getPathDurationMillis() {
        if (this.totalTimeIsGiven) {
            return this.totalTimeMilliseconds;
        }
        List windDTOList = this.windFieldDTO.getMatrix();
        int numPoints = windDTOList.size();
        Duration totalTime = ((SimulatorWindDTO)windDTOList.get((int)0)).timepoint.until(((SimulatorWindDTO)windDTOList.get((int)(numPoints - 1))).timepoint);
        return totalTime.asMillis();
    }

    public String getPathColor() {
        return this.pathColor;
    }

    public void setPathColor(String pathColor) {
        this.pathColor = pathColor;
    }
}

