/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator;

import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.events.center.CenterChangeMapHandler;
import com.google.gwt.resources.client.ImageResource;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.client.shared.racemap.ImageTransformer;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;

public class ImageCanvasOverlay
extends CanvasOverlayV3 {
    private int canvasWidth = 100;
    private int canvasHeight = 100;
    private int oLeft;
    private int oTop;
    private double bearing = 0.0;
    private ImageTransformer imgTrafo;

    public ImageCanvasOverlay(MapWidget map, int zIndex, ImageResource img, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        if (this.getCanvas() != null) {
            this.getCanvas().setWidth(String.valueOf(this.canvasWidth));
            this.getCanvas().setHeight(String.valueOf(this.canvasHeight));
            this.getCanvas().setCoordinateSpaceWidth(this.canvasWidth);
            this.getCanvas().setCoordinateSpaceHeight(this.canvasHeight);
        }
        this.imgTrafo = new ImageTransformer(img);
        this.getMap().addCenterChangeHandler((CenterChangeMapHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void addToMap() {
        super.addToMap();
    }

    public void setPosition() {
        if (this.mapProjection != null) {
            Point sw = this.mapProjection.fromLatLngToDivPixel(this.getMap().getBounds().getSouthWest());
            Point ne = this.mapProjection.fromLatLngToDivPixel(this.getMap().getBounds().getNorthEast());
            double pLeft = Math.min(sw.getX(), ne.getX()) - 25.0 + (double)this.oLeft;
            double pTop = Math.min(sw.getY(), ne.getY()) - 25.0 + (double)this.oTop;
            this.setCanvasPosition(pLeft, pTop);
        }
    }

    public void setOffset(int offsetLeft, int offsetTop) {
        this.oLeft = offsetLeft;
        this.oTop = offsetTop;
    }

    protected void draw() {
        if (this.mapProjection != null) {
            this.setPosition();
            this.imgTrafo.drawToCanvas(this.getCanvas(), this.bearing, 1.0);
        }
    }

    public void setBearing(double bearing) {
        this.bearing = bearing;
    }
}

