/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared.racemap;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.TextMetrics;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.controls.ControlPosition;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.ui.actions.GetWindInfoAction;
import com.sap.sailing.gwt.ui.client.NumberFormatterFactory;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.WindInfoForRaceDTO;
import com.sap.sailing.gwt.ui.simulator.StreamletParameters;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.racemap.MovingCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.streamlets.Swarm;
import com.sap.sailing.gwt.ui.simulator.streamlets.VectorField;
import com.sap.sailing.gwt.ui.simulator.streamlets.WindInfoForRaceVectorField;
import com.sap.sse.common.ColorMapperChangedListener;
import com.sap.sse.gwt.client.async.AsyncAction;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.mutationobserver.ElementStyleMutationObserver;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class WindStreamletsRaceboardOverlay
extends MovingCanvasOverlay
implements ColorMapperChangedListener,
TimeListener {
    public static final String LOAD_WIND_STREAMLET_DATA_CATEGORY = "loadWindStreamletData";
    private static final int animationIntervalMillis = 40;
    private static final long RESOLUTION_IN_MILLIS = 5000L;
    private static final int WIND_FETCH_INTERVAL_IN_MILLIS = 10000;
    private static final int CHECK_WIND_SOURCE_INTERVAL_IN_MILLIS = 60000;
    private boolean visible = false;
    private final Timer timer;
    private Swarm swarm;
    private final WindInfoForRaceVectorField windField;
    private final WindInfoForRaceDTO windInfoForRace;
    private final RegattaAndRaceIdentifier raceIdentifier;
    private final SailingServiceAsync sailingService;
    private final StringMessages stringMessages;
    private final AsyncActionsExecutor asyncActionsExecutor;
    private final Scheduler scheduler;
    private Canvas streamletLegend;
    private boolean firstColoring = true;
    private boolean colored;
    private final NumberFormat numberFormatOneDecimal = NumberFormatterFactory.getDecimalFormat((int)1);
    private ElementStyleMutationObserver observer;
    private boolean dragging = false;
    private boolean isAttached = false;
    private boolean startObserverWhenAttached = false;
    private boolean timeChangedSinceLastUpdate = true;

    public WindStreamletsRaceboardOverlay(MapWidget map, int zIndex, Timer timer, RegattaAndRaceIdentifier raceIdentifier, SailingServiceAsync sailingService, AsyncActionsExecutor asyncActionsExecutor, StringMessages stringMessages, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.scheduler = Scheduler.get();
        this.asyncActionsExecutor = asyncActionsExecutor;
        this.stringMessages = stringMessages;
        this.raceIdentifier = raceIdentifier;
        this.sailingService = sailingService;
        this.windInfoForRace = new WindInfoForRaceDTO();
        this.windInfoForRace.raceIsKnownToStartUpwind = true;
        this.windInfoForRace.windSourcesToExclude = new HashSet();
        this.windInfoForRace.windTrackInfoByWindSource = new HashMap();
        this.windField = new WindInfoForRaceVectorField(this.windInfoForRace, 25.0, coordinateSystem);
        this.timer = timer;
        this.timer.addTimeListener((TimeListener)this);
        this.getCanvas().getElement().setId("swarm-display");
        this.createStreamletLegend(map);
    }

    private void createStreamletLegend(MapWidget map) {
        this.streamletLegend = Canvas.createIfSupported();
        this.streamletLegend.addStyleName("MapStreamletLegend");
        map.setControls(ControlPosition.LEFT_BOTTOM, (Widget)this.streamletLegend);
        int canvasWidth = 500;
        int canvasHeight = 60;
        this.streamletLegend.getParent().addStyleName("MapStreamletLegendParentDiv");
        this.streamletLegend.setWidth(String.valueOf(canvasWidth));
        this.streamletLegend.setHeight(String.valueOf(canvasHeight));
        this.streamletLegend.setCoordinateSpaceWidth(canvasWidth);
        this.streamletLegend.setCoordinateSpaceHeight(canvasHeight);
    }

    public void drawLegend() {
        if (this.streamletLegend.isVisible()) {
            this.streamletLegend.getContext2d().clearRect(0.0, 0.0, (double)this.streamletLegend.getCoordinateSpaceWidth(), (double)this.streamletLegend.getCoordinateSpaceHeight());
            if (this.swarm != null && this.swarm.isColored()) {
                double speed_min;
                double x = 100.0;
                double y = 16.0;
                double w = 1.0;
                double h = 20.0;
                double speed_max = this.swarm.getValueRange().getMaxRight();
                double speed_spread = speed_max - (speed_min = this.swarm.getValueRange().getMinLeft());
                int scale_spread = speed_spread < 0.5 ? 300 : (speed_spread < 1.0 ? 100 : 50);
                int maxIdx = 300;
                Context2d context2d = this.streamletLegend.getContext2d();
                context2d.setFillStyle("rgba(0,0,0,.3)");
                context2d.setLineWidth(1.0);
                context2d.beginPath();
                context2d.fillRect(90.0, 0.0, 320.0, 56.0);
                context2d.closePath();
                context2d.stroke();
                context2d.setFillStyle("white");
                String label = this.stringMessages.windSpeedInKnots();
                TextMetrics txtmet = context2d.measureText(label);
                context2d.fillText(label, 100.0 + (300.0 - txtmet.getWidth()) / 2.0, 11.0);
                int idx = 0;
                while (idx <= 300) {
                    double speedSteps = speed_min + (double)idx * speed_spread / 300.0;
                    context2d.setFillStyle(this.swarm.getColorMapper().getColor(speedSteps));
                    context2d.beginPath();
                    context2d.fillRect(100.0 + (double)idx * 1.0, 16.0, 1.0, 20.0);
                    context2d.closePath();
                    context2d.stroke();
                    if (idx % scale_spread == 0) {
                        context2d.setStrokeStyle("white");
                        context2d.setLineWidth(1.0);
                        context2d.beginPath();
                        context2d.moveTo(100.0 + (double)idx * 1.0, 36.0);
                        context2d.lineTo(100.0 + (double)idx * 1.0, 43.0);
                        context2d.closePath();
                        context2d.stroke();
                        context2d.setFillStyle("white");
                        label = this.numberFormatOneDecimal.format(speedSteps);
                        txtmet = context2d.measureText(label);
                        context2d.fillText(label, 100.0 + (double)idx * 1.0 - txtmet.getWidth() / 2.0, 52.0);
                    }
                    ++idx;
                }
            }
        }
    }

    public void startStreamlets() {
        this.scheduleWindDataRefresh();
        if (this.swarm == null) {
            this.setCanvasSettings();
            this.swarm = new Swarm((FullCanvasOverlay)this, this.map, this.timer, (VectorField)this.windField, new StreamletParameters());
        }
        this.initCanvasOrigin();
        this.swarm.setColors(this.colored);
        this.swarm.start(40);
        this.swarm.getColorMapper().addListener((ColorMapperChangedListener)this);
    }

    public void timeChanged(Date newTime, Date oldTime) {
        this.timeChangedSinceLastUpdate = true;
    }

    private void scheduleWindDataRefresh() {
        this.scheduler.scheduleFixedPeriod((Scheduler.RepeatingCommand)new /* Unavailable Anonymous Inner Class!! */, 10000);
        this.scheduler.scheduleFixedPeriod((Scheduler.RepeatingCommand)new /* Unavailable Anonymous Inner Class!! */, 60000);
        this.updateWindSourcesToObserve((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void stopStreamlets() {
        if (this.swarm != null) {
            this.swarm.stop();
            this.swarm.getColorMapper().removeListener((ColorMapperChangedListener)this);
            this.swarm = null;
        }
    }

    private void updateWindSourcesToObserve(Runnable runWhenDone) {
        this.sailingService.getWindSourcesInfo(this.raceIdentifier, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void updateWindField() {
        Set windSourceTypeNames = this.windInfoForRace.windTrackInfoByWindSource.keySet().stream().map(windSource -> windSource.getType().name()).collect(Collectors.toSet());
        GetWindInfoAction getWind = new GetWindInfoAction(this.sailingService, this.raceIdentifier, this.timer.getTime(), 5000L, 1, windSourceTypeNames, true);
        this.asyncActionsExecutor.execute((AsyncAction)getWind, LOAD_WIND_STREAMLET_DATA_CATEGORY, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void onAttach() {
        this.isAttached = true;
        if (this.startObserverWhenAttached) {
            Scheduler.get().scheduleDeferred(() -> this.addObserverIfNecessary());
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.getCanvas() != null) {
            if (isVisible) {
                this.startStreamlets();
                if (this.colored) {
                    this.streamletLegend.setVisible(true);
                }
                this.swarm.setColors(this.colored);
                if (this.isAttached) {
                    Scheduler.get().scheduleDeferred(() -> this.addObserverIfNecessary());
                } else {
                    this.startObserverWhenAttached = true;
                }
                this.visible = isVisible;
            } else {
                if (this.swarm != null && this.swarm.isColored()) {
                    this.streamletLegend.setVisible(false);
                }
                this.stopStreamlets();
                this.removeObserverIfPresent();
                this.visible = isVisible;
            }
        }
    }

    public void setColors(boolean isColored) {
        this.colored = isColored;
        if (isColored && this.firstColoring) {
            this.firstColoring = false;
        }
        if (this.visible) {
            this.streamletLegend.setVisible(isColored);
        }
        if (this.swarm != null) {
            this.swarm.setColors(isColored);
        }
    }

    public void removeFromMap() {
        this.setVisible(false);
    }

    protected void drawCenterChanged() {
    }

    protected void removeObserverIfPresent() {
        if (this.observer != null) {
            this.observer.disconnect();
            this.observer = null;
        }
    }

    private void addObserverIfNecessary() {
        if (ElementStyleMutationObserver.isSupported() && this.observer == null) {
            this.observer = new ElementStyleMutationObserver((ElementStyleMutationObserver.DomStyleMutationCallback)new /* Unavailable Anonymous Inner Class!! */);
            this.observer.observe(this.canvas.getElement().getParentElement().getParentElement());
        }
    }

    public void onDragStart() {
        this.dragging = true;
    }

    public void onDragEnd() {
        this.dragging = false;
    }

    public void onBoundsChanged(boolean zoomChanged) {
        if (this.swarm != null) {
            if (this.dragging) {
                this.swarm.pause(2);
            } else {
                int swarmPause = zoomChanged ? 5 : 2;
                this.swarm.onBoundsChanged(zoomChanged, swarmPause);
            }
        }
    }

    public void onColorMappingChanged() {
        this.drawLegend();
    }

    static /* synthetic */ boolean access$0(WindStreamletsRaceboardOverlay windStreamletsRaceboardOverlay) {
        return windStreamletsRaceboardOverlay.timeChangedSinceLastUpdate;
    }

    static /* synthetic */ void access$1(WindStreamletsRaceboardOverlay windStreamletsRaceboardOverlay) {
        windStreamletsRaceboardOverlay.updateWindField();
    }

    static /* synthetic */ void access$2(WindStreamletsRaceboardOverlay windStreamletsRaceboardOverlay, boolean bl) {
        windStreamletsRaceboardOverlay.timeChangedSinceLastUpdate = bl;
    }

    static /* synthetic */ boolean access$3(WindStreamletsRaceboardOverlay windStreamletsRaceboardOverlay) {
        return windStreamletsRaceboardOverlay.visible;
    }

    static /* synthetic */ void access$4(WindStreamletsRaceboardOverlay windStreamletsRaceboardOverlay, Runnable runnable) {
        windStreamletsRaceboardOverlay.updateWindSourcesToObserve(runnable);
    }

    static /* synthetic */ StringMessages access$5(WindStreamletsRaceboardOverlay windStreamletsRaceboardOverlay) {
        return windStreamletsRaceboardOverlay.stringMessages;
    }

    static /* synthetic */ WindInfoForRaceDTO access$6(WindStreamletsRaceboardOverlay windStreamletsRaceboardOverlay) {
        return windStreamletsRaceboardOverlay.windInfoForRace;
    }

    static /* synthetic */ WindInfoForRaceVectorField access$7(WindStreamletsRaceboardOverlay windStreamletsRaceboardOverlay) {
        return windStreamletsRaceboardOverlay.windField;
    }
}

