/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared.racemap;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.maps.client.base.Size;
import com.sap.sailing.domain.common.RowingBoatClassMasterdata;
import com.sap.sse.common.Color;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class RowingBoatClassVectorGraphics {
    protected static final String COCKPIT_FILLCOLOR = "#888888";
    protected static final String COCKPIT_STROKECOLOR = "#000000";
    private static final double minHullLengthInPx = 25.0;
    private final double hullLengthInPx;
    private final double beamInPx;
    private final Set<RowingBoatClassMasterdata> compatibleBoatClasses;

    RowingBoatClassVectorGraphics(double boatHullLengthInPx, double boatBeamInPx, RowingBoatClassMasterdata ... compatibleBoatClasses) {
        this.hullLengthInPx = boatHullLengthInPx;
        this.beamInPx = boatBeamInPx;
        this.compatibleBoatClasses = new HashSet();
        RowingBoatClassMasterdata[] rowingBoatClassMasterdataArray = compatibleBoatClasses;
        int n = compatibleBoatClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RowingBoatClassMasterdata compatibleBoatClass = rowingBoatClassMasterdataArray[n2];
            this.compatibleBoatClasses.add(compatibleBoatClass);
            ++n2;
        }
    }

    public Set<RowingBoatClassMasterdata> getCompatibleRowingBoatClasses() {
        return Collections.unmodifiableSet(this.compatibleBoatClasses);
    }

    protected abstract void drawBoat(Context2d var1, boolean var2, String var3);

    protected abstract void drawOars(Context2d var1, boolean var2, String var3);

    public void drawRowingBoatToCanvas(Context2d ctx, boolean isPullingOars, boolean isSelected, double width, double height, Size scaleFactor, Color color) {
        ctx.save();
        ctx.clearRect(0.0, 0.0, width, height);
        ctx.translate(width / 2.0, height / 2.0);
        ctx.scale(scaleFactor.getWidth(), scaleFactor.getHeight());
        ctx.translate(-this.hullLengthInPx / 2.0, -this.beamInPx / 2.0);
        this.drawBoat(ctx, isSelected, color.getAsHtml());
        this.drawOars(ctx, isPullingOars, color.getAsHtml());
        ctx.restore();
    }

    public double getHullLengthInPx() {
        return this.hullLengthInPx;
    }

    public double getBeamInPx() {
        return this.beamInPx;
    }

    public boolean isBoatClassNameCompatible(String boatClassName) {
        return this.compatibleBoatClasses.contains(RowingBoatClassMasterdata.resolveBoatClass((String)boatClassName));
    }

    public double getMinHullLengthInPx() {
        return 25.0;
    }
}

