/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared.racemap;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.TextMetrics;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.shared.TimeZone;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.controls.ControlPosition;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.LegIdentifier;
import com.sap.sailing.domain.common.LegIdentifierImpl;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.gwt.ui.actions.GetSimulationAction;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.PathDTO;
import com.sap.sailing.gwt.ui.shared.SimulatorResultsDTO;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.gwt.ui.shared.racemap.PathNameFormatter;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sailing.gwt.ui.simulator.util.ColorPalette;
import com.sap.sailing.gwt.ui.simulator.util.ColorPaletteGenerator;
import com.sap.sse.common.Duration;
import com.sap.sse.gwt.client.async.AsyncAction;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import java.util.Date;
import java.util.List;

public class RaceSimulationOverlay
extends FullCanvasOverlay {
    public static final String GET_SIMULATION_CATEGORY = "getSimulation";
    private final String textColor = "Black";
    private final String textFont = "10pt 'Open Sans'";
    private int xOffset = 0;
    private int yOffset = 0;
    private double rectWidth = 20.0;
    private double rectHeight = 20.0;
    private final StringMessages stringMessages;
    private final RegattaAndRaceIdentifier raceIdentifier;
    private final SailingServiceAsync sailingService;
    private final AsyncActionsExecutor asyncActionsExecutor;
    private final ColorPalette colors;
    private final PathNameFormatter pathNameFormatter;
    private SimulatorResultsDTO simulationResult;
    private Boolean[] visiblePaths;
    private PathDTO racePath;
    private int raceLeg = 0;
    private long requestedSimulationVersion = 0L;
    private Canvas simulationLegend;
    private final Runnable disableRaceSimulator;

    public RaceSimulationOverlay(MapWidget map, int zIndex, RegattaAndRaceIdentifier raceIdentifier, SailingServiceAsync sailingService, StringMessages stringMessages, AsyncActionsExecutor asyncActionsExecutor, CoordinateSystem coordinateSystem, Runnable disableRaceSimulator) {
        super(map, zIndex, coordinateSystem);
        this.raceIdentifier = raceIdentifier;
        this.sailingService = sailingService;
        this.stringMessages = stringMessages;
        this.asyncActionsExecutor = asyncActionsExecutor;
        this.disableRaceSimulator = disableRaceSimulator;
        this.colors = new ColorPaletteGenerator();
        this.pathNameFormatter = new PathNameFormatter(stringMessages);
    }

    public void updateLeg(int newLeg, boolean clearCanvas, long newVersion) {
        if ((newLeg != this.raceLeg || newLeg == this.raceLeg && newVersion > this.getVersion()) && this.isVisible()) {
            if (newLeg != this.raceLeg) {
                this.raceLeg = newLeg;
                this.requestedSimulationVersion = 0L;
            } else {
                this.requestedSimulationVersion = newVersion;
            }
            if (clearCanvas) {
                this.clearCanvas();
            }
            this.simulate(newLeg);
        }
    }

    public LegIdentifier getLegIdentifier() {
        return new LegIdentifierImpl(this.raceIdentifier, this.raceLeg);
    }

    public long getVersion() {
        if (this.simulationResult == null) {
            return 0L;
        }
        return this.simulationResult.getVersion();
    }

    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (this.simulationLegend != null) {
            this.simulationLegend.setVisible(isVisible);
        }
    }

    protected void drawCenterChanged() {
        this.draw();
    }

    protected void draw() {
        if (this.mapProjection != null) {
            super.setCanvasSettings();
            this.drawPaths();
        }
    }

    private void createSimulationLegend(MapWidget map) {
        this.simulationLegend = Canvas.createIfSupported();
        this.simulationLegend.addStyleName("MapSimulationLegend");
        this.simulationLegend.setTitle(this.stringMessages.simulationLegendTooltip());
        this.simulationLegend.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        map.setControls(ControlPosition.RIGHT_BOTTOM, (Widget)this.simulationLegend);
        this.simulationLegend.getParent().addStyleName("MapSimulationLegendParentDiv");
    }

    public void clearCanvas() {
        double w = this.getCanvas().getOffsetWidth();
        double h = this.getCanvas().getOffsetHeight();
        Context2d g = this.getCanvas().getContext2d();
        g.clearRect(0.0, 0.0, w, h);
        if (this.simulationLegend != null) {
            w = this.simulationLegend.getOffsetWidth();
            h = this.simulationLegend.getOffsetHeight();
            g = this.simulationLegend.getContext2d();
            g.clearRect(0.0, 0.0, w, h);
        }
    }

    public void drawPaths() {
        if (this.simulationResult == null) {
            return;
        }
        if (this.simulationResult.getPaths() == null) {
            return;
        }
        if (this.simulationLegend == null) {
            this.createSimulationLegend(this.map);
        }
        this.drawLegend(this.simulationLegend);
        super.setCanvasSettings();
        Context2d ctxt = this.canvas.getContext2d();
        PathDTO[] paths = this.simulationResult.getPaths();
        boolean first = true;
        int colorIdx = paths.length;
        PathDTO[] pathDTOArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            PathDTO path = pathDTOArray[n2];
            if (this.visiblePaths[--colorIdx].booleanValue() && !path.getMixedLeg()) {
                List points = path.getPoints();
                ctxt.setLineWidth(3.0);
                ctxt.setGlobalAlpha(0.7);
                ctxt.setStrokeStyle(this.colors.getColor(colorIdx));
                ctxt.beginPath();
                for (SimulatorWindDTO point : points) {
                    Point px = this.mapProjection.fromLatLngToContainerPixel(this.coordinateSystem.toLatLng(point.position));
                    if (first) {
                        ctxt.moveTo(px.getX(), px.getY());
                        first = false;
                        continue;
                    }
                    ctxt.lineTo(px.getX(), px.getY());
                }
                ctxt.stroke();
                SimulatorWindDTO start = (SimulatorWindDTO)points.get(0);
                Duration timeStep = this.simulationResult.getTimeStep();
                for (SimulatorWindDTO point : points) {
                    if (start.timepoint.until(point.timepoint).asMillis() % timeStep.asMillis() != 0L) continue;
                    Point px = this.mapProjection.fromLatLngToContainerPixel(this.coordinateSystem.toLatLng(point.position));
                    ctxt.beginPath();
                    ctxt.arc(px.getX(), px.getY(), 1.5, 0.0, Math.PI * 2);
                    ctxt.closePath();
                    ctxt.stroke();
                }
            }
            ++n2;
        }
    }

    public void drawLegend(Canvas canvas) {
        PathDTO[] paths;
        if (this.simulationResult == null) {
            return;
        }
        int index = 0;
        Context2d context2d = canvas.getContext2d();
        context2d.setFont("10pt 'Open Sans'");
        TextMetrics txtmet = context2d.measureText("00:00:00");
        double timewidth = txtmet.getWidth();
        double txtmaxwidth = 0.0;
        if (this.racePath != null) {
            txtmet = context2d.measureText(this.stringMessages.raceLeader());
            txtmaxwidth = Math.max(txtmaxwidth, txtmet.getWidth());
        }
        boolean containsTimeOut = false;
        boolean containsMixedLeg = false;
        PathDTO[] pathDTOArray = paths = this.simulationResult.getPaths();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            PathDTO path = pathDTOArray[n2];
            if (path.getAlgorithmTimedOut()) {
                containsTimeOut = true;
            }
            if (path.getMixedLeg()) {
                containsMixedLeg = true;
            }
            txtmet = context2d.measureText(this.pathNameFormatter.format(path));
            txtmaxwidth = Math.max(txtmaxwidth, txtmet.getWidth());
            ++n2;
        }
        double newwidth = 0.0;
        double deltaTime = 0.0;
        double deltaMixedLeg = 0.0;
        double deltaTimeOut = 0.0;
        double mixedLegWidth = 0.0;
        if (containsMixedLeg) {
            txtmet = context2d.measureText(this.stringMessages.mixedLegText());
            mixedLegWidth = txtmet.getWidth();
            newwidth = Math.max(timewidth, mixedLegWidth);
        }
        double timeOutWidth = 0.0;
        if (containsTimeOut) {
            txtmet = context2d.measureText(this.stringMessages.algorithmTimeOutText());
            timeOutWidth = txtmet.getWidth();
            newwidth = Math.max(newwidth, timeOutWidth);
        }
        if (containsMixedLeg || containsTimeOut) {
            deltaTime = newwidth - timewidth;
            deltaMixedLeg = newwidth - mixedLegWidth;
            deltaTimeOut = newwidth - timeOutWidth;
            timewidth = newwidth;
        }
        int canvasWidth = (int)Math.ceil((double)this.xOffset + this.rectWidth + txtmaxwidth + timewidth + 10.0 + 10.0);
        int canvasHeight = (int)Math.ceil((double)this.yOffset + this.rectHeight * (double)(paths.length + (this.racePath == null ? 0 : 1)));
        this.setCanvasSize(canvas, canvasWidth, canvasHeight);
        if (this.racePath != null) {
            this.drawRectangleWithText(context2d, (double)this.xOffset, (double)this.yOffset, null, this.stringMessages.raceLeader(), this.getFormattedTime(this.racePath.getPathTime()), txtmaxwidth, timewidth, deltaTime, true);
        }
        PathDTO[] pathDTOArray2 = paths;
        int n3 = paths.length;
        int n4 = 0;
        while (n4 < n3) {
            PathDTO path = pathDTOArray2[n4];
            String timeText = path.getMixedLeg() ? this.stringMessages.mixedLegText() : (path.getAlgorithmTimedOut() ? this.stringMessages.algorithmTimeOutText() : this.getFormattedTime(path.getPathTime()));
            this.drawRectangleWithText(context2d, (double)this.xOffset, (double)this.yOffset + (double)(paths.length - index - (this.racePath == null ? 1 : 0)) * this.rectHeight, this.colors.getColor(paths.length - 1 - index), this.pathNameFormatter.format(path), timeText, txtmaxwidth, timewidth, path.getMixedLeg() ? deltaMixedLeg : (path.getAlgorithmTimedOut() ? deltaTimeOut : deltaTime), this.visiblePaths[paths.length - 1 - index].booleanValue());
            ++index;
            ++n4;
        }
    }

    protected void setCanvasSize(Canvas canvas, int canvasWidth, int canvasHeight) {
        canvas.setWidth(String.valueOf(canvasWidth));
        canvas.setHeight(String.valueOf(canvasHeight));
        canvas.setCoordinateSpaceWidth(canvasWidth);
        canvas.setCoordinateSpaceHeight(canvasHeight);
    }

    protected void drawRectangle(Context2d context2d, double x, double y, String color) {
        context2d.setFillStyle(color);
        context2d.setLineWidth(3.0);
        context2d.fillRect(x, y, this.rectWidth, this.rectHeight);
    }

    protected void drawRectangleWithText(Context2d context2d, double x, double y, String color, String text, String time, double textmaxwidth, double timewidth, double xdelta, boolean visible) {
        double offset = 3.0;
        double crossOffset = 5.0;
        context2d.setFont("10pt 'Open Sans'");
        if (color != null) {
            this.drawRectangle(context2d, x, y, color);
        }
        if (visible && color != null) {
            context2d.setGlobalAlpha(1.0);
            context2d.setLineWidth(3.0);
            context2d.setStrokeStyle("white");
            context2d.beginPath();
            context2d.moveTo(x + crossOffset, y + crossOffset);
            context2d.lineTo(x + this.rectWidth - crossOffset, y + this.rectHeight - crossOffset);
            context2d.stroke();
            context2d.beginPath();
            context2d.moveTo(x + crossOffset, y + this.rectHeight - crossOffset);
            context2d.lineTo(x + this.rectWidth - crossOffset, y + crossOffset);
            context2d.stroke();
            context2d.setStrokeStyle("black");
        }
        context2d.setGlobalAlpha(0.8);
        context2d.setFillStyle("white");
        context2d.fillRect(x + (color == null ? 0.0 : this.rectWidth), y, 20.0 + textmaxwidth + timewidth + (color == null ? this.rectWidth : 0.0), this.rectHeight);
        context2d.setGlobalAlpha(1.0);
        context2d.setFillStyle("Black");
        context2d.fillText(text, x + this.rectWidth + 5.0, y + 12.0 + offset);
        context2d.fillText(time, x + this.rectWidth + textmaxwidth + xdelta + 15.0, y + 12.0 + offset);
    }

    protected String getFormattedTime(long pathTime) {
        com.google.gwt.i18n.client.TimeZone gmt = com.google.gwt.i18n.client.TimeZone.createTimeZone((int)0);
        Date timeDiffDate = new Date(pathTime);
        String pathTimeStr = DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.HOUR24_MINUTE_SECOND).format(timeDiffDate, (TimeZone)gmt);
        return pathTimeStr;
    }

    public void simulate(int leg) {
        LegIdentifierImpl legIdentifier = new LegIdentifierImpl(this.raceIdentifier, leg);
        GetSimulationAction getSimulation = new GetSimulationAction(this.sailingService, (LegIdentifier)legIdentifier);
        this.asyncActionsExecutor.execute((AsyncAction)getSimulation, GET_SIMULATION_CATEGORY, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    static /* synthetic */ Canvas access$0(RaceSimulationOverlay raceSimulationOverlay) {
        return raceSimulationOverlay.simulationLegend;
    }

    static /* synthetic */ double access$1(RaceSimulationOverlay raceSimulationOverlay) {
        return raceSimulationOverlay.rectHeight;
    }

    static /* synthetic */ PathDTO access$2(RaceSimulationOverlay raceSimulationOverlay) {
        return raceSimulationOverlay.racePath;
    }

    static /* synthetic */ Boolean[] access$3(RaceSimulationOverlay raceSimulationOverlay) {
        return raceSimulationOverlay.visiblePaths;
    }

    static /* synthetic */ StringMessages access$4(RaceSimulationOverlay raceSimulationOverlay) {
        return raceSimulationOverlay.stringMessages;
    }

    static /* synthetic */ Runnable access$5(RaceSimulationOverlay raceSimulationOverlay) {
        return raceSimulationOverlay.disableRaceSimulator;
    }

    static /* synthetic */ long access$6(RaceSimulationOverlay raceSimulationOverlay) {
        return raceSimulationOverlay.requestedSimulationVersion;
    }

    static /* synthetic */ int access$7(RaceSimulationOverlay raceSimulationOverlay) {
        return raceSimulationOverlay.raceLeg;
    }

    static /* synthetic */ void access$8(RaceSimulationOverlay raceSimulationOverlay, SimulatorResultsDTO simulatorResultsDTO) {
        raceSimulationOverlay.simulationResult = simulatorResultsDTO;
    }

    static /* synthetic */ void access$9(RaceSimulationOverlay raceSimulationOverlay, PathDTO pathDTO) {
        raceSimulationOverlay.racePath = pathDTO;
    }

    static /* synthetic */ SimulatorResultsDTO access$10(RaceSimulationOverlay raceSimulationOverlay) {
        return raceSimulationOverlay.simulationResult;
    }

    static /* synthetic */ void access$11(RaceSimulationOverlay raceSimulationOverlay, Boolean[] booleanArray) {
        raceSimulationOverlay.visiblePaths = booleanArray;
    }

    static /* synthetic */ void access$12(RaceSimulationOverlay raceSimulationOverlay, int n) {
        raceSimulationOverlay.raceLeg = n;
    }
}

