/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared.racemap;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.TextMetrics;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.controls.ControlPosition;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.ui.client.DetailTypeFormatter;
import com.sap.sailing.gwt.ui.client.NumberFormatterFactory;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;
import com.sap.sse.common.ColorMapper;
import com.sap.sse.common.ValueRangeFlexibleBoundaries;

public class DetailTypeMetricOverlay
extends FullCanvasOverlay {
    private final String textColor = "Black";
    private final String textFont = "10pt 'Open Sans'";
    private int width = 260;
    private double lineAmount = 5.0;
    private double lineHeight = 13.0;
    private double lineMargin = 8.0;
    private final StringMessages stringMessages;
    private Canvas metricLegend;
    private ValueRangeFlexibleBoundaries valueRange;
    private ColorMapper colorMapper;
    private String detailTypeAndUnit = "";

    public DetailTypeMetricOverlay(MapWidget map, int zIndex, CoordinateSystem coordinateSystem, StringMessages stringMessages) {
        super(map, zIndex, coordinateSystem);
        this.stringMessages = stringMessages;
    }

    protected void createMetricLegend(MapWidget map) {
        this.metricLegend = Canvas.createIfSupported();
        this.metricLegend.setStyleName("MapMetricLegend");
        this.metricLegend.setTitle("Metric Legend");
        map.setControls(ControlPosition.TOP_CENTER, (Widget)this.metricLegend);
        this.metricLegend.getParent().setStyleName("MapMetricLegendParentDiv");
    }

    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (this.metricLegend != null) {
            this.metricLegend.setVisible(isVisible);
        }
    }

    protected void draw() {
        if (this.mapProjection != null) {
            super.setCanvasSettings();
            this.drawLegend();
        }
    }

    protected void drawCenterChanged() {
        this.draw();
    }

    public void clearCanvas() {
        if (this.metricLegend != null) {
            Context2d g = this.getCanvas().getContext2d();
            double w = this.metricLegend.getOffsetWidth();
            double h = this.metricLegend.getOffsetHeight();
            g = this.metricLegend.getContext2d();
            g.clearRect(0.0, 0.0, w, h);
        }
    }

    public void updateLegend(ValueRangeFlexibleBoundaries valueRange, ColorMapper colorMapper, DetailType detailType) {
        this.valueRange = valueRange;
        this.colorMapper = colorMapper;
        this.detailTypeAndUnit = detailType != null ? String.valueOf(DetailTypeFormatter.format((DetailType)detailType)) + " - " + DetailTypeFormatter.getUnit((DetailType)detailType) : "";
        this.draw();
    }

    public void drawLegend() {
        if (this.isVisible()) {
            if (this.metricLegend == null) {
                this.createMetricLegend(this.map);
            }
            Context2d context2d = this.metricLegend.getContext2d();
            int canvasHeight = (int)Math.ceil(this.lineHeight * this.lineAmount + this.lineMargin * 2.0);
            double lineWidth = (double)this.width - 2.0 * this.lineMargin;
            this.setCanvasSize(this.metricLegend, this.width, canvasHeight);
            context2d.setGlobalAlpha(0.75);
            this.drawRectangle(context2d, 0.0, 0.0, (double)this.width, (double)canvasHeight, "white");
            context2d.setGlobalAlpha(1.0);
            this.drawTextCentered(context2d, this.lineMargin, this.lineToYOffset(0), lineWidth, this.stringMessages.tailColor(), "Black");
            this.drawText(context2d, this.lineMargin * 2.0, this.lineToYOffset(1), lineWidth - 2.0 * this.lineMargin, this.detailTypeAndUnit, "Black");
            this.drawSpectrum(context2d, this.lineMargin * 2.0, this.lineToYOffset(2) - 6.0, lineWidth - 2.0 * this.lineMargin);
        }
    }

    private double lineToYOffset(int line) {
        return this.lineMargin + this.lineHeight * (double)(++line);
    }

    protected void setCanvasSize(Canvas canvas, int canvasWidth, int canvasHeight) {
        canvas.setWidth(String.valueOf(canvasWidth));
        canvas.setHeight(String.valueOf(canvasHeight));
        canvas.setCoordinateSpaceWidth(canvasWidth);
        canvas.setCoordinateSpaceHeight(canvasHeight);
    }

    protected void drawRectangle(Context2d context2d, double fromX, double fromY, double toX, double toY, String color) {
        context2d.setFillStyle(color);
        context2d.setLineWidth(3.0);
        context2d.fillRect(fromX, fromY, toX, toY);
    }

    protected void drawText(Context2d context2d, double x, double y, double maxWidth, String text, String color) {
        context2d.setFillStyle(color);
        context2d.setFont("10pt 'Open Sans'");
        context2d.fillText(text, x, y, maxWidth);
    }

    protected void drawTextCentered(Context2d context2d, double x, double y, double width, String text, String color) {
        context2d.setFont("10pt 'Open Sans'");
        TextMetrics metrics = context2d.measureText(text);
        double offset = Math.max((width - metrics.getWidth()) / 2.0, 0.0);
        this.drawText(context2d, x + offset, y, width - 2.0 * offset, text, color);
    }

    protected void drawSpectrum(Context2d context2d, double x, double y, double width) {
        int decimals;
        if (this.valueRange == null || this.colorMapper == null) {
            return;
        }
        double min = this.valueRange.getMinLeft();
        double spread = this.valueRange.getMaxRight() - min;
        int maxDigits = (int)Math.ceil(Math.log10(this.valueRange.getMaxRight()));
        int n = decimals = maxDigits - 3 <= 0 ? -(maxDigits - 3) : 0;
        int scale_spread = spread < 3.0 ? (int)width / 2 : (spread < 15.0 ? (int)width / 4 : Math.max(30, (int)width / 6));
        double h = 15.0;
        NumberFormat numberFormatOneDecimal = NumberFormatterFactory.getDecimalFormat((int)decimals);
        int idx = 0;
        while ((double)idx <= width) {
            double speedSteps = min + (double)idx * spread / width;
            context2d.setFillStyle(this.colorMapper.getColor(speedSteps));
            context2d.beginPath();
            context2d.fillRect(x + (double)idx, y, 1.0, 15.0);
            context2d.closePath();
            context2d.stroke();
            if (idx % scale_spread == 0) {
                context2d.setStrokeStyle("Black");
                context2d.setLineWidth(1.0);
                context2d.beginPath();
                context2d.moveTo(x + (double)idx, y + 15.0);
                context2d.lineTo(x + (double)idx, y + 15.0 + 7.0);
                context2d.closePath();
                context2d.stroke();
                context2d.setFillStyle("Black");
                String label = numberFormatOneDecimal.format(speedSteps);
                TextMetrics txtmet = context2d.measureText(label);
                context2d.fillText(label, x + (double)idx - txtmet.getWidth() / 2.0, y + 15.0 + 8.0 + 8.0);
            }
            ++idx;
        }
    }
}

