/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.OwnershipDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.SecurityInformationDTO;

public class TracTracConfigurationWithSecurityDTO
implements IsSerializable,
SecuredDTO {
    private static final long serialVersionUID = -3567107321280535272L;
    private SecurityInformationDTO securityInformation = new SecurityInformationDTO();
    private String name;
    private String jsonUrl;
    private String liveDataURI;
    private String storedDataURI;
    private String courseDesignUpdateURI;
    private String tracTracUsername;
    private String tracTracPassword;
    private String creatorName;

    public TracTracConfigurationWithSecurityDTO() {
    }

    public TracTracConfigurationWithSecurityDTO(String creatorName) {
        this.creatorName = creatorName;
    }

    public TracTracConfigurationWithSecurityDTO(String name, String jsonUrl, String liveDataURI, String storedDataURI, String courseDesignUpdateUrl, String tractracUsername, String tractracPassword, String creatorName) {
        this.name = name;
        this.jsonUrl = jsonUrl;
        this.liveDataURI = liveDataURI;
        this.storedDataURI = storedDataURI;
        this.courseDesignUpdateURI = courseDesignUpdateUrl;
        this.tracTracUsername = tractracUsername;
        this.tracTracPassword = tractracPassword;
        this.creatorName = creatorName;
    }

    public TracTracConfigurationWithSecurityDTO(TracTracConfigurationWithSecurityDTO config, String name) {
        this.name = name;
        this.jsonUrl = config.getJsonUrl();
        this.liveDataURI = config.getLiveDataURI();
        this.storedDataURI = config.getStoredDataURI();
        this.courseDesignUpdateURI = config.getUpdateURI();
        this.tracTracUsername = config.getTracTracUsername();
        this.tracTracPassword = config.getTracTracPassword();
        this.creatorName = config.getCreatorName();
    }

    public AccessControlListDTO getAccessControlList() {
        return this.securityInformation.getAccessControlList();
    }

    public OwnershipDTO getOwnership() {
        return this.securityInformation.getOwnership();
    }

    public void setAccessControlList(AccessControlListDTO createAccessControlListDTO) {
        this.securityInformation.setAccessControlList(createAccessControlListDTO);
    }

    public void setOwnership(OwnershipDTO createOwnershipDTO) {
        this.securityInformation.setOwnership(createOwnershipDTO);
    }

    public SecurityInformationDTO getSecurityInformation() {
        return this.securityInformation;
    }

    public String getName() {
        return this.name;
    }

    public String getJsonUrl() {
        return this.jsonUrl;
    }

    public String getLiveDataURI() {
        return this.liveDataURI;
    }

    public String getStoredDataURI() {
        return this.storedDataURI;
    }

    public String getUpdateURI() {
        return this.courseDesignUpdateURI;
    }

    public String getTracTracUsername() {
        return this.tracTracUsername;
    }

    public String getTracTracPassword() {
        return this.tracTracPassword;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.TRACTRAC_ACCOUNT;
    }

    private TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return this.creatorName == null ? new TypeRelativeObjectIdentifier(new String[]{this.jsonUrl}) : new TypeRelativeObjectIdentifier(new String[]{this.jsonUrl, this.creatorName});
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }
}

