/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.home.shared.SharedHomeResources;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.AbstractMediaUploadPopup;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.common.media.MediaType;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.media.ImageDTO;
import com.sap.sse.gwt.client.media.VideoDTO;
import com.sap.sse.gwt.client.panels.HorizontalFlowPanel;
import com.sap.sse.gwt.client.shared.components.CollapsablePanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMediaUploadPopup
extends DialogBox {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final String UPLOAD_URL = "/sailingserver/fileupload";
    private static final String DELETE_URL = "/sailingserver/api/v1/file?uri=";
    private static final String STATUS_OK = "OK";
    private static final String STATUS_NOT_OK = "NOK";
    private static final String EMPTY_MESSAGE = "-";
    protected final StringMessages i18n = StringMessages.INSTANCE;
    protected final SharedHomeResources sharedHomeResources = SharedHomeResources.INSTANCE;
    private final BiConsumer<List<ImageDTO>, List<VideoDTO>> updateImagesAndVideos;
    protected final FileUpload upload;
    protected final Button uploadButton;
    protected final FlowPanel content;
    protected final TextBox fileNameInput;
    protected final TextBox urlInput;
    protected final FlowPanel files;
    private final FlowPanel fileExistingPanel;
    private final Button saveButton;
    private FlowPanel progressOverlay;
    private final Map<String, MediaObject> mediaObjectMap = new LinkedHashMap();

    public AbstractMediaUploadPopup(BiConsumer<List<ImageDTO>, List<VideoDTO>> updateImagesAndVideos) {
        this.updateImagesAndVideos = updateImagesAndVideos;
        this.sharedHomeResources.sharedHomeCss().ensureInjected();
        this.addStyleName(this.sharedHomeResources.sharedHomeCss().popup());
        this.setTitle(this.i18n.upload());
        Label headerLabel = new Label(this.i18n.upload());
        HorizontalFlowPanel hFlow = new HorizontalFlowPanel();
        hFlow.add((Widget)headerLabel);
        this.setHTML(hFlow.getElement().getInnerHTML());
        this.setGlassEnabled(true);
        this.setAnimationEnabled(true);
        this.setModal(true);
        this.upload = new FileUpload();
        this.upload.getElement().setAttribute("accept", "image/*,video/ogg,video/mp4,video/quicktime,video/webm");
        this.upload.getElement().setAttribute("multiple", "multiple");
        this.upload.setVisible(false);
        this.upload.setName("file");
        this.content = new FlowPanel();
        this.fileNameInput = new TextBox();
        this.urlInput = new TextBox();
        FormPanel uploadForm = new FormPanel();
        uploadForm.setEncoding("multipart/form-data");
        uploadForm.setMethod("post");
        uploadForm.setAction(UPLOAD_URL);
        uploadForm.add((Widget)this.upload);
        uploadForm.addSubmitHandler((FormPanel.SubmitHandler)new SubmitHandler(this));
        uploadForm.addSubmitCompleteHandler((FormPanel.SubmitCompleteHandler)new SubmitCompleteHandler(this, null));
        this.content.add((Widget)uploadForm);
        FormPanel metaDataForm = new FormPanel();
        VerticalPanel metaDataPanel = new VerticalPanel();
        metaDataForm.add((Widget)metaDataPanel);
        Label fileNameLabel = new Label(this.i18n.fileUpload());
        fileNameLabel.addStyleName(this.sharedHomeResources.sharedHomeCss().label());
        metaDataPanel.add((Widget)fileNameLabel);
        FlowPanel fileInputGroup = new FlowPanel();
        fileInputGroup.addStyleName(this.sharedHomeResources.sharedHomeCss().inputGroup());
        this.uploadButton = new Button();
        this.uploadButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.uploadButton.addStyleName(this.sharedHomeResources.sharedHomeCss().uploadButton());
        this.fileNameInput.setName("textBoxFormElement");
        this.fileNameInput.addStyleName(this.sharedHomeResources.sharedHomeCss().input());
        this.fileNameInput.setEnabled(false);
        fileInputGroup.add((Widget)this.fileNameInput);
        fileInputGroup.add((Widget)this.uploadButton);
        metaDataPanel.add((Widget)fileInputGroup);
        metaDataPanel.add((Widget)new Label("-- " + this.i18n.or() + " --"));
        Label urlLabel = new Label(this.i18n.url());
        urlLabel.addStyleName(this.sharedHomeResources.sharedHomeCss().label());
        metaDataPanel.add((Widget)urlLabel);
        this.urlInput.addStyleName(this.sharedHomeResources.sharedHomeCss().input());
        this.urlInput.ensureDebugId("urlInput");
        this.urlInput.addKeyUpHandler((KeyUpHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.urlInput.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        metaDataPanel.add((Widget)this.urlInput);
        Label uploadedFiles = new Label(this.i18n.uploadedFiles());
        uploadedFiles.addStyleName(this.sharedHomeResources.sharedHomeCss().label());
        metaDataPanel.add((Widget)uploadedFiles);
        this.files = new FlowPanel();
        metaDataPanel.add((Widget)this.files);
        this.fileExistingPanel = new FlowPanel();
        this.fileExistingPanel.add((Widget)new Label("-- " + this.i18n.noMediaSelected() + " --"));
        metaDataPanel.add((Widget)this.fileExistingPanel);
        FlowPanel buttonGroup = new FlowPanel();
        buttonGroup.addStyleName(this.sharedHomeResources.sharedHomeCss().buttonGroup());
        buttonGroup.addStyleName(this.sharedHomeResources.sharedHomeCss().right());
        metaDataPanel.add((Widget)buttonGroup);
        Button cancelButton = new Button(this.i18n.cancel(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        cancelButton.ensureDebugId("cancelButton");
        buttonGroup.add((Widget)cancelButton);
        this.saveButton = new Button(this.i18n.save(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.saveButton.addStyleName(this.sharedHomeResources.sharedHomeCss().primary());
        this.saveButton.setEnabled(false);
        buttonGroup.add((Widget)this.saveButton);
        metaDataForm.addSubmitHandler((FormPanel.SubmitHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.content.add((Widget)metaDataForm);
        this.upload.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.progressOverlay = new FlowPanel();
        this.progressOverlay.ensureDebugId("ProgressOverlay");
        this.progressOverlay.addStyleName(this.sharedHomeResources.sharedHomeCss().progressOverlay());
        FlowPanel progressSpinner = new FlowPanel();
        progressSpinner.addStyleName(this.sharedHomeResources.sharedHomeCss().progressSpinner());
        this.progressOverlay.add((Widget)progressSpinner);
        this.progressOverlay.setVisible(false);
        Button headerCancelButton = new Button("X", (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        headerCancelButton.addStyleName(SharedHomeResources.INSTANCE.sharedHomeCss().headerButton());
        this.content.add((Widget)headerCancelButton);
        this.content.add((Widget)this.progressOverlay);
        this.content.ensureDebugId("mediaUploadContent");
        this.add((Widget)this.content);
    }

    private void closePopup(ClickEvent event) {
        event.stopPropagation();
        this.fileNameInput.setValue((Object)"");
        this.cleanupTempFileUpload();
        this.hide();
    }

    protected abstract String getTitleFromFileName(String var1);

    private ListBox initMediaTypes() {
        ListBox mimeTypeListBox = new ListBox();
        mimeTypeListBox.ensureDebugId("mimeTypeListBox");
        mimeTypeListBox.addItem(MimeType.unknown.name());
        MimeType[] mimeTypeArray = MimeType.values();
        int n = mimeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MimeType mimeType = mimeTypeArray[n2];
            if (mimeType.isVideo() || mimeType.isImage()) {
                mimeTypeListBox.addItem(mimeType.name());
            }
            ++n2;
        }
        mimeTypeListBox.setSelectedIndex(0);
        mimeTypeListBox.addStyleName(this.sharedHomeResources.sharedHomeCss().select());
        return mimeTypeListBox;
    }

    private void selectMimeTypeInBox(ListBox mimeTypeListBox, MimeType mimeType) {
        int i = 0;
        while (i < mimeTypeListBox.getItemCount()) {
            if (mimeType.name().equals(mimeTypeListBox.getValue(i))) {
                mimeTypeListBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    private MimeType getMimeType(String urlParam) {
        String url = urlParam == null ? "" : urlParam.trim();
        return MimeType.extractFromUrl((String)url);
    }

    public void openFileUpload() {
        this.upload.click();
    }

    public void show() {
        this.resetInput();
        this.cleanFormElements();
        super.show();
    }

    private void cleanFormElements() {
        this.fileNameInput.setValue((Object)"");
        this.urlInput.setValue((Object)"");
    }

    private void addMedia() {
        ArrayList<ImageDTO> imageList = new ArrayList<ImageDTO>();
        ArrayList<VideoDTO> videoList = new ArrayList<VideoDTO>();
        for (Map.Entry mediaObjectEntry : this.mediaObjectMap.entrySet()) {
            String inputUrl;
            String uploadUrl;
            String uri = (String)mediaObjectEntry.getKey();
            if (uri == null) {
                uploadUrl = "";
            } else if (!UriUtils.isSafeUri((String)uri.trim())) {
                this.logger.warning("Upload url is not valid: " + uri + ". Ignore upload url.");
                uploadUrl = "";
            } else {
                uploadUrl = uri.trim();
            }
            if (this.urlInput.getValue() == null) {
                inputUrl = "";
            } else if (!UriUtils.isSafeUri((String)this.urlInput.getValue())) {
                this.logger.warning("Upload url is not valid: " + uri + ". Ignore upload url.");
                inputUrl = "";
            } else {
                inputUrl = this.urlInput.getValue();
            }
            String url = uploadUrl.isEmpty() ? inputUrl : uploadUrl;
            if (!url.isEmpty()) {
                MimeType mimeType = ((MediaObject)mediaObjectEntry.getValue()).mimeType;
                this.hide();
                if (mimeType.mediaType == MediaType.image) {
                    imageList.add(this.createImage(url));
                    Notification.notify((String)this.i18n.imageAdded(), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                    continue;
                }
                if (mimeType.mediaType == MediaType.video) {
                    videoList.add(this.createVideo(url, null, mimeType));
                    Notification.notify((String)this.i18n.videoAdded(), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                    continue;
                }
                this.logger.warning("Detected MimeType is not of type video or image. File will be skipped. Found MimeType: " + mimeType);
                Notification.notify((String)this.i18n.fileWithDetectedMimeTypeNotSupported(mimeType.toString()), (Notification.NotificationType)Notification.NotificationType.WARNING);
                continue;
            }
            Notification.notify((String)this.i18n.invalidURL(), (Notification.NotificationType)Notification.NotificationType.ERROR);
        }
        if (!imageList.isEmpty() || !videoList.isEmpty()) {
            this.updateImagesAndVideos.accept(imageList, videoList);
        } else {
            this.logger.warning("No image nor video detected. Nothing will be saved.");
            Notification.notify((String)this.i18n.noImageOrVideoDetected(), (Notification.NotificationType)Notification.NotificationType.WARNING);
        }
    }

    private ImageDTO createImage(String url) {
        MediaObject mediaObject = (MediaObject)this.mediaObjectMap.get(url);
        ImageDTO image = new ImageDTO(url, new Date());
        image.setTitle(mediaObject.title);
        image.setSubtitle(mediaObject.subTitle);
        image.setCopyright(mediaObject.copyright);
        List<String> defaultTags = Collections.singletonList(MediaTagConstants.GALLERY.getName());
        image.setTags(defaultTags);
        return image;
    }

    private VideoDTO createVideo(String url, String thumbnailUrl, MimeType mimeType) {
        MediaObject mediaObject = (MediaObject)this.mediaObjectMap.get(url);
        VideoDTO video = new VideoDTO(url, mimeType, new Date());
        video.setTitle(mediaObject.title);
        video.setSubtitle(mediaObject.subTitle);
        video.setCopyright(mediaObject.copyright);
        video.setThumbnailRef(thumbnailUrl);
        List<String> defaultTags = Collections.singletonList(MediaTagConstants.GALLERY.getName());
        video.setTags(defaultTags);
        return video;
    }

    private void cleanupTempFileUpload() {
        for (String uri : this.mediaObjectMap.keySet()) {
            MediaObject mediaObject = (MediaObject)this.mediaObjectMap.get(uri);
            if (uri == null || mediaObject == null || Arrays.asList(MimeType.unknown, MimeType.youtube, MimeType.vimeo).contains(mediaObject.mimeType)) continue;
            String url = DELETE_URL + uri;
            RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.DELETE, url);
            requestBuilder.setCallback((RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
            try {
                this.resetInput();
                this.cleanFormElements();
                requestBuilder.send();
            }
            catch (RequestException e) {
                Notification.notify((String)this.i18n.error(), (Notification.NotificationType)Notification.NotificationType.ERROR);
                this.logger.log(Level.SEVERE, "Cleanup file failed. Sending caused an error: " + e.getMessage(), e);
            }
        }
        this.mediaObjectMap.clear();
    }

    private void resetInput() {
        this.fileExistingPanel.setVisible(true);
        this.files.clear();
        this.saveButton.setEnabled(false);
        this.urlInput.setEnabled(true);
    }

    private void setCollapsebleFilePanelHeader(CollapsablePanel collapsebleFilePanel, String fileName, MimeType mimeType) {
        String header = fileName != null && !fileName.isEmpty() && mimeType != null ? String.valueOf(fileName) + " (" + mimeType.name() + ")" : (mimeType != null ? mimeType.name() : "n/a");
        collapsebleFilePanel.getHeaderTextAccessor().setText(header);
    }

    private void addUri(String uri, String fileName, MimeType mimeType, boolean enableUrlInput) {
        String title;
        MediaObject mediaObject = new MediaObject(null);
        this.mediaObjectMap.put(uri, mediaObject);
        mediaObject.mimeType = mimeType;
        mediaObject.title = title = this.getTitleFromFileName(fileName);
        VerticalPanel vPanel = new VerticalPanel();
        boolean firstCollapsible = true;
        int i = 0;
        while (i < this.files.getWidgetCount()) {
            if (this.files.getWidget(i) instanceof CollapsablePanel) {
                firstCollapsible = false;
                ((CollapsablePanel)this.files.getWidget(i)).setCollapsingEnabled(true);
                break;
            }
            ++i;
        }
        CollapsablePanel collapsebleFilePanel = new CollapsablePanel(fileName, true);
        this.setCollapsebleFilePanelHeader(collapsebleFilePanel, title, mimeType);
        collapsebleFilePanel.setContent((Widget)vPanel);
        collapsebleFilePanel.setWidth("100%");
        if (firstCollapsible) {
            collapsebleFilePanel.setCollapsingEnabled(false);
            collapsebleFilePanel.setOpen(true);
        }
        Label fileNameLabel = new Label(fileName);
        fileNameLabel.addStyleName(this.sharedHomeResources.sharedHomeCss().subTitle());
        Label titleLabel = new Label(this.i18n.title());
        titleLabel.addStyleName(this.sharedHomeResources.sharedHomeCss().label());
        vPanel.add((Widget)titleLabel);
        TextBox titleTextBox = new TextBox();
        titleTextBox.addStyleName(this.sharedHomeResources.sharedHomeCss().input());
        titleTextBox.setText(title);
        titleTextBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        vPanel.add((Widget)titleTextBox);
        Label subtitleLabel = new Label(this.i18n.subtitle());
        subtitleLabel.addStyleName(this.sharedHomeResources.sharedHomeCss().label());
        vPanel.add((Widget)subtitleLabel);
        TextBox subtitleTextBox = new TextBox();
        subtitleTextBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        subtitleTextBox.addStyleName(this.sharedHomeResources.sharedHomeCss().input());
        vPanel.add((Widget)subtitleTextBox);
        Label copyrightLabel = new Label(this.i18n.copyright());
        copyrightLabel.addStyleName(this.sharedHomeResources.sharedHomeCss().label());
        vPanel.add((Widget)copyrightLabel);
        TextBox copyrightTextBox = new TextBox();
        copyrightTextBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        copyrightTextBox.addStyleName(this.sharedHomeResources.sharedHomeCss().input());
        vPanel.add((Widget)copyrightTextBox);
        Label mimeTypeListLabel = new Label(this.i18n.mimeType());
        mimeTypeListLabel.addStyleName(this.sharedHomeResources.sharedHomeCss().label());
        vPanel.add((Widget)mimeTypeListLabel);
        ListBox mediaTypeListBox = this.initMediaTypes();
        mediaTypeListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.selectMimeTypeInBox(mediaTypeListBox, this.getMimeType(uri));
        vPanel.add((Widget)mediaTypeListBox);
        this.files.add((Widget)collapsebleFilePanel);
        this.fileExistingPanel.setVisible(false);
        this.saveButton.setEnabled(true);
        this.urlInput.setEnabled(enableUrlInput);
        this.checkSaveButton();
    }

    private void checkSaveButton() {
        boolean urlInputNotEmpty = this.urlInput.getValue() != null && !this.urlInput.getValue().trim().isEmpty();
        boolean uriNotEmpty = !this.mediaObjectMap.isEmpty();
        this.saveButton.setEnabled(urlInputNotEmpty || uriNotEmpty);
    }

    static /* synthetic */ FlowPanel access$0(AbstractMediaUploadPopup abstractMediaUploadPopup) {
        return abstractMediaUploadPopup.progressOverlay;
    }

    static /* synthetic */ void access$1(AbstractMediaUploadPopup abstractMediaUploadPopup) {
        abstractMediaUploadPopup.cleanFormElements();
    }

    static /* synthetic */ Logger access$2(AbstractMediaUploadPopup abstractMediaUploadPopup) {
        return abstractMediaUploadPopup.logger;
    }

    static /* synthetic */ void access$3(AbstractMediaUploadPopup abstractMediaUploadPopup, String string, String string2, MimeType mimeType, boolean bl) {
        abstractMediaUploadPopup.addUri(string, string2, mimeType, bl);
    }

    static /* synthetic */ void access$4(AbstractMediaUploadPopup abstractMediaUploadPopup) {
        abstractMediaUploadPopup.checkSaveButton();
    }

    static /* synthetic */ Map access$5(AbstractMediaUploadPopup abstractMediaUploadPopup) {
        return abstractMediaUploadPopup.mediaObjectMap;
    }

    static /* synthetic */ MimeType access$6(AbstractMediaUploadPopup abstractMediaUploadPopup, String string) {
        return abstractMediaUploadPopup.getMimeType(string);
    }

    static /* synthetic */ void access$7(AbstractMediaUploadPopup abstractMediaUploadPopup, ClickEvent clickEvent) {
        abstractMediaUploadPopup.closePopup(clickEvent);
    }

    static /* synthetic */ void access$8(AbstractMediaUploadPopup abstractMediaUploadPopup) {
        abstractMediaUploadPopup.addMedia();
    }

    static /* synthetic */ void access$9(AbstractMediaUploadPopup abstractMediaUploadPopup) {
        abstractMediaUploadPopup.cleanupTempFileUpload();
    }

    static /* synthetic */ void access$10(AbstractMediaUploadPopup abstractMediaUploadPopup, CollapsablePanel collapsablePanel, String string, MimeType mimeType) {
        abstractMediaUploadPopup.setCollapsebleFilePanelHeader(collapsablePanel, string, mimeType);
    }
}

