/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard.tagging;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.Random;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HeaderPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.NoSelectionModel;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProviderListener;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagButton;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagCell;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagFilterPanel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagFooterPanel;
import com.sap.sailing.gwt.ui.raceboard.tagging.TagListProvider;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingComponent;
import com.sap.sailing.gwt.ui.raceboard.tagging.TaggingPanelResources;
import com.sap.sailing.gwt.ui.shared.RaceTimesInfoDTO;
import com.sap.sailing.gwt.ui.shared.StrippedLeaderboardDTO;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.Storage;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.ComponentWithoutSettings;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.gwt.client.xdstorage.CrossDomainStorage;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.UserDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.UserStatusEventHandler;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class TaggingComponent
extends ComponentWithoutSettings
implements RaceTimesInfoProviderListener,
UserStatusEventHandler,
TimeListener {
    private static final int FOOTERPANEL_ANIMATION_PERIOD_MS = 500;
    private static final String LOCAL_STORAGE_UPDATE_KEY = "private-tags-changed";
    private final TaggingPanelResources.TagPanelStyle style;
    private final CellList<TagDTO> tagCellList;
    private final SingleSelectionModel<TagDTO> tagSelectionModel;
    private final TagListProvider tagListProvider;
    private final List<TagButton> tagButtons;
    private final DockLayoutPanel taggingPanel;
    private final HeaderPanel filterbarAndContentPanel;
    private final TagFilterPanel filterbarPanel;
    private final Panel contentPanel;
    private final ScrollPanel footerPanel;
    private final TagFooterPanel tagFooterPanel;
    private final Button createTagsButton;
    private final StringMessages stringMessages;
    private final SailingServiceAsync sailingService;
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final UserService userService;
    private final Timer timer;
    private final RaceTimesInfoProvider raceTimesInfoProvider;
    private String leaderboardName = null;
    private RaceColumnDTO raceColumn = null;
    private FleetDTO fleet = null;
    private State currentState;
    private boolean tagHasNotBeenHighlightedYet = true;
    protected final TimePoint timePointToHighlight;
    protected final String tagToHighlight;
    private String id;
    private boolean preventTimeJumpAtSelectionChangeForOnce = false;
    private StrippedLeaderboardDTO leaderboardDTO;

    public TaggingComponent(Component<?> parent, ComponentContext<?> context, StringMessages stringMessages, SailingServiceAsync sailingService, UserService userService, Timer timer, RaceTimesInfoProvider raceTimesInfoProvider, TimePoint timePointToHighlight, String tagToHighlight, StrippedLeaderboardDTO leaderboardDTO, SailingServiceWriteAsync sailingServiceWrite) {
        super(parent, context);
        this.stringMessages = stringMessages;
        this.sailingService = sailingService;
        this.sailingServiceWrite = sailingServiceWrite;
        this.userService = userService;
        this.timer = timer;
        this.raceTimesInfoProvider = raceTimesInfoProvider;
        this.timePointToHighlight = timePointToHighlight;
        this.tagToHighlight = tagToHighlight;
        this.leaderboardDTO = leaderboardDTO;
        this.style = TaggingPanelResources.INSTANCE.style();
        this.style.ensureInjected();
        TaggingPanelResources.INSTANCE.cellListStyle().ensureInjected();
        TaggingPanelResources.INSTANCE.cellTableStyle().ensureInjected();
        this.tagCellList = new CellList((Cell)new TagCell(this, stringMessages, userService, false), (CellList.Resources)TaggingPanelResources.INSTANCE);
        this.tagSelectionModel = new SingleSelectionModel();
        this.tagListProvider = new TagListProvider();
        this.tagButtons = new ArrayList();
        this.taggingPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.filterbarAndContentPanel = new HeaderPanel();
        this.tagFooterPanel = new TagFooterPanel(this, sailingService, stringMessages, userService);
        this.footerPanel = new ScrollPanel((Widget)this.tagFooterPanel);
        this.filterbarPanel = new TagFilterPanel(this, stringMessages, userService);
        this.contentPanel = new FlowPanel();
        this.createTagsButton = new Button();
        userService.addUserStatusEventHandler((UserStatusEventHandler)this);
        raceTimesInfoProvider.addRaceTimesInfoProviderListener((RaceTimesInfoProviderListener)this);
        this.generateRandomId();
        this.registerStorageEventHandler();
        this.setCurrentState(State.VIEW);
        this.initializePanel();
    }

    private void initializePanel() {
        this.taggingPanel.setStyleName(this.style.taggingPanel());
        this.filterbarAndContentPanel.setHeaderWidget((Widget)this.filterbarPanel);
        this.filterbarAndContentPanel.setContentWidget((Widget)this.contentPanel);
        this.taggingPanel.addSouth((Widget)this.footerPanel, 0.0);
        this.contentPanel.addStyleName(this.style.tagCellListPanel());
        this.contentPanel.add((Widget)this.tagCellList);
        this.contentPanel.add((Widget)this.createTagsButton);
        this.tagListProvider.addDataDisplay((HasData)this.tagCellList);
        this.tagCellList.setEmptyListWidget((Widget)new Label(this.stringMessages.tagNoTagsFound()));
        this.tagCellList.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.DISABLED);
        this.tagCellList.setSelectionModel((SelectionModel)this.tagSelectionModel);
        this.tagCellList.addCellPreviewHandler((CellPreviewEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        this.createTagsButton.setTitle(this.stringMessages.tagAddTags());
        this.createTagsButton.setStyleName(this.style.toggleEditState());
        this.createTagsButton.addStyleName(this.style.imagePusTransparent());
        this.createTagsButton.addClickHandler(event -> this.setCurrentState(State.CREATE_TAG));
        this.taggingPanel.add((Widget)this.filterbarAndContentPanel);
        this.taggingPanel.forceLayout();
        this.updateContent();
    }

    private void registerStorageEventHandler() {
        Storage.addStorageEventHandler(event -> {
            if (LOCAL_STORAGE_UPDATE_KEY.equals(event.getKey()) && event.getNewValue() != null && !event.getNewValue().isEmpty() && !event.getNewValue().equals(this.id.toString())) {
                this.reloadPrivateTags();
            }
        });
    }

    private void firePrivateTagUpdateEvent(CrossDomainStorage storage) {
        storage.getItem(LOCAL_STORAGE_UPDATE_KEY, value -> {
            if (value.equals(this.id)) {
                this.generateRandomId();
            }
            storage.setItem(LOCAL_STORAGE_UPDATE_KEY, this.id, null);
        });
    }

    private void generateRandomId() {
        this.id = Long.toString(System.currentTimeMillis() * (long)Random.nextInt());
    }

    public void updateRace(String leaderboardName, RaceColumnDTO raceColumn, FleetDTO fleet) {
        if (leaderboardName != null && !leaderboardName.equals(this.leaderboardName)) {
            this.leaderboardName = leaderboardName;
        }
        if (fleet != null && !fleet.equals((Object)this.fleet)) {
            this.fleet = fleet;
        }
        if (raceColumn != null && !raceColumn.equals((Object)this.raceColumn)) {
            this.raceColumn = raceColumn;
        }
        this.reloadPrivateTags();
    }

    protected boolean isLoggedInAndRaceLogAvailable() {
        return this.userService.getCurrentUser() != null && this.leaderboardName != null && this.raceColumn != null && this.fleet != null;
    }

    protected void saveTag(String tag, String comment, String hiddenInfo, String imageURL, boolean visibleForPublic) {
        this.getResizedImageURLForImageURL(imageURL, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void getResizedImageURLForImageURL(String imageURL, AsyncCallback<String> callback) {
        if (imageURL == null || imageURL.isEmpty()) {
            callback.onSuccess((Object)"");
        } else {
            this.sailingService.resolveImageDimensions(imageURL, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void saveTag(String tag, String comment, String hiddenInfo, String imageURL, String resizedImageURL, boolean visibleForPublic, TimePoint raceTimePoint) {
        if (this.tagAlreadyExists(tag, comment, hiddenInfo, imageURL, resizedImageURL, visibleForPublic, raceTimePoint)) {
            Notification.notify((String)this.stringMessages.tagNotSavedReason(" " + this.stringMessages.tagAlreadyExists()), (Notification.NotificationType)Notification.NotificationType.WARNING);
        } else if (!this.isLoggedInAndRaceLogAvailable()) {
            Notification.notify((String)this.stringMessages.tagNotSaved(), (Notification.NotificationType)Notification.NotificationType.ERROR);
        } else if (tag.isEmpty()) {
            Notification.notify((String)this.stringMessages.tagNotSpecified(), (Notification.NotificationType)Notification.NotificationType.WARNING);
        } else {
            String saveComment = comment == null ? "" : comment;
            TimePoint saveRaceTimePoint = raceTimePoint == null ? new MillisecondsTimePoint(this.getTimerTime()) : raceTimePoint;
            this.sailingServiceWrite.addTag(this.leaderboardName, this.raceColumn.getName(), this.fleet.getName(), tag, saveComment, hiddenInfo, imageURL, resizedImageURL, visibleForPublic, saveRaceTimePoint, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void removeTag(TagDTO tag) {
        this.removeTag(tag, false);
    }

    protected void removeTag(TagDTO tag, boolean silent) {
        this.sailingServiceWrite.removeTag(this.leaderboardName, this.raceColumn.getName(), this.fleet.getName(), tag, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updateTag(TagDTO tagToUpdate, String tag, String comment, String hiddenInfo, String imageURL, boolean visibleForPublic) {
        this.getResizedImageURLForImageURL(imageURL, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void updateTag(TagDTO tagToUpdate, String tag, String comment, String hiddenInfo, String imageURL, boolean visibleForPublic, String resizedImageURL) {
        this.sailingServiceWrite.updateTag(this.leaderboardName, this.raceColumn.getName(), this.fleet.getName(), tagToUpdate, tag, comment, hiddenInfo, imageURL, resizedImageURL, visibleForPublic, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean tagAlreadyExists(String tag, String comment, String hiddenInfo, String imageURL, String resizedImageURL, boolean visibleForPublic, TimePoint raceTimePoint) {
        for (TagDTO tagDTO : this.tagListProvider.getAllTags()) {
            if (!tagDTO.equals(tag, comment, hiddenInfo, imageURL, resizedImageURL, visibleForPublic, this.userService.getCurrentUser().getName(), (TimePoint)new MillisecondsTimePoint(this.getTimerTime()))) continue;
            return true;
        }
        return false;
    }

    private void reloadPrivateTags() {
        this.tagListProvider.removePrivateTags();
        if (this.userService.getCurrentUser() != null) {
            this.sailingService.getPrivateTags(this.leaderboardName, this.raceColumn.getName(), this.fleet.getName(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void updateContent() {
        this.ensureFooterPanelVisibility();
        this.createTagsButton.setVisible(this.userService.getCurrentUser() != null && this.currentState.equals((Object)State.VIEW));
        if (this.currentState.equals((Object)State.EDIT_TAG)) {
            this.taggingPanel.addStyleName(this.style.taggingPanelDisabled());
            this.tagCellList.setSelectionModel((SelectionModel)new NoSelectionModel());
        } else {
            this.taggingPanel.removeStyleName(this.style.taggingPanelDisabled());
            this.tagCellList.setSelectionModel((SelectionModel)this.tagSelectionModel);
        }
        this.tagListProvider.updateFilteredTags();
        this.tagCellList.setVisibleRange(0, this.tagListProvider.getFilteredTags().size());
        this.tagListProvider.refresh();
    }

    protected void refreshContentPanel() {
        this.filterbarAndContentPanel.setContentWidget((Widget)this.contentPanel);
    }

    protected void addTagButton(TagButton tagButton) {
        tagButton.addClickHandler(event -> this.saveTag(tagButton.getTag(), tagButton.getComment(), null, tagButton.getImageURL(), tagButton.isVisibleForPublic()));
        this.tagButtons.add(tagButton);
    }

    protected Date getTimerTime() {
        return this.timer.getTime();
    }

    protected TagDTO getSelectedTag() {
        return (TagDTO)this.tagSelectionModel.getSelectedObject();
    }

    protected List<TagButton> getTagButtons() {
        return this.tagButtons;
    }

    protected TagListProvider getTagListProvider() {
        return this.tagListProvider;
    }

    protected void setCurrentState(State state) {
        this.currentState = state;
        this.updateContent();
    }

    protected State getCurrentState() {
        return this.currentState;
    }

    private void ensureFooterPanelVisibility() {
        if (this.currentState != null && (!this.currentState.equals((Object)State.VIEW) || this.currentState.equals((Object)State.VIEW) && !this.getTagButtons().isEmpty())) {
            if (this.taggingPanel.getWidgetIndex((Widget)this.footerPanel) != -1) {
                this.taggingPanel.setWidgetSize((Widget)this.footerPanel, 1.0);
                Scheduler.get().scheduleFinally((Scheduler.RepeatingCommand)new /* Unavailable Anonymous Inner Class!! */);
            }
            this.tagFooterPanel.setCurrentState(this.currentState);
        } else if (this.taggingPanel.getWidgetIndex((Widget)this.footerPanel) != -1) {
            this.taggingPanel.setWidgetSize((Widget)this.footerPanel, 0.0);
            this.taggingPanel.animate(500);
        }
    }

    private int calculateFooterPanelHeight() {
        int height = this.footerPanel.getWidget().getElement().getOffsetHeight();
        height = Math.min(height, this.taggingPanel.getOffsetHeight());
        return height;
    }

    protected boolean hasPermissionToModifyPublicTags() {
        boolean hasPermission = false;
        if (this.leaderboardName != null && this.userService.hasPermission((SecuredDTO)this.leaderboardDTO, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE)) {
            hasPermission = true;
        }
        return hasPermission;
    }

    protected void clearCache() {
        this.tagListProvider.clear();
        this.raceTimesInfoProvider.getRaceIdentifiers().forEach(raceIdentifier -> this.raceTimesInfoProvider.setLatestReceivedTagTime(raceIdentifier, null));
        this.reloadPrivateTags();
        this.filterbarPanel.loadTagFilterSets();
        this.tagFooterPanel.loadAllTagButtons();
    }

    public void raceTimesInfosReceived(Map<RegattaAndRaceIdentifier, RaceTimesInfoDTO> raceTimesInfo, long clientTimeWhenRequestWasSent, Date serverTimeDuringRequest, long clientTimeWhenResponseWasReceived) {
        if (raceTimesInfo != null) {
            raceTimesInfo.forEach((raceIdentifier, raceInfo) -> {
                boolean modifiedTags = false;
                boolean updatedLatestTag = false;
                TimePoint latestReceivedTagTime = this.raceTimesInfoProvider.getLatestReceivedTagTime(raceIdentifier);
                if (raceInfo.getTags() != null) {
                    for (TagDTO tag : raceInfo.getTags()) {
                        if (tag.getRevokedAt() != null) {
                            this.tagListProvider.remove(tag);
                            modifiedTags = true;
                            if (latestReceivedTagTime != null && (latestReceivedTagTime == null || !latestReceivedTagTime.before(tag.getRevokedAt()))) continue;
                            latestReceivedTagTime = tag.getRevokedAt();
                            updatedLatestTag = true;
                            continue;
                        }
                        if (this.tagListProvider.getAllTags().contains(tag)) continue;
                        this.tagListProvider.add(tag);
                        modifiedTags = true;
                        if (latestReceivedTagTime != null && (latestReceivedTagTime == null || !latestReceivedTagTime.before(tag.getCreatedAt()))) continue;
                        latestReceivedTagTime = tag.getCreatedAt();
                        updatedLatestTag = true;
                    }
                }
                if (updatedLatestTag) {
                    this.raceTimesInfoProvider.setLatestReceivedTagTime(raceIdentifier, latestReceivedTagTime);
                }
                if (modifiedTags) {
                    this.preventTimeJumpAtSelectionChangeForOnce = true;
                    this.updateContent();
                }
                if (this.tagHasNotBeenHighlightedYet && raceInfo.getTags() != null) {
                    this.tagHasNotBeenHighlightedYet = false;
                    if (this.timePointToHighlight != null) {
                        this.timer.setTime(this.timePointToHighlight.asMillis());
                        if (this.tagToHighlight != null) {
                            TagDTO matchingTag = null;
                            for (TagDTO tag : this.tagListProvider.getAllTags()) {
                                if (!tag.getRaceTimepoint().equals(this.timePointToHighlight) || !tag.getTag().equals(this.tagToHighlight)) continue;
                                matchingTag = tag;
                                break;
                            }
                            if (matchingTag != null) {
                                this.tagSelectionModel.clear();
                                this.tagSelectionModel.setSelected(matchingTag, true);
                            } else {
                                Notification.notify((String)this.stringMessages.tagNotFound(), (Notification.NotificationType)Notification.NotificationType.WARNING);
                            }
                        }
                    }
                }
            });
        }
    }

    public void onUserStatusChange(UserDTO user, boolean preAuthenticated) {
        this.clearCache();
        this.setCurrentState(State.VIEW);
    }

    public void timeChanged(Date newTime, Date oldTime) {
        if (oldTime != null) {
            TagDTO toHighlight = null;
            for (TagDTO tag : this.tagListProvider.getAllTags()) {
                if (tag.getRaceTimepoint().asDate().getTime() <= newTime.getTime()) {
                    toHighlight = tag;
                    continue;
                }
                if (tag.getRaceTimepoint().asDate().getTime() > newTime.getTime()) break;
            }
            this.tagSelectionModel.clear();
            if (toHighlight != null) {
                this.tagSelectionModel.setSelected(toHighlight, true);
            }
        }
    }

    public String getId() {
        return "TaggingComponent";
    }

    public String getLocalizedShortName() {
        return this.stringMessages.tagPanel();
    }

    public Widget getEntryWidget() {
        return this.taggingPanel;
    }

    public boolean isVisible() {
        return this.taggingPanel.isVisible();
    }

    public void setVisible(boolean visible) {
        if (this.raceTimesInfoProvider != null) {
            if (visible) {
                this.raceTimesInfoProvider.enableTagRequests();
                this.timer.addTimeListener((TimeListener)this);
            } else {
                this.raceTimesInfoProvider.disableTagRequests();
                this.timer.removeTimeListener((TimeListener)this);
            }
        }
        this.taggingPanel.setVisible(visible);
    }

    public String getDependentCssClassName() {
        return "tags";
    }

    static /* synthetic */ State access$0(TaggingComponent taggingComponent) {
        return taggingComponent.currentState;
    }

    static /* synthetic */ DockLayoutPanel access$1(TaggingComponent taggingComponent) {
        return taggingComponent.taggingPanel;
    }

    static /* synthetic */ ScrollPanel access$2(TaggingComponent taggingComponent) {
        return taggingComponent.footerPanel;
    }

    static /* synthetic */ int access$3(TaggingComponent taggingComponent) {
        return taggingComponent.calculateFooterPanelHeight();
    }

    static /* synthetic */ boolean access$4(TaggingComponent taggingComponent) {
        return taggingComponent.preventTimeJumpAtSelectionChangeForOnce;
    }

    static /* synthetic */ void access$5(TaggingComponent taggingComponent, boolean bl) {
        taggingComponent.preventTimeJumpAtSelectionChangeForOnce = bl;
    }

    static /* synthetic */ Timer access$6(TaggingComponent taggingComponent) {
        return taggingComponent.timer;
    }

    static /* synthetic */ SailingServiceWriteAsync access$7(TaggingComponent taggingComponent) {
        return taggingComponent.sailingServiceWrite;
    }

    static /* synthetic */ StringMessages access$8(TaggingComponent taggingComponent) {
        return taggingComponent.stringMessages;
    }

    static /* synthetic */ void access$9(TaggingComponent taggingComponent) {
        taggingComponent.reloadPrivateTags();
    }

    static /* synthetic */ UserService access$10(TaggingComponent taggingComponent) {
        return taggingComponent.userService;
    }

    static /* synthetic */ void access$11(TaggingComponent taggingComponent, CrossDomainStorage crossDomainStorage) {
        taggingComponent.firePrivateTagUpdateEvent(crossDomainStorage);
    }

    static /* synthetic */ TagListProvider access$12(TaggingComponent taggingComponent) {
        return taggingComponent.tagListProvider;
    }
}

