/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboardedit;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.dto.LeaderboardDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.gwt.ui.client.SailNumberCanonicalizerAndMatcher;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboardedit.EditableLeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboardedit.MatchAndApplyScoreCorrectionsDialog;
import com.sap.sailing.gwt.ui.shared.BulkScoreCorrectionDTO;
import com.sap.sailing.gwt.ui.shared.RegattaScoreCorrectionDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MatchAndApplyScoreCorrectionsDialog
extends DataEntryDialog<BulkScoreCorrectionDTO> {
    private final LeaderboardDTO leaderboard;
    private final Map<CompetitorDTO, String> defaultOfficialSailIDsForCompetitors;
    private final TreeSet<String> allOfficialSailIDs;
    private final Map<RaceColumnDTO, String> raceColumnToOfficialRaceNameOrNumber;
    private final RegattaScoreCorrectionDTO regattaScoreCorrection;
    private final Map<CompetitorDTO, CheckBox> competitorCheckboxes;
    private final Map<RaceColumnDTO, CheckBox> raceColumnCheckboxes;
    private final Map<Util.Pair<CompetitorDTO, RaceColumnDTO>, CheckBox> cellCheckboxes;
    private final Grid grid;
    private final Map<RaceColumnDTO, ListBox> raceNameOrNumberChoosers;
    private final Map<CompetitorDTO, ListBox> officialSailIDChoosers;
    private final CheckBox allAllCheckbox;

    public MatchAndApplyScoreCorrectionsDialog(EditableLeaderboardPanel leaderboardPanel, StringMessages stringMessages, SailingServiceWriteAsync sailingServiceWrite, ErrorReporter errorReporter, RegattaScoreCorrectionDTO result) {
        super(stringMessages.assignRaceNumbersToRaceColumns(), stringMessages.assignRaceNumbersToRaceColumns(), stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new Validator(null), (DataEntryDialog.DialogCallback)new Callback(leaderboardPanel, sailingServiceWrite, stringMessages, errorReporter));
        CheckBox checkbox;
        this.regattaScoreCorrection = result;
        this.leaderboard = leaderboardPanel.getLeaderboard();
        this.allOfficialSailIDs = new TreeSet();
        for (Map map : result.getScoreCorrectionsByRaceNameOrNumber().values()) {
            this.allOfficialSailIDs.addAll(map.keySet());
        }
        this.defaultOfficialSailIDsForCompetitors = new HashMap();
        for (Map.Entry entry : new SailNumberCanonicalizerAndMatcher().mapCompetitorsAndInitializeAllOfficialRaceIDs((Iterable)this.leaderboard.competitors, (Iterable)this.allOfficialSailIDs).entrySet()) {
            this.defaultOfficialSailIDsForCompetitors.put((CompetitorDTO)entry.getValue(), (String)entry.getKey());
        }
        this.raceColumnToOfficialRaceNameOrNumber = this.createRaceColumnNameToOfficialRaceNameOrNumberSuggestion(this.leaderboard, result);
        this.competitorCheckboxes = new HashMap();
        for (CompetitorDTO competitorDTO : this.leaderboard.competitors) {
            checkbox = this.createCheckbox(stringMessages.selectAll());
            checkbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.competitorCheckboxes.put(competitorDTO, checkbox);
        }
        this.raceColumnCheckboxes = new HashMap();
        for (RaceColumnDTO raceColumnDTO : this.leaderboard.getRaceList()) {
            checkbox = this.createCheckbox(stringMessages.selectAll());
            checkbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.raceColumnCheckboxes.put(raceColumnDTO, checkbox);
        }
        this.cellCheckboxes = new HashMap();
        for (CompetitorDTO competitorDTO : this.leaderboard.competitors) {
            for (RaceColumnDTO raceColumn : this.leaderboard.getRaceList()) {
                this.cellCheckboxes.put(new Util.Pair((Object)competitorDTO, (Object)raceColumn), this.createCheckbox(stringMessages.apply()));
            }
        }
        this.allAllCheckbox = this.createCheckbox(stringMessages.selectAll());
        this.allAllCheckbox.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.raceNameOrNumberChoosers = new HashMap();
        this.officialSailIDChoosers = new HashMap();
        this.grid = new Grid(this.leaderboard.competitors.size() + 1, this.leaderboard.getRaceList().size() + 1);
        this.fillRaceNameOrNumberChoosers();
        this.fillOfficialSailIDChoosers();
    }

    private void fillRaceNameOrNumberChoosers() {
        Set entries = this.regattaScoreCorrection.getScoreCorrectionsByRaceNameOrNumber().keySet();
        for (RaceColumnDTO raceColumn : this.leaderboard.getRaceList()) {
            ListBox listbox = this.createListBoxWithGridUpdateChangeHandler(entries, (String)this.raceColumnToOfficialRaceNameOrNumber.get(raceColumn));
            this.raceNameOrNumberChoosers.put(raceColumn, listbox);
        }
    }

    private ListBox createListBoxWithGridUpdateChangeHandler(Set<String> entries, String selectedItem) {
        ListBox result = this.createListBox(false);
        result.addItem("");
        int i = 1;
        int selectionIndex = -1;
        for (String entry : entries) {
            result.addItem(entry, entry);
            if (selectedItem != null && selectedItem.equals(entry)) {
                selectionIndex = i;
            }
            ++i;
        }
        if (selectionIndex != -1) {
            result.setSelectedIndex(selectionIndex);
        }
        result.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return result;
    }

    private void fillOfficialSailIDChoosers() {
        for (CompetitorDTO competitor : this.leaderboard.competitors) {
            ListBox listbox = this.createListBoxWithGridUpdateChangeHandler((Set)this.allOfficialSailIDs, (String)this.defaultOfficialSailIDsForCompetitors.get(competitor));
            this.officialSailIDChoosers.put(competitor, listbox);
        }
    }

    private Map<RaceColumnDTO, String> createRaceColumnNameToOfficialRaceNameOrNumberSuggestion(LeaderboardDTO leaderboard, RegattaScoreCorrectionDTO regattaScoreCorretion) {
        HashMap<RaceColumnDTO, String> result = new HashMap<RaceColumnDTO, String>();
        Iterator raceColumnIter = leaderboard.getRaceList().iterator();
        Iterator officialRaceNameOrNumberIter = regattaScoreCorretion.getScoreCorrectionsByRaceNameOrNumber().keySet().iterator();
        while (raceColumnIter.hasNext() && officialRaceNameOrNumberIter.hasNext()) {
            result.put((RaceColumnDTO)raceColumnIter.next(), (String)officialRaceNameOrNumberIter.next());
        }
        return result;
    }

    private String getCompetitorIdentifyingText(CompetitorDTO competitor) {
        String competitorIdentifyingText = competitor.hasBoat() ? ((CompetitorWithBoatDTO)competitor).getSailID() : competitor.getShortName();
        return competitorIdentifyingText;
    }

    protected BulkScoreCorrectionDTO getResult() {
        BulkScoreCorrectionDTO result = new BulkScoreCorrectionDTO(this.leaderboard.getName());
        for (CompetitorDTO competitor : this.leaderboard.competitors) {
            for (RaceColumnDTO raceColumn : this.leaderboard.getRaceList()) {
                RegattaScoreCorrectionDTO.ScoreCorrectionEntryDTO officialCorrectionEntry;
                Util.Pair key = new Util.Pair((Object)competitor, (Object)raceColumn);
                CheckBox cellCheckbox = (CheckBox)this.cellCheckboxes.get(key);
                if (!cellCheckbox.getValue().booleanValue()) continue;
                String raceNameOrNumber = this.getSelectedString(this.raceNameOrNumberChoosers, (Object)raceColumn);
                String officialSailID = this.getSelectedString(this.officialSailIDChoosers, (Object)competitor);
                if (officialSailID == null || raceNameOrNumber == null || (officialCorrectionEntry = (RegattaScoreCorrectionDTO.ScoreCorrectionEntryDTO)((Map)this.regattaScoreCorrection.getScoreCorrectionsByRaceNameOrNumber().get(raceNameOrNumber)).get(officialSailID)) == null) continue;
                result.addMaxPointsReasonUpdate(competitor, raceColumn, officialCorrectionEntry.getMaxPointsReason());
                if (officialCorrectionEntry.getScore() == null) continue;
                double officialTotalPointsWithFactorApplied = officialCorrectionEntry.getScore();
                double officialTotalPoints = ScoringSchemeType.getUnscaledScore((double)raceColumn.getEffectiveFactor(), (double)officialTotalPointsWithFactorApplied, (boolean)raceColumn.isOneAlwaysStaysOne());
                result.addScoreUpdate(competitor, raceColumn, officialTotalPoints);
            }
        }
        return result;
    }

    protected Widget getAdditionalWidget() {
        this.updateGridContents(this.grid);
        return this.grid;
    }

    private void updateGridContents(Grid grid) {
        grid.clear();
        grid.setWidget(0, 0, (Widget)this.allAllCheckbox);
        int c = 1;
        for (RaceColumnDTO raceColumn : this.leaderboard.getRaceList()) {
            VerticalPanel vp = new VerticalPanel();
            vp.add((Widget)new Label(raceColumn.getName()));
            vp.add((Widget)this.raceNameOrNumberChoosers.get(raceColumn));
            vp.add((Widget)this.raceColumnCheckboxes.get(raceColumn));
            grid.setWidget(0, c, (Widget)vp);
            ++c;
        }
        int row = 1;
        for (CompetitorDTO competitor : this.leaderboard.competitors) {
            String officialSailID = this.getSelectedString(this.officialSailIDChoosers, (Object)competitor);
            int column = 0;
            VerticalPanel vp = new VerticalPanel();
            vp.add((Widget)new Label(String.valueOf(this.getCompetitorIdentifyingText(competitor)) + " " + competitor.getName()));
            vp.add((Widget)this.officialSailIDChoosers.get(competitor));
            vp.add((Widget)this.competitorCheckboxes.get(competitor));
            grid.setWidget(row, column++, (Widget)vp);
            LeaderboardRowDTO leaderboardRow = (LeaderboardRowDTO)this.leaderboard.rows.get(competitor);
            for (RaceColumnDTO raceColumn : this.leaderboard.getRaceList()) {
                LeaderboardEntryDTO entry = (LeaderboardEntryDTO)leaderboardRow.fieldsByRaceColumnName.get(raceColumn.getName());
                String raceNameOrNumber = this.getSelectedString(this.raceNameOrNumberChoosers, (Object)raceColumn);
                VerticalPanel cell = new VerticalPanel();
                cell.add((Widget)new Label(entry.totalPoints + "/" + entry.netPoints + "/" + entry.reasonForMaxPoints + (entry.discarded ? "/discarded" : "")));
                if (officialSailID != null && raceNameOrNumber != null) {
                    boolean entriesDiffer;
                    Double officialTotalPointsWithFactorApplied;
                    RegattaScoreCorrectionDTO.ScoreCorrectionEntryDTO officialCorrectionEntry = (RegattaScoreCorrectionDTO.ScoreCorrectionEntryDTO)((Map)this.regattaScoreCorrection.getScoreCorrectionsByRaceNameOrNumber().get(raceNameOrNumber)).get(officialSailID);
                    Double d = officialCorrectionEntry == null ? null : (officialTotalPointsWithFactorApplied = officialCorrectionEntry.isDiscarded() != false ? Double.valueOf(0.0) : officialCorrectionEntry.getScore());
                    Double officialTotalPoints = officialCorrectionEntry == null ? null : (officialCorrectionEntry.getScore() == null ? null : Double.valueOf(ScoringSchemeType.getUnscaledScore((double)raceColumn.getEffectiveFactor(), (double)officialCorrectionEntry.getScore(), (boolean)raceColumn.isOneAlwaysStaysOne())));
                    MaxPointsReason officialMaxPointsReason = officialCorrectionEntry == null ? null : officialCorrectionEntry.getMaxPointsReason();
                    SafeHtmlBuilder sb = new SafeHtmlBuilder();
                    boolean bl = entriesDiffer = officialCorrectionEntry != null && (officialTotalPoints == null && entry.totalPoints != null || officialTotalPoints != null && (entry.totalPoints == null || !Double.valueOf(entry.netPoints).equals(officialTotalPointsWithFactorApplied)) || officialTotalPointsWithFactorApplied == null && entry.netPoints != null || officialTotalPointsWithFactorApplied != null && (entry.netPoints == null || !Double.valueOf(entry.netPoints).equals(officialTotalPointsWithFactorApplied)) || officialMaxPointsReason == null && entry.reasonForMaxPoints != MaxPointsReason.NONE || officialMaxPointsReason != null && officialMaxPointsReason != entry.reasonForMaxPoints);
                    if (entriesDiffer) {
                        sb.appendHtmlConstant("<span style=\"color: #0000FF;\"><b>");
                    }
                    if (officialTotalPoints == null) {
                        sb.appendEscaped("null");
                    } else {
                        sb.append(officialTotalPoints.doubleValue());
                    }
                    sb.appendEscaped("/");
                    if (officialTotalPointsWithFactorApplied == null) {
                        sb.appendEscaped("null");
                    } else {
                        sb.append(officialTotalPointsWithFactorApplied.doubleValue());
                    }
                    sb.appendEscaped("/");
                    if (officialMaxPointsReason != null) {
                        sb.appendEscaped(officialMaxPointsReason.name());
                    } else {
                        sb.appendEscaped(MaxPointsReason.NONE.name());
                    }
                    if (officialCorrectionEntry != null && officialCorrectionEntry.isDiscarded().booleanValue()) {
                        sb.appendEscaped("/discarded");
                    }
                    if (entriesDiffer) {
                        sb.appendHtmlConstant("</b></span>");
                    }
                    cell.add((Widget)new HTML(sb.toSafeHtml()));
                }
                cell.add((Widget)this.cellCheckboxes.get(new Util.Pair((Object)competitor, (Object)raceColumn)));
                grid.setWidget(row, column++, (Widget)cell);
            }
            ++row;
        }
    }

    private <T> String getSelectedString(Map<T, ListBox> choosersByT, T t) {
        ListBox chooser = choosersByT.get(t);
        return Util.hasLength((String)chooser.getSelectedValue()) ? chooser.getSelectedValue() : null;
    }

    static /* synthetic */ LeaderboardDTO access$1(MatchAndApplyScoreCorrectionsDialog matchAndApplyScoreCorrectionsDialog) {
        return matchAndApplyScoreCorrectionsDialog.leaderboard;
    }

    static /* synthetic */ Map access$2(MatchAndApplyScoreCorrectionsDialog matchAndApplyScoreCorrectionsDialog) {
        return matchAndApplyScoreCorrectionsDialog.cellCheckboxes;
    }

    static /* synthetic */ Map access$3(MatchAndApplyScoreCorrectionsDialog matchAndApplyScoreCorrectionsDialog) {
        return matchAndApplyScoreCorrectionsDialog.competitorCheckboxes;
    }

    static /* synthetic */ Map access$4(MatchAndApplyScoreCorrectionsDialog matchAndApplyScoreCorrectionsDialog) {
        return matchAndApplyScoreCorrectionsDialog.raceColumnCheckboxes;
    }

    static /* synthetic */ Grid access$5(MatchAndApplyScoreCorrectionsDialog matchAndApplyScoreCorrectionsDialog) {
        return matchAndApplyScoreCorrectionsDialog.grid;
    }

    static /* synthetic */ void access$6(MatchAndApplyScoreCorrectionsDialog matchAndApplyScoreCorrectionsDialog, Grid grid) {
        matchAndApplyScoreCorrectionsDialog.updateGridContents(grid);
    }
}

