/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sailing.domain.common.dto.LeaderboardRowDTO;
import com.sap.sailing.domain.common.dto.LegEntryDTO;
import com.sap.sailing.gwt.ui.client.DetailTypeFormatter;
import com.sap.sailing.gwt.ui.client.DurationAsHoursMinutesSecondsFormatter;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.DetailTypeColumn;
import com.sap.sailing.gwt.ui.leaderboard.ExpandableSortableColumn;
import com.sap.sailing.gwt.ui.leaderboard.HasStringAndDoubleValue;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.MinMaxRenderer;
import com.sap.sailing.gwt.ui.leaderboard.RaceNameProvider;
import com.sap.sailing.gwt.ui.leaderboard.SortableExpandableColumnHeader;
import com.sap.sailing.gwt.ui.leaderboard.TimeTraveledRaceColumnInSeconds;
import com.sap.sailing.gwt.ui.leaderboard.TotalTimeColumn;
import com.sap.sse.common.InvertibleComparator;
import com.sap.sse.gwt.client.celltable.AbstractSortableColumnWithMinMax;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class TimeTraveledRaceColumnInSeconds
extends ExpandableSortableColumn<String>
implements HasStringAndDoubleValue<LeaderboardRowDTO> {
    private static final DetailType DETAIL_TYPE = DetailType.RACE_TIME_TRAVELED;
    private RaceNameProvider raceNameProvider;
    private StringMessages stringMessages;
    private String columnStyle;
    private String headerStyle;
    private MinMaxRenderer<LeaderboardRowDTO> minmaxRenderer;

    public TimeTraveledRaceColumnInSeconds(LeaderboardPanel<?> leaderboardPanel, RaceNameProvider raceNameProvider, StringMessages stringMessages, String headerStyle, String columnStyle, String detailHeaderStyle, String detailColumnStyle) {
        super(leaderboardPanel, true, (Cell)new TextCell(), DETAIL_TYPE.getDefaultSortingOrder(), stringMessages, detailHeaderStyle, detailColumnStyle, Arrays.asList(DetailType.RACE_TIME_TRAVELED_UPWIND, DetailType.RACE_TIME_TRAVELED_DOWNWIND, DetailType.RACE_TIME_TRAVELED_REACHING), leaderboardPanel);
        this.setHorizontalAlignment(ALIGN_CENTER);
        this.raceNameProvider = raceNameProvider;
        this.stringMessages = stringMessages;
        this.columnStyle = columnStyle;
        this.headerStyle = headerStyle;
        this.minmaxRenderer = new MinMaxRenderer((HasStringAndDoubleValue)this, (Comparator)this.getComparator());
    }

    public Double getDoubleValue(LeaderboardRowDTO row) {
        LeaderboardEntryDTO fieldsForRace = (LeaderboardEntryDTO)row.fieldsByRaceColumnName.get(this.getRaceColumnName());
        Double result = fieldsForRace != null && fieldsForRace.timeSailedSinceRaceStart != null ? Double.valueOf(fieldsForRace.timeSailedSinceRaceStart.asSeconds()) : null;
        return result;
    }

    private Double getTimeTraveledForLegTypeInSeconds(LeaderboardRowDTO row, LegType legType) {
        Long result = null;
        LeaderboardEntryDTO fieldsForRace = (LeaderboardEntryDTO)row.fieldsByRaceColumnName.get(this.getRaceColumnName());
        if (fieldsForRace != null && fieldsForRace.legDetails != null) {
            for (LegEntryDTO legDetail : fieldsForRace.legDetails) {
                if (legDetail == null || legDetail.legType != legType || legDetail.timeInMilliseconds == null) continue;
                if (result == null) {
                    result = 0L;
                }
                result = result + legDetail.timeInMilliseconds;
            }
        }
        return result == null ? null : Double.valueOf(Long.valueOf(result / 1000L).doubleValue());
    }

    protected Map<DetailType, AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>> getDetailColumnMap(LeaderboardPanel<?> leaderboardPanel, StringMessages stringConstants, String detailHeaderStyle, String detailColumnStyle) {
        HashMap result = new HashMap();
        result.put(DetailType.RACE_TIME_TRAVELED_UPWIND, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new TotalTimeColumn(DetailType.RACE_TIME_TRAVELED_UPWIND, (DetailTypeColumn.DataExtractor)new RaceTimeTraveledUpwindInSeconds(this, null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.RACE_TIME_TRAVELED_DOWNWIND, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new TotalTimeColumn(DetailType.RACE_TIME_TRAVELED_DOWNWIND, (DetailTypeColumn.DataExtractor)new RaceTimeTraveledDownwindInSeconds(this, null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        result.put(DetailType.RACE_TIME_TRAVELED_REACHING, (AbstractSortableColumnWithMinMax<LeaderboardRowDTO, ?>)new TotalTimeColumn(DetailType.RACE_TIME_TRAVELED_REACHING, (DetailTypeColumn.DataExtractor)new RaceTimeTraveledReachingInSeconds(this, null), detailHeaderStyle, detailColumnStyle, leaderboardPanel));
        return result;
    }

    private String getRaceColumnName() {
        return this.raceNameProvider.getRaceColumnName();
    }

    public String getValue(LeaderboardRowDTO object) {
        Double durationInSeconds = this.getDoubleValue(object);
        return new DurationAsHoursMinutesSecondsFormatter().getHoursMinutesSeconds(durationInSeconds);
    }

    public SortableExpandableColumnHeader getHeader() {
        SortableExpandableColumnHeader result = new SortableExpandableColumnHeader(DetailTypeFormatter.format((DetailType)DETAIL_TYPE), DetailTypeFormatter.getTooltip((DetailType)DETAIL_TYPE), DetailTypeFormatter.getUnit((DetailType)DETAIL_TYPE), null, this.getLeaderboardPanel(), (ExpandableSortableColumn)this, this.stringMessages);
        return result;
    }

    public InvertibleComparator<LeaderboardRowDTO> getComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String getStringValueToRender(LeaderboardRowDTO row) {
        String result = this.getValue(row);
        if (result == null || !result.equals("")) {
            return result;
        }
        return null;
    }

    public void render(Cell.Context context, LeaderboardRowDTO row, SafeHtmlBuilder sb) {
        this.minmaxRenderer.render(context, (Object)row, this.getTitle(row), sb);
    }

    public void updateMinMax() {
        this.minmaxRenderer.updateMinMax(this.getDisplayedLeaderboardRowsProvider().getRowsToDisplay().values());
    }

    protected String getTitle(LeaderboardRowDTO row) {
        return null;
    }

    public String getColumnStyle() {
        return this.columnStyle;
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    static /* synthetic */ Double access$5(TimeTraveledRaceColumnInSeconds timeTraveledRaceColumnInSeconds, LeaderboardRowDTO leaderboardRowDTO, LegType legType) {
        return timeTraveledRaceColumnInSeconds.getTimeTraveledForLegTypeInSeconds(leaderboardRowDTO, legType);
    }
}

