/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.Header;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.ui.client.DetailTypeFormatter;
import com.sap.sailing.gwt.ui.leaderboard.DetailTypeColumn;
import com.sap.sailing.gwt.ui.leaderboard.DisplayedLeaderboardRowsProvider;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardSortableColumnWithMinMax;
import com.sap.sailing.gwt.ui.leaderboard.SafeHtmlHeaderWithTooltip;
import com.sap.sse.common.InvertibleComparator;

public abstract class DetailTypeColumn<FieldType extends Comparable<?>, RenderingType, T>
extends LeaderboardSortableColumnWithMinMax<T, RenderingType> {
    private static final String HtmlConstantToInlineHeadersWithAndWithoutUnit = "&nbsp;";
    private final String title;
    private final DataExtractor<FieldType, T> field;
    private final String headerStyle;
    private final String columnStyle;
    private final String unit;
    private final String tooltip;

    protected DetailTypeColumn(DetailType detailType, DataExtractor<FieldType, T> field, Cell<RenderingType> cell, String headerStyle, String columnStyle, DisplayedLeaderboardRowsProvider displayedLeaderboardRowsProvider) {
        super(cell, detailType.getDefaultSortingOrder(), displayedLeaderboardRowsProvider);
        this.setHorizontalAlignment(ALIGN_CENTER);
        this.title = DetailTypeFormatter.format((DetailType)detailType);
        this.unit = DetailTypeFormatter.getUnit((DetailType)detailType).isEmpty() ? "" : "[" + DetailTypeFormatter.getUnit((DetailType)detailType) + "]";
        this.tooltip = DetailTypeFormatter.getTooltip((DetailType)detailType);
        this.field = field;
        this.headerStyle = headerStyle;
        this.columnStyle = columnStyle;
    }

    protected String getTitle() {
        return this.title;
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    protected DataExtractor<FieldType, T> getField() {
        return this.field;
    }

    public String getColumnStyle() {
        return this.columnStyle;
    }

    public InvertibleComparator<T> getComparator() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Header<?> getHeader() {
        SafeHtmlBuilder titleBuilder = new SafeHtmlBuilder().appendEscaped(this.title).appendHtmlConstant("<br>");
        if (this.unit == null || this.unit.isEmpty()) {
            titleBuilder.appendHtmlConstant(HtmlConstantToInlineHeadersWithAndWithoutUnit);
        } else {
            titleBuilder.appendEscaped(this.unit);
        }
        return new SafeHtmlHeaderWithTooltip(titleBuilder.toSafeHtml(), this.tooltip);
    }

    protected FieldType getFieldValue(T row) {
        return (FieldType)this.getField().get(row);
    }
}

