/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.datamining;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.http.client.UrlBuilder;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.common.authentication.FixedSailingAuthentication;
import com.sap.sailing.gwt.common.authentication.SAPSailingHeaderWithAuthentication;
import com.sap.sailing.gwt.ui.client.AbstractSailingReadEntryPoint;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.datamining.DataMiningResources;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.Util;
import com.sap.sse.datamining.shared.DataMiningSession;
import com.sap.sse.datamining.shared.dto.StoredDataMiningReportDTO;
import com.sap.sse.datamining.shared.impl.UUIDDataMiningSession;
import com.sap.sse.datamining.ui.client.CompositeResultsPresenter;
import com.sap.sse.datamining.ui.client.DataMiningService;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.DataMiningWriteService;
import com.sap.sse.datamining.ui.client.DataMiningWriteServiceAsync;
import com.sap.sse.datamining.ui.client.ReportProvider;
import com.sap.sse.datamining.ui.client.selection.QueryDefinitionProviderWithControls;
import com.sap.sse.gwt.client.EntryPointHelper;
import com.sap.sse.gwt.client.ServerInfoDTO;
import com.sap.sse.gwt.client.shared.components.ComponentResources;
import com.sap.sse.gwt.resources.Highcharts;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.security.ui.authentication.decorator.WidgetFactory;
import com.sap.sse.security.ui.authentication.generic.GenericAuthentication;
import com.sap.sse.security.ui.authentication.generic.GenericAuthorizedContentDecorator;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import java.util.UUID;
import java.util.logging.Logger;

public class DataMiningEntryPoint
extends AbstractSailingReadEntryPoint
implements ReportProvider {
    public static final ComponentResources resources = (ComponentResources)GWT.create(ComponentResources.class);
    private static final Logger LOG = Logger.getLogger(DataMiningEntryPoint.class.getName());
    private static final DataMiningResources dataMiningResources = (DataMiningResources)GWT.create(DataMiningResources.class);
    private final DataMiningServiceAsync dataMiningService = (DataMiningServiceAsync)GWT.create(DataMiningService.class);
    private final DataMiningWriteServiceAsync dataMiningWriteService = (DataMiningWriteServiceAsync)GWT.create(DataMiningWriteService.class);
    private DataMiningSession session;
    private QueryDefinitionProviderWithControls queryDefinitionProvider;
    private CompositeResultsPresenter<?> resultsPresenter;
    private StoredDataMiningReportDTO currentReport;
    private Integer resultsPresenterSouthHeight = 350;
    private Integer resultsPresenterEastWidth = 750;
    private Panel mainPanel;
    private SplitLayoutPanel queryAndResultSplitPanel;
    private boolean queryAndResultAreVertical = true;

    protected void doOnModuleLoad() {
        Highcharts.ensureInjectedWithMore();
        super.doOnModuleLoad();
        this.session = new UUIDDataMiningSession(UUID.randomUUID());
        EntryPointHelper.registerASyncService((ServiceDefTarget)((ServiceDefTarget)this.dataMiningService), (String)"service/datamining", (Util.Pair[])new Util.Pair[]{HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA});
        EntryPointHelper.registerASyncService((ServiceDefTarget)((ServiceDefTarget)this.dataMiningWriteService), (String)"service/datamining", (Util.Pair[])new Util.Pair[]{HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER});
        this.getUserService().executeWithServerInfo(s -> this.createDataminingPanel(s, Window.Location.getParameter((String)"q")));
    }

    private void createDataminingPanel(ServerInfoDTO serverInfo, String queryIdentifier) {
        this.removeUrlParameter();
        SAPSailingHeaderWithAuthentication header = new SAPSailingHeaderWithAuthentication(((StringMessages)this.getStringMessages()).dataMining());
        PaywallResolverImpl paywallResolver = new PaywallResolverImpl(this.getUserService(), this.getSubscriptionServiceFactory());
        FixedSailingAuthentication genericSailingAuthentication = new FixedSailingAuthentication(this.getUserService(), (PaywallResolver)paywallResolver, header.getAuthenticationMenuView());
        GenericAuthorizedContentDecorator authorizedContentDecorator = new GenericAuthorizedContentDecorator((GenericAuthentication)genericSailingAuthentication);
        authorizedContentDecorator.setPermissionToCheck((SecuredDTO)serverInfo, (HasPermissions.Action)SecuredSecurityTypes.ServerActions.DATA_MINING);
        authorizedContentDecorator.setContentWidgetFactory((WidgetFactory)new /* Unavailable Anonymous Inner Class!! */);
        RootLayoutPanel rootPanel = RootLayoutPanel.get();
        DockLayoutPanel panel = new DockLayoutPanel(Style.Unit.PX);
        panel.addNorth((Widget)header, 75.0);
        panel.add((Widget)authorizedContentDecorator);
        panel.ensureDebugId("DataMiningPanel");
        rootPanel.add((Widget)panel);
    }

    public StoredDataMiningReportDTO getCurrentReport() {
        return this.currentReport;
    }

    public void setCurrentReport(StoredDataMiningReportDTO report) {
        this.currentReport = report;
    }

    public void setQueryAndResultOrientation() {
        this.setQueryAndResultOrientation(!this.queryAndResultAreVertical);
    }

    public void setQueryAndResultOrientation(boolean vertical) {
        if (vertical != this.queryAndResultAreVertical) {
            Double size = this.queryAndResultSplitPanel.getWidgetSize(this.resultsPresenter.getEntryWidget());
            if (size != null) {
                if (this.queryAndResultAreVertical) {
                    this.resultsPresenterSouthHeight = size.intValue();
                } else {
                    this.resultsPresenterEastWidth = size.intValue();
                }
            }
            this.queryAndResultAreVertical = vertical;
            this.queryAndResultSplitPanel.remove(this.resultsPresenter.getEntryWidget());
            this.queryAndResultSplitPanel.remove(this.queryDefinitionProvider.getEntryWidget());
            this.addDefinitionProviderAndResultPresenter();
        }
    }

    private void addDefinitionProviderAndResultPresenter() {
        if (this.queryAndResultAreVertical) {
            this.queryAndResultSplitPanel.addSouth(this.resultsPresenter.getEntryWidget(), (double)this.resultsPresenterSouthHeight.intValue());
        } else {
            this.queryAndResultSplitPanel.addEast(this.resultsPresenter.getEntryWidget(), (double)this.resultsPresenterEastWidth.intValue());
        }
        this.queryAndResultSplitPanel.add(this.queryDefinitionProvider.getEntryWidget());
    }

    private void removeUrlParameter() {
        try {
            UrlBuilder builder = Window.Location.createUrlBuilder().setHost(Window.Location.getHost()).setPath(Window.Location.getPath()).setProtocol(Window.Location.getProtocol());
            String port = Window.Location.getPort();
            if (port != null && !"".equals(port.trim()) && !"0".equals(port)) {
                builder.setPort(Integer.parseInt(port));
            }
            String newUrl = builder.buildString();
            newUrl = newUrl.replaceAll("\\?.*$", "");
            this.updateUrl(Window.getTitle(), newUrl);
        }
        catch (Exception e) {
            LOG.severe("Could not update URL: " + e.getMessage());
        }
    }

    private native void updateUrl(String var1, String var2);

    static /* synthetic */ com.sap.sse.gwt.client.StringMessages access$0(DataMiningEntryPoint dataMiningEntryPoint) {
        return dataMiningEntryPoint.getStringMessages();
    }

    static /* synthetic */ void access$1(DataMiningEntryPoint dataMiningEntryPoint, StoredDataMiningReportDTO storedDataMiningReportDTO) {
        dataMiningEntryPoint.currentReport = storedDataMiningReportDTO;
    }

    static /* synthetic */ void access$2(DataMiningEntryPoint dataMiningEntryPoint, Panel panel) {
        dataMiningEntryPoint.mainPanel = panel;
    }

    static /* synthetic */ QueryDefinitionProviderWithControls access$3(DataMiningEntryPoint dataMiningEntryPoint) {
        return dataMiningEntryPoint.queryDefinitionProvider;
    }

    static /* synthetic */ void access$4(DataMiningEntryPoint dataMiningEntryPoint, CompositeResultsPresenter compositeResultsPresenter) {
        dataMiningEntryPoint.resultsPresenter = compositeResultsPresenter;
    }

    static /* synthetic */ CompositeResultsPresenter access$5(DataMiningEntryPoint dataMiningEntryPoint) {
        return dataMiningEntryPoint.resultsPresenter;
    }

    static /* synthetic */ StoredDataMiningReportDTO access$6(DataMiningEntryPoint dataMiningEntryPoint) {
        return dataMiningEntryPoint.currentReport;
    }

    static /* synthetic */ DataMiningSession access$7(DataMiningEntryPoint dataMiningEntryPoint) {
        return dataMiningEntryPoint.session;
    }

    static /* synthetic */ DataMiningServiceAsync access$8(DataMiningEntryPoint dataMiningEntryPoint) {
        return dataMiningEntryPoint.dataMiningService;
    }

    static /* synthetic */ void access$9(DataMiningEntryPoint dataMiningEntryPoint, QueryDefinitionProviderWithControls queryDefinitionProviderWithControls) {
        dataMiningEntryPoint.queryDefinitionProvider = queryDefinitionProviderWithControls;
    }

    static /* synthetic */ DataMiningWriteServiceAsync access$10(DataMiningEntryPoint dataMiningEntryPoint) {
        return dataMiningEntryPoint.dataMiningWriteService;
    }

    static /* synthetic */ Panel access$11(DataMiningEntryPoint dataMiningEntryPoint) {
        return dataMiningEntryPoint.mainPanel;
    }

    static /* synthetic */ DataMiningResources access$12() {
        return dataMiningResources;
    }

    static /* synthetic */ void access$13(DataMiningEntryPoint dataMiningEntryPoint, SplitLayoutPanel splitLayoutPanel) {
        dataMiningEntryPoint.queryAndResultSplitPanel = splitLayoutPanel;
    }

    static /* synthetic */ SplitLayoutPanel access$14(DataMiningEntryPoint dataMiningEntryPoint) {
        return dataMiningEntryPoint.queryAndResultSplitPanel;
    }

    static /* synthetic */ void access$15(DataMiningEntryPoint dataMiningEntryPoint) {
        dataMiningEntryPoint.addDefinitionProviderAndResultPresenter();
    }

    static /* synthetic */ Logger access$16() {
        return LOG;
    }
}

