/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap.windladder;

import com.google.gwt.canvas.client.Canvas;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.FillStrokeStyle;
import com.google.gwt.core.client.GWT;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.overlays.overlayhandlers.OverlayViewOnAddHandler;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.client.shared.racemap.windladder.ImageTileGenerator;
import com.sap.sailing.gwt.ui.client.shared.racemap.windladder.WindLadder;
import com.sap.sailing.gwt.ui.client.shared.racemap.windladder.WindLadderResources;
import com.sap.sailing.gwt.ui.simulator.racemap.FullCanvasOverlay;

public class WindLadderOverlay
extends FullCanvasOverlay {
    protected static final WindLadderResources RESOURCES = (WindLadderResources)GWT.create(WindLadderResources.class);
    protected static final double TEXTURE_ALPHA = 0.4;
    protected static final double CANVAS_RESERVE = 0.5;
    protected WindLadder windLadder;
    protected ImageTileGenerator tileGen = new ImageTileGenerator(RESOURCES.windLadderTexture());
    protected Double windBearing;
    protected Position fixPosition;
    protected Double drawnPatternSize;
    protected double previousFixPointWindwardDistance;
    protected double previousOnAxisOffset;
    protected boolean redraw = true;
    protected int transitionDisableCountdown;

    public WindLadderOverlay(WindLadder windLadder, MapWidget map, int zIndex, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.map.addZoomChangeHandler(event -> this.onZoomChange());
        this.windLadder = windLadder;
    }

    public boolean update(Double windBearing, Position fixPosition, long timeForPositionTransitionMillis) {
        return this.update(windBearing, fixPosition, timeForPositionTransitionMillis, false);
    }

    public boolean update(Double windBearing, Position fixPosition, long timeForPositionTransitionMillis, boolean redraw) {
        boolean canAnimate = true;
        if (windBearing != null) {
            this.windBearing = windBearing;
        }
        if (fixPosition != null) {
            this.fixPosition = fixPosition;
        }
        if (this.mapProjection != null && this.windBearing != null && this.fixPosition != null && this.tileGen.getReady()) {
            double onAxisOffset;
            this.updateDrawingAngleAndSetCanvasRotation(Math.toDegrees(this.windBearing));
            Point fixPointInMap = this.mapProjection.fromLatLngToDivPixel(this.coordinateSystem.toLatLng(this.fixPosition));
            Point windUnitVector = Point.newInstance((double)(-Math.sin(-this.windBearing.doubleValue())), (double)(-Math.cos(-this.windBearing.doubleValue())));
            double fixPointWindwardDistance = fixPointInMap.getX() * windUnitVector.getX() + fixPointInMap.getY() * windUnitVector.getY();
            double fixPointWindwardDistanceChange = fixPointWindwardDistance - this.previousFixPointWindwardDistance;
            this.previousFixPointWindwardDistance = fixPointWindwardDistance;
            if (redraw) {
                onAxisOffset = fixPointWindwardDistance % this.drawnPatternSize;
                onAxisOffset = onAxisOffset < 0.0 ? onAxisOffset + this.drawnPatternSize : onAxisOffset;
                onAxisOffset = onAxisOffset > this.drawnPatternSize / 2.0 ? onAxisOffset - this.drawnPatternSize : onAxisOffset;
            } else {
                onAxisOffset = this.previousOnAxisOffset + fixPointWindwardDistanceChange;
            }
            this.previousOnAxisOffset = onAxisOffset;
            Point offsetVector = Point.newInstance((double)(onAxisOffset * windUnitVector.getX()), (double)(onAxisOffset * windUnitVector.getY()));
            canAnimate = this.isInBounds(this.windBearing.doubleValue(), offsetVector);
            this.setCanvasPosition(this.getWidgetPosLeft() + offsetVector.getX(), this.getWidgetPosTop() + offsetVector.getY());
            if (this.transitionDisableCountdown > 0) {
                --this.transitionDisableCountdown;
            } else {
                this.updateTransition(timeForPositionTransitionMillis);
            }
            if (redraw) {
                this.redraw();
            }
            this.draw();
        }
        return canAnimate;
    }

    protected boolean isInBounds(double rotation, Point translation) {
        double outerHalfWidth = (double)this.getCanvas().getElement().getClientWidth() / 2.0;
        double outerHalfHeight = (double)this.getCanvas().getElement().getClientHeight() / 2.0;
        double innerHalfWidth = (double)this.getMapWidth() / 2.0;
        double innerHalfHeight = (double)this.getMapHeight() / 2.0;
        Point[] innerCorners = new Point[]{Point.newInstance((double)(-innerHalfWidth), (double)(-innerHalfHeight)), Point.newInstance((double)innerHalfWidth, (double)(-innerHalfHeight)), Point.newInstance((double)(-innerHalfWidth), (double)innerHalfHeight), Point.newInstance((double)innerHalfWidth, (double)innerHalfHeight)};
        double s = Math.sin(rotation);
        double c = Math.cos(rotation);
        Point[] pointArray = innerCorners;
        int n = innerCorners.length;
        int n2 = 0;
        while (n2 < n) {
            boolean inYBounds;
            Point corner = pointArray[n2];
            double x = corner.getX();
            double y = corner.getY();
            double xn = x * c + y * s;
            double yn = -x * s + y * c;
            boolean inXBounds = -outerHalfWidth < (xn -= translation.getX()) && xn < outerHalfWidth;
            boolean bl = inYBounds = -outerHalfHeight < (yn -= translation.getY()) && yn < outerHalfHeight;
            if (!inXBounds || !inYBounds) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void redraw() {
        this.redraw = true;
    }

    private double calculatePatternScale(int patternSize) {
        Position pos1 = this.coordinateSystem.getPosition(this.mapProjection.fromDivPixelToLatLng(Point.newInstance((double)0.0, (double)0.0)));
        Position pos2 = this.coordinateSystem.getPosition(this.mapProjection.fromDivPixelToLatLng(Point.newInstance((double)patternSize, (double)0.0)));
        double patternSizeMeters = pos1.getDistance(pos2).getMeters();
        double mult = 1.8;
        double wantedLength = Math.pow(10.0, Math.round(Math.log10(patternSizeMeters * 1.8)));
        wantedLength = Math.max(wantedLength, 10.0);
        double scale = (wantedLength *= 2.0) / patternSizeMeters;
        return scale;
    }

    protected void draw() {
        if (this.redraw) {
            this.updateTransition(0L);
            this.setCanvasSettings();
            this.drawToCanvas();
            this.redraw = false;
            this.transitionDisableCountdown = 3;
        }
    }

    public void setCanvasSettings() {
        this.mapWidth = this.getMap().getDiv().getClientWidth();
        this.mapHeight = this.getMap().getDiv().getClientHeight();
        int size = Math.max(this.mapWidth, this.mapHeight);
        int reserve = (int)((double)size * 0.5);
        int sizeWithReserve = size + reserve;
        this.canvas.setWidth(String.valueOf(sizeWithReserve));
        this.canvas.setHeight(String.valueOf(sizeWithReserve));
        this.canvas.setCoordinateSpaceWidth(sizeWithReserve);
        this.canvas.setCoordinateSpaceHeight(sizeWithReserve);
        int widthReserve = sizeWithReserve - this.mapWidth;
        int heightReserve = sizeWithReserve - this.mapHeight;
        Point sw = this.mapProjection.fromLatLngToDivPixel(this.getMap().getBounds().getSouthWest());
        Point ne = this.mapProjection.fromLatLngToDivPixel(this.getMap().getBounds().getNorthEast());
        this.setWidgetPosLeft(Math.min(sw.getX(), ne.getX()) - (double)(widthReserve / 2));
        this.setWidgetPosTop(Math.min(sw.getY(), ne.getY()) - (double)(heightReserve / 2));
        this.setCanvasPosition(this.getWidgetPosLeft(), this.getWidgetPosTop());
        this.updateDrawingAngleAndSetCanvasRotation(0.0);
    }

    protected void drawToCanvas() {
        int canvasWidth = this.canvas.getCoordinateSpaceWidth();
        int canvasHeight = this.canvas.getCoordinateSpaceHeight();
        int tileSize = 16;
        double patternScale = this.calculatePatternScale(16);
        Context2d ctx = this.canvas.getContext2d();
        ctx.clearRect(0.0, 0.0, (double)canvasWidth, (double)canvasHeight);
        ctx.save();
        ctx.setGlobalAlpha(0.4);
        ctx.setFillStyle((FillStrokeStyle)ctx.createPattern(this.tileGen.getTile(), Context2d.Repetition.REPEAT));
        ctx.rect(0.0, 0.0, (double)canvasWidth, (double)canvasHeight);
        ctx.translate((double)(canvasWidth / 2), (double)(canvasHeight / 2));
        ctx.scale(patternScale, patternScale);
        ctx.fill();
        this.drawnPatternSize = 16.0 * patternScale;
    }

    public void onResize() {
        this.windLadder.forceSwap();
        super.onResize();
    }

    protected void drawCenterChanged() {
        this.update(null, null, -1L);
        this.windLadder.forceSwap();
    }

    protected void onZoomChange() {
        this.windLadder.forceSwap();
    }

    protected OverlayViewOnAddHandler getOnAddHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected int getMapWidth() {
        if (this.mapWidth == null) {
            this.mapWidth = this.getMap().getDiv().getClientWidth();
        }
        return this.mapWidth;
    }

    protected int getMapHeight() {
        if (this.mapHeight == null) {
            this.mapHeight = this.getMap().getDiv().getClientHeight();
        }
        return this.mapHeight;
    }

    static /* synthetic */ Canvas access$0(WindLadderOverlay windLadderOverlay) {
        return windLadderOverlay.canvas;
    }

    static /* synthetic */ void access$1(WindLadderOverlay windLadderOverlay) {
        windLadderOverlay.onAttach();
    }
}

