/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.Point;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.WindSourceTypeFormatter;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.client.shared.racemap.ImageTransformer;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapImageManager;
import com.sap.sailing.gwt.ui.shared.WindDTO;
import com.sap.sailing.gwt.ui.shared.WindTrackInfoDTO;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;

public class WindSensorOverlay
extends CanvasOverlayV3 {
    private WindTrackInfoDTO windTrackInfoDTO;
    private WindSource windSource;
    private final ImageTransformer transformer;
    private final StringMessages stringMessages;
    private int canvasWidth;
    private int canvasHeight;
    private final NumberFormat numberFormat = NumberFormat.getFormat((String)"0.0");

    public WindSensorOverlay(MapWidget map, int zIndex, RaceMapImageManager raceMapImageManager, StringMessages stringMessages, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.stringMessages = stringMessages;
        this.canvasWidth = 28;
        this.canvasHeight = 28;
        if (this.getCanvas() != null) {
            this.getCanvas().setWidth(String.valueOf(this.canvasWidth));
            this.getCanvas().setHeight(String.valueOf(this.canvasHeight));
            this.getCanvas().setCoordinateSpaceWidth(this.canvasWidth);
            this.getCanvas().setCoordinateSpaceHeight(this.canvasHeight);
        }
        this.transformer = raceMapImageManager.getWindSensorIconTransformer();
    }

    protected void draw() {
        boolean hasValidWind = false;
        if (this.mapProjection != null && this.windTrackInfoDTO != null && this.windTrackInfoDTO.windFixes.size() > 0) {
            WindDTO windDTO = (WindDTO)this.windTrackInfoDTO.windFixes.get(0);
            Position position = windDTO.position;
            if (position != null) {
                double rotationDegOfWindSymbol = windDTO.dampenedTrueWindBearingDeg;
                this.transformer.drawToCanvas(this.getCanvas(), this.coordinateSystem.mapDegreeBearing(rotationDegOfWindSymbol), 1.0, windDTO.confidence == null ? null : Double.valueOf(Math.min(1.0, 1000.0 * windDTO.confidence)));
                this.setLatLngPosition(this.coordinateSystem.toLatLng(windDTO.position));
                Point sensorPositionInPx = this.mapProjection.fromLatLngToDivPixel(this.getLatLngPosition());
                this.setCanvasPosition(sensorPositionInPx.getX() - (double)(this.canvasWidth / 2), sensorPositionInPx.getY() - (double)(this.canvasHeight / 2));
                String title = String.valueOf(this.stringMessages.wind()) + " (" + WindSourceTypeFormatter.format((WindSource)this.windSource, (StringMessages)this.stringMessages) + "): ";
                title = String.valueOf(title) + Math.round(windDTO.dampenedTrueWindFromDeg) + " " + this.stringMessages.degreesShort() + ",  ";
                title = String.valueOf(title) + this.numberFormat.format((Number)windDTO.dampenedTrueWindSpeedInKnots) + " " + this.stringMessages.knotsUnit();
                this.getCanvas().setTitle(title);
                hasValidWind = true;
            }
        }
        if (!hasValidWind) {
            this.setLatLngPosition(null);
        }
        this.getCanvas().setVisible(hasValidWind);
    }

    public WindTrackInfoDTO getWindTrackInfoDTO() {
        return this.windTrackInfoDTO;
    }

    public void setWindInfo(WindTrackInfoDTO windTrackInfoDTO, WindSource windSource) {
        this.windTrackInfoDTO = windTrackInfoDTO;
        this.windSource = windSource;
    }

    public WindSource getWindSource() {
        return this.windSource;
    }
}

