/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.CssColor;
import com.google.gwt.canvas.dom.client.FillStrokeStyle;
import com.google.gwt.canvas.dom.client.TextMetrics;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;

/*
 * Exception performing whole class analysis ignored.
 */
public class SmallTransparentInfoOverlay
extends CanvasOverlayV3 {
    private String infoText;
    private Position position;
    private int canvasWidth;
    private int canvasHeight;
    private int infoBoxHeight;
    private int infoBoxWidth;
    private double cornerRadius;
    private final double fontScalingFactor;
    private static final CssColor GREYTRANSPARENT_COLOR = CssColor.make((String)"rgba(255,255,255,0.75)");
    private final CssColor greyWithCustomTransparency;

    public SmallTransparentInfoOverlay(MapWidget map, int zIndex, String infoText, CoordinateSystem coordinateSystem) {
        this(map, zIndex, infoText, coordinateSystem, 1.0, GREYTRANSPARENT_COLOR);
    }

    public SmallTransparentInfoOverlay(MapWidget map, int zIndex, String infoText, CoordinateSystem coordinateSystem, double fontScalingFactor) {
        this(map, zIndex, infoText, coordinateSystem, fontScalingFactor, GREYTRANSPARENT_COLOR);
    }

    public SmallTransparentInfoOverlay(MapWidget map, int zIndex, String infoText, CoordinateSystem coordinateSystem, CssColor cssColor) {
        this(map, zIndex, infoText, coordinateSystem, 1.0, cssColor);
    }

    public SmallTransparentInfoOverlay(MapWidget map, int zIndex, String infoText, CoordinateSystem coordinateSystem, double fontScalingFactor, CssColor cssColor) {
        super(map, zIndex, coordinateSystem);
        this.infoText = infoText;
        this.fontScalingFactor = fontScalingFactor;
        this.canvasWidth = 20;
        this.canvasHeight = 45;
        this.infoBoxWidth = 20;
        this.infoBoxHeight = 20;
        this.cornerRadius = 4.0;
        if (this.getCanvas() != null) {
            this.getCanvas().setWidth(String.valueOf(this.canvasWidth));
            this.getCanvas().setHeight(String.valueOf(this.canvasHeight));
            this.getCanvas().setCoordinateSpaceWidth(this.canvasWidth);
            this.getCanvas().setCoordinateSpaceHeight(this.canvasHeight);
        }
        this.greyWithCustomTransparency = cssColor;
    }

    protected void draw() {
        int LINE_SPACING = 3;
        int BOTTOM_MARGIN = 8;
        int LEFT_MARGIN = 8;
        int RIGHT_MARGIN = 9;
        int POLE_LENGTH = 25;
        if (this.mapProjection != null && this.position != null) {
            LatLng latLngPosition = this.coordinateSystem.toLatLng(this.position);
            Context2d context2d = this.getCanvas().getContext2d();
            int fontSizeInPx = (int)(this.fontScalingFactor * (double)(12 + 2 * Math.max(0, this.map.getZoom() - 15)));
            int LINE_HEIGHT = fontSizeInPx + 3;
            context2d.setFont(fontSizeInPx + "px Roboto, Arial, sans-serif");
            double textWidth = 0.0;
            this.infoBoxHeight = 8;
            String[] stringArray = this.infoText.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                TextMetrics measureText = context2d.measureText(line);
                if (measureText.getWidth() > textWidth) {
                    textWidth = measureText.getWidth();
                }
                this.infoBoxHeight += LINE_HEIGHT;
                ++n2;
            }
            this.infoBoxWidth = this.canvasWidth = (int)textWidth + 8 + 9;
            this.canvasHeight = this.infoBoxHeight + 25;
            this.getCanvas().setWidth(String.valueOf(this.canvasWidth));
            this.getCanvas().setCoordinateSpaceWidth(this.canvasWidth);
            this.getCanvas().setHeight(String.valueOf(this.canvasHeight));
            this.getCanvas().setCoordinateSpaceHeight(this.canvasHeight);
            context2d.setFillStyle((FillStrokeStyle)this.greyWithCustomTransparency);
            SmallTransparentInfoOverlay.drawRoundedRect((Context2d)context2d, (double)(this.cornerRadius / 2.0), (double)(this.cornerRadius / 2.0), (double)((double)this.infoBoxWidth - this.cornerRadius), (double)((double)this.infoBoxHeight - this.cornerRadius), (double)this.cornerRadius);
            context2d.translate(-0.5, -0.5);
            context2d.setStrokeStyle((FillStrokeStyle)this.greyWithCustomTransparency);
            context2d.setLineWidth(1.0);
            context2d.beginPath();
            context2d.moveTo(this.cornerRadius / 2.0, (double)(this.infoBoxHeight / 2));
            context2d.lineTo(this.cornerRadius / 2.0, (double)this.canvasHeight);
            context2d.stroke();
            context2d.translate(0.0, 0.0);
            context2d.beginPath();
            context2d.setFillStyle("black");
            context2d.setFont(fontSizeInPx + "px Roboto, Arial, sans-serif");
            int y = LINE_HEIGHT;
            String[] stringArray2 = this.infoText.split("\n");
            int n3 = stringArray2.length;
            n = 0;
            while (n < n3) {
                String line = stringArray2[n];
                context2d.fillText(line, 8.0, (double)y);
                y += LINE_HEIGHT;
                ++n;
            }
            context2d.stroke();
            Point objectPositionInPx = this.mapProjection.fromLatLngToDivPixel(latLngPosition);
            this.setCanvasPosition(objectPositionInPx.getX(), objectPositionInPx.getY() - (double)this.canvasHeight);
        }
    }

    public static void drawRoundedRect(Context2d context, double x, double y, double w, double h, double r) {
        context.beginPath();
        context.moveTo(x + r, y);
        context.lineTo(x + w - r, y);
        context.quadraticCurveTo(x + w, y, x + w, y + r);
        context.lineTo(x + w, y + h - r);
        context.quadraticCurveTo(x + w, y + h, x + w - r, y + h);
        context.lineTo(x + r, y + h);
        context.quadraticCurveTo(x, y + h, x, y + h - r);
        context.lineTo(x, y + r);
        context.quadraticCurveTo(x, y, x + r, y);
        context.stroke();
        context.fill();
    }

    public void setPosition(Position position, long timeForPositionTransitionMillis) {
        this.updateTransition(timeForPositionTransitionMillis);
        this.position = position;
    }

    public void setInfoText(String infoText) {
        this.infoText = infoText;
    }
}

