/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.base.Size;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.gwt.ui.client.shared.racemap.BoatOverlay;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.client.shared.racemap.RowingBoatClassVectorGraphicsResolver;
import com.sap.sailing.gwt.ui.shared.SpeedWithBearingDTO;
import com.sap.sailing.gwt.ui.shared.racemap.RowingBoatClassVectorGraphics;
import com.sap.sse.common.Color;
import com.sap.sse.common.Util;

public class RowingBoatOverlay
extends BoatOverlay {
    private final RowingBoatClassVectorGraphics rowingBoatVectorGraphics;
    private Integer lastWidth;
    private Integer lastHeight;
    private boolean isPullingOars;

    public RowingBoatOverlay(MapWidget map, int zIndex, CompetitorDTO competitorDTO, Color color, CoordinateSystem coordinateSystem) {
        super(map, zIndex, competitorDTO.hasBoat() ? ((CompetitorWithBoatDTO)competitorDTO).getBoat() : null, color, coordinateSystem);
        this.rowingBoatVectorGraphics = RowingBoatClassVectorGraphicsResolver.resolveRowingBoatClassVectorGraphics((String)this.boatClass.getName());
    }

    public void draw() {
        if (this.mapProjection != null && this.boatFix != null) {
            long worldWidth = (long)this.mapProjection.getWorldWidth();
            Util.Pair boatScaleAndSize = this.boatScaleAndSizePerWorldWidthCache.computeIfAbsent(worldWidth, z -> this.getBoatScaleAndSize(this.boatClass));
            Size boatSizeScaleFactor = (Size)boatScaleAndSize.getA();
            this.canvasWidth = (int)((Size)boatScaleAndSize.getB()).getWidth();
            this.canvasHeight = (int)((Size)boatScaleAndSize.getB()).getHeight();
            if (this.lastWidth == null || this.canvasWidth != this.lastWidth || this.lastHeight == null || this.canvasHeight != this.lastHeight) {
                this.setCanvasSize(this.canvasWidth, this.canvasHeight);
            }
            this.isPullingOars = !this.isPullingOars;
            this.rowingBoatVectorGraphics.drawRowingBoatToCanvas(this.getCanvas().getContext2d(), this.isPullingOars, this.isSelected(), (double)this.canvasWidth, (double)this.canvasHeight, boatSizeScaleFactor, this.color);
            LatLng latLngPosition = this.coordinateSystem.toLatLng(this.boatFix.position);
            Point boatPositionInPx = this.mapProjection.fromLatLngToDivPixel(latLngPosition);
            this.setCanvasPosition(boatPositionInPx.getX() - (double)(this.getCanvas().getCoordinateSpaceWidth() / 2), boatPositionInPx.getY() - (double)(this.getCanvas().getCoordinateSpaceHeight() / 2));
            SpeedWithBearingDTO speedWithBearing = this.boatFix.speedWithBearing;
            if (speedWithBearing == null) {
                speedWithBearing = new SpeedWithBearingDTO(0.0, 0.0);
            }
            this.updateDrawingAngleAndSetCanvasRotation(this.coordinateSystem.mapDegreeBearing(speedWithBearing.bearingInDegrees - ORIGINAL_BOAT_IMAGE_ROTATIION_ANGLE));
        }
    }
}

