/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.maps.client.base.LatLngBounds;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMap;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapZoomSettings;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.generic.AbstractGenericSerializableSettings;
import com.sap.sse.common.settings.generic.BooleanSetting;
import com.sap.sse.common.settings.generic.EnumSetSetting;
import java.util.Collections;

public class RaceMapZoomSettings
extends AbstractGenericSerializableSettings {
    private static final long serialVersionUID = 7283052942434130497L;
    private EnumSetSetting<ZoomTypes> typesToConsiderOnZoom;
    private BooleanSetting zoomToSelectedCompetitors;

    protected void addChildSettings() {
        this.typesToConsiderOnZoom = new EnumSetSetting("typesToConsiderOnZoom", (AbstractGenericSerializableSettings)this, Collections.singleton(ZoomTypes.BUOYS), ZoomTypes::valueOf);
        this.zoomToSelectedCompetitors = new BooleanSetting("zoomToSelectedCompetitors", (AbstractGenericSerializableSettings)this, Boolean.valueOf(false));
    }

    public RaceMapZoomSettings() {
    }

    public RaceMapZoomSettings(String propertyName, AbstractGenericSerializableSettings parentSettings) {
        super(propertyName, parentSettings);
    }

    public RaceMapZoomSettings(Iterable<ZoomTypes> typesToConsider, boolean zoomToSelected) {
        this();
        this.typesToConsiderOnZoom.setValues(typesToConsider);
        this.zoomToSelectedCompetitors.setValue((Object)zoomToSelected);
    }

    protected void init(RaceMapZoomSettings settings) {
        if (settings != null) {
            this.typesToConsiderOnZoom.setValues(settings.getTypesToConsiderOnZoom());
            this.zoomToSelectedCompetitors.setValue((Object)settings.isZoomToSelectedCompetitors());
        }
    }

    public LatLngBounds getNewBounds(RaceMap forMap) {
        LatLngBounds newBounds = null;
        if (this.typesToConsiderOnZoom != null) {
            for (ZoomTypes type : this.typesToConsiderOnZoom.getValues()) {
                LatLngBounds calculatedBounds = type.calculateNewBounds(forMap);
                if (calculatedBounds == null) continue;
                if (newBounds == null) {
                    newBounds = calculatedBounds;
                    continue;
                }
                newBounds.extend(calculatedBounds.getNorthEast());
                newBounds.extend(calculatedBounds.getSouthWest());
            }
        }
        return newBounds;
    }

    public Iterable<ZoomTypes> getTypesToConsiderOnZoom() {
        return this.typesToConsiderOnZoom.getValues();
    }

    public boolean isZoomToSelectedCompetitors() {
        return (Boolean)this.zoomToSelectedCompetitors.getValue();
    }

    public boolean containsZoomType(ZoomTypes zoomType) {
        return Util.contains((Iterable)this.typesToConsiderOnZoom.getValues(), (Object)zoomType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.typesToConsiderOnZoom == null ? 0 : this.typesToConsiderOnZoom.hashCode());
        result = 31 * result + ((Boolean)this.zoomToSelectedCompetitors.getValue() != false ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RaceMapZoomSettings other = (RaceMapZoomSettings)obj;
        if (this.typesToConsiderOnZoom == null ? other.typesToConsiderOnZoom != null : !this.typesToConsiderOnZoom.equals((Object)other.typesToConsiderOnZoom)) {
            return false;
        }
        return this.zoomToSelectedCompetitors == other.zoomToSelectedCompetitors;
    }
}

