/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.base.Size;
import com.sap.sailing.domain.common.FixType;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.GPSFixDTO;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;
import com.sap.sailing.gwt.ui.shared.racemap.FixVectorGraphics;
import com.sap.sse.common.Util;
import java.util.HashMap;

public class FixOverlay
extends CanvasOverlayV3 {
    private GPSFixDTO fix;
    private final FixVectorGraphics fixVectorGraphics;
    private final HashMap<Integer, Util.Pair<Double, Size>> fixScaleAndSizePerZoomCache;
    private Double lastWidth;
    private Double lastHeight;
    private Double lastScaleFactor;

    public FixOverlay(MapWidget map, int zIndex, GPSFixDTO fixDTO, FixType type, String color, CoordinateSystem coordinateSystem, String tooltip) {
        super(map, zIndex, coordinateSystem);
        this.fix = fixDTO;
        this.fixVectorGraphics = new FixVectorGraphics(type, color);
        this.fixScaleAndSizePerZoomCache = new HashMap();
        this.setCanvasSize(50, 50);
        this.getCanvas().setTitle(tooltip);
    }

    protected void draw() {
        if (this.mapProjection != null && this.fix != null) {
            double canvasHeight;
            int zoom = this.map.getZoom();
            Util.Pair fixScaleAndSize = (Util.Pair)this.fixScaleAndSizePerZoomCache.get(zoom);
            if (fixScaleAndSize == null) {
                fixScaleAndSize = this.getFixScaleAndSize();
                this.fixScaleAndSizePerZoomCache.put(zoom, fixScaleAndSize);
            }
            double fixSizeScaleFactor = (Double)fixScaleAndSize.getA();
            double canvasWidth = ((Size)fixScaleAndSize.getB()).getWidth();
            if (this.needToDraw(canvasWidth, canvasHeight = ((Size)fixScaleAndSize.getB()).getHeight(), fixSizeScaleFactor)) {
                this.setCanvasSize((int)canvasWidth, (int)canvasHeight);
                Context2d context2d = this.getCanvas().getContext2d();
                this.fixVectorGraphics.drawMarkToCanvas(context2d, canvasWidth, canvasHeight, fixSizeScaleFactor);
                this.lastScaleFactor = fixSizeScaleFactor;
                this.lastWidth = canvasWidth;
                this.lastHeight = canvasHeight;
            }
            this.setLatLngPosition(this.coordinateSystem.toLatLng(this.fix.position));
            Point fixPositionInPx = this.mapProjection.fromLatLngToDivPixel(this.coordinateSystem.toLatLng(this.fix.position));
            this.setCanvasPosition(fixPositionInPx.getX() - canvasWidth / 2.0, fixPositionInPx.getY() - canvasHeight / 2.0);
        }
    }

    private boolean needToDraw(double width, double height, double scaleFactor) {
        return this.lastScaleFactor == null || this.lastScaleFactor != scaleFactor || this.lastWidth == null || this.lastWidth != width || this.lastHeight == null || this.lastHeight != height;
    }

    public Util.Pair<Double, Size> getFixScaleAndSize() {
        double minFixHeight = 20.0;
        double buoyScaleFactor = 2.0;
        Size fixSizeInPixel = this.calculateBoundingBox(this.mapProjection, this.fix.position, this.fixVectorGraphics.getFixWidth().scale(buoyScaleFactor), this.fixVectorGraphics.getFixHeight().scale(buoyScaleFactor));
        double fixHeightInPixel = fixSizeInPixel.getHeight();
        if (fixHeightInPixel < minFixHeight) {
            fixHeightInPixel = minFixHeight;
        }
        double fixSizeScaleFactor = fixHeightInPixel / this.fixVectorGraphics.getFixHeight().scale(100.0).getMeters();
        return new Util.Pair((Object)fixSizeScaleFactor, (Object)Size.newInstance((double)(fixHeightInPixel * 2.0), (double)(fixHeightInPixel * 2.0)));
    }

    public GPSFixDTO getGPSFixDTO() {
        return this.fix;
    }

    public void setGPSFixDTO(GPSFixDTO fix) {
        this.fix = fix;
        this.draw();
    }

    public String getColor() {
        return this.fixVectorGraphics.getColor();
    }

    public FixType getType() {
        return this.fixVectorGraphics.getType();
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }
}

