/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.CssColor;
import com.google.gwt.canvas.dom.client.FillStrokeStyle;
import com.google.gwt.canvas.dom.client.TextMetrics;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;
import com.sap.sse.common.Color;

public class CompetitorInfoOverlay
extends CanvasOverlayV3 {
    private String infoText;
    private Position position;
    private int canvasWidth;
    private int canvasHeight;
    private int infoBoxHeight;
    private int defaultInfoBoxHeight = 14;
    public static final int X_TEXT_COORDINATE = 8;
    public static final int Y_TEXT_COORDINATE = 14;
    private Color competitorColor;

    public CompetitorInfoOverlay(MapWidget map, int zIndex, Color competitorColor, String infoText, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.competitorColor = competitorColor;
        this.infoText = infoText;
        this.canvasWidth = 100;
        this.canvasHeight = 100;
        this.setCanvasSize(this.canvasWidth, this.canvasHeight);
        this.canvas.addStyleName("competitorInfo-Canvas");
    }

    protected void draw() {
        if (this.mapProjection != null && this.position != null) {
            LatLng latLngPosition = this.coordinateSystem.toLatLng(this.position);
            Context2d ctx = this.getCanvas().getContext2d();
            CssColor grayTransparentColor = CssColor.make((String)"rgba(255,255,255,0.75)");
            ctx.setFont("12px bold Verdana sans-serif");
            String[] textLines = this.infoText.split("\n");
            TextMetrics measureText = ctx.measureText(this.findLargestLine(textLines));
            double largestLineWidth = measureText.getWidth();
            this.infoBoxHeight = this.defaultInfoBoxHeight + textLines.length * 10;
            this.canvasWidth = (int)largestLineWidth + this.infoBoxHeight;
            this.setCanvasSize(this.canvasWidth, this.canvasHeight);
            ctx.save();
            ctx.clearRect(0.0, 0.0, (double)this.canvasWidth, (double)this.canvasHeight);
            ctx.setLineWidth(1.0);
            ctx.setFillStyle((FillStrokeStyle)grayTransparentColor);
            if (this.competitorColor != null) {
                ctx.setStrokeStyle(this.competitorColor.getAsHtml());
            } else {
                ctx.setStrokeStyle("#888888");
            }
            ctx.beginPath();
            ctx.moveTo(0.0, 0.0);
            ctx.lineTo(0.0, 101.0);
            ctx.stroke();
            ctx.beginPath();
            ctx.moveTo(1.0, 1.0);
            ctx.lineTo((double)this.canvasWidth, 1.0);
            double lenghtOfTheLastLine = ctx.measureText(textLines[textLines.length - 1]).getWidth();
            int bottomLineWidth = 16 + (int)lenghtOfTheLastLine;
            ctx.lineTo((double)bottomLineWidth, (double)this.infoBoxHeight);
            ctx.lineTo(1.0, (double)this.infoBoxHeight);
            ctx.closePath();
            ctx.fill();
            ctx.stroke();
            ctx.beginPath();
            ctx.setFillStyle("black");
            this.drawText(textLines, ctx);
            ctx.stroke();
            ctx.restore();
            Point objectPositionInPx = this.mapProjection.fromLatLngToDivPixel(latLngPosition);
            this.setCanvasPosition(objectPositionInPx.getX(), objectPositionInPx.getY() - (double)this.canvasHeight);
        }
    }

    public void setPosition(Position position, long timeForPositionTransitionMillis) {
        this.updateTransition(timeForPositionTransitionMillis);
        this.position = position;
    }

    public void setInfoText(String infoText) {
        this.infoText = infoText;
    }

    private void drawText(String[] lines, Context2d ctx) {
        int i = 0;
        while (i < lines.length) {
            ctx.fillText(lines[i], 8.0, (double)(14 + i * 12));
            ++i;
        }
    }

    private String findLargestLine(String[] lines) {
        int index = 0;
        int maxLength = lines[0].length();
        int i = 0;
        while (i < lines.length) {
            if (maxLength < lines[i].length()) {
                index = i;
                maxLength = lines[i].length();
            }
            ++i;
        }
        return lines[index];
    }
}

