/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.shared.racemap;

import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.Size;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.gwt.ui.client.shared.racemap.BoatClassVectorGraphicsResolver;
import com.sap.sailing.gwt.ui.client.shared.racemap.BoatOverlay;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.GPSFixDTOWithSpeedWindTackAndLegType;
import com.sap.sailing.gwt.ui.shared.racemap.BoatClassVectorGraphics;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;
import com.sap.sse.common.Color;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.Map;

public abstract class BoatOverlay
extends CanvasOverlayV3 {
    protected final BoatClassDTO boatClass;
    protected GPSFixDTOWithSpeedWindTackAndLegType boatFix;
    protected static double ORIGINAL_BOAT_IMAGE_ROTATIION_ANGLE = 90.0;
    protected int canvasWidth;
    protected int canvasHeight;
    protected Color color;
    protected Map<Long, Util.Pair<Size, Size>> boatScaleAndSizePerWorldWidthCache;
    private final BoatClassVectorGraphics boatVectorGraphics;
    private DisplayMode displayMode;

    public BoatOverlay(MapWidget map, int zIndex, BoatDTO boatDTO, Color color, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.boatClass = boatDTO.getBoatClass();
        this.color = color;
        this.boatScaleAndSizePerWorldWidthCache = new HashMap();
        this.boatVectorGraphics = BoatClassVectorGraphicsResolver.resolveBoatClassVectorGraphics((String)this.boatClass.getName());
    }

    protected abstract void draw();

    public void setBoatFix(GPSFixDTOWithSpeedWindTackAndLegType boatFix, long timeForPositionTransitionMillis) {
        this.updateTransition(timeForPositionTransitionMillis);
        this.boatFix = boatFix;
    }

    public Util.Pair<Size, Size> getBoatScaleAndSize(BoatClassDTO boatClass) {
        Size boatSizeInPixels = this.getCorrelatedBoatSize(boatClass.getHullLength(), boatClass.getHullBeam());
        double boatHullScaleFactor = boatSizeInPixels.getWidth() / this.boatVectorGraphics.getHullLengthInPx();
        double boatBeamScaleFactor = boatSizeInPixels.getHeight() / this.boatVectorGraphics.getBeamInPx();
        double scaledWidthSize = this.boatVectorGraphics.getOverallLengthInPx() * boatHullScaleFactor;
        double scaledBeamSize = this.boatVectorGraphics.getOverallLengthInPx() * boatBeamScaleFactor;
        return new Util.Pair((Object)Size.newInstance((double)boatHullScaleFactor, (double)boatBeamScaleFactor), (Object)Size.newInstance((double)(scaledWidthSize + scaledWidthSize / 2.0), (double)(scaledBeamSize + scaledBeamSize / 2.0)));
    }

    private Size getCorrelatedBoatSize(Distance hullLength, Distance hullBeam) {
        Size boatSizeInPixel = this.calculateBoundingBox(this.mapProjection, this.boatFix.position, hullLength, hullBeam);
        this.changeBoatSizeIfTooShortHull(boatSizeInPixel, hullLength, hullBeam);
        this.changeBoatSizeIfTooNarrowBeam(boatSizeInPixel, hullLength, hullBeam);
        return boatSizeInPixel;
    }

    private void changeBoatSizeIfTooShortHull(Size boatSizeInPixel, Distance hullLength, Distance hullBeam) {
        double minBoatHullLengthInPx = this.boatVectorGraphics.getMinHullLengthInPx();
        if (boatSizeInPixel.getWidth() < minBoatHullLengthInPx) {
            double ratioBeamHullLength = hullBeam.divide(hullLength);
            boatSizeInPixel.setHeight(minBoatHullLengthInPx * ratioBeamHullLength);
            boatSizeInPixel.setWidth(minBoatHullLengthInPx);
        }
    }

    private void changeBoatSizeIfTooNarrowBeam(Size boatSizeInPixel, Distance hullLength, Distance hullBeam) {
        double minBoatBeamInPx = this.boatVectorGraphics.getMinBeamInPx();
        if (boatSizeInPixel.getHeight() < minBoatBeamInPx) {
            double ratioHullBeamLength = hullLength.divide(hullBeam);
            boatSizeInPixel.setWidth(minBoatBeamInPx * ratioHullBeamLength);
            boatSizeInPixel.setHeight(minBoatBeamInPx);
        }
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(DisplayMode displayMode) {
        this.displayMode = displayMode;
    }
}

