/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.media.MediaTrackWithSecurityDTO;
import com.sap.sailing.gwt.ui.client.media.MediaSynchAdapter;
import com.sap.sailing.gwt.ui.client.media.VideoJSPlayer;
import com.sap.sailing.gwt.ui.client.media.shared.AbstractMediaPlayer;
import com.sap.sailing.gwt.ui.client.media.shared.MediaSynchPlayer;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.client.player.Timer;

public class VideoJSSyncPlayer
extends AbstractMediaPlayer
implements MediaSynchPlayer,
RequiresResize {
    private VideoJSPlayer videoJsDelegate = new VideoJSPlayer(true, false);
    private MediaSynchAdapter.EditFlag editFlag;
    private final TimePoint raceStartTime;
    private final Timer raceTimer;

    public VideoJSSyncPlayer(MediaTrackWithSecurityDTO mediaTrack, TimePoint raceStartTime, Timer raceTimer) {
        super(mediaTrack);
        this.raceStartTime = raceStartTime;
        this.raceTimer = raceTimer;
        this.videoJsDelegate.setVideo(mediaTrack.mimeType, mediaTrack.url);
    }

    public boolean isMediaPaused() {
        return this.videoJsDelegate.paused();
    }

    public void pauseMedia() {
        if (!this.isEditing()) {
            this.videoJsDelegate.pause();
        }
    }

    public void playMedia() {
        if (!this.isEditing()) {
            this.videoJsDelegate.play();
        }
    }

    public double getDuration() {
        return this.videoJsDelegate.getDuration();
    }

    public double getCurrentMediaTime() {
        return this.videoJsDelegate.getCurrentTime();
    }

    public long getCurrentMediaTimeMillis() {
        return (long)(this.getCurrentMediaTime() * 1000.0);
    }

    public void setCurrentMediaTime(double mediaTime) {
        this.videoJsDelegate.setCurrentTime((int)mediaTime);
    }

    public void setPlaybackSpeed(double newPlaySpeedFactor) {
        this.videoJsDelegate.setPlaybackRate(newPlaySpeedFactor);
    }

    public void setMuted(boolean isToBeMuted) {
        this.videoJsDelegate.setMuted(isToBeMuted);
    }

    public void shutDown() {
        this.videoJsDelegate.removeFromParent();
        this.videoJsDelegate.disposeIf2D();
    }

    public Widget asWidget() {
        return this.videoJsDelegate;
    }

    public long getOffset() {
        return this.getMediaTrack().startTime.asMillis() - this.raceStartTime.asMillis();
    }

    public void changeOffsetBy(long delta) {
        this.getMediaTrack().startTime = this.getMediaTrack().startTime.plus(delta);
        this.forceAlign();
    }

    public void setControlsVisible(boolean isVisible) {
        this.videoJsDelegate.setControlsVisible(isVisible);
    }

    public void pauseRace() {
        this.videoJsDelegate.pause();
    }

    public void updateOffset() {
        this.getMediaTrack().startTime = new MillisecondsTimePoint(this.raceTimer.getTime().getTime() - this.getCurrentMediaTimeMillis());
    }

    protected void alignTime() {
        if (!this.isEditing()) {
            super.alignTime();
        }
    }

    public void setEditFlag(MediaSynchAdapter.EditFlag editFlag) {
        this.editFlag = editFlag;
    }

    private boolean isEditing() {
        return this.editFlag != null && this.editFlag.isEditing();
    }

    public int getDefaultWidth() {
        return this.videoJsDelegate.getVideoWidth();
    }

    public int getDefaultHeight() {
        return this.videoJsDelegate.getVideoHeight();
    }

    public void onResize() {
        this.videoJsDelegate.onResize();
    }
}

