/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.i18n.client.NumberFormat;
import com.sap.sailing.gwt.ui.client.NumberFormatterFactory;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;

public class TimeFormatUtil {
    static final int MILLISECONDS_PER_MINUTE = 60000;
    static final int MILLISECONDS_PER_HOUR = 3600000;
    public static final DateTimeFormat DATETIME_FORMAT = DateTimeFormat.getFormat((String)"yyyy MMM dd HH:mm:ss.SSS");
    private static NumberFormat zeroPaddingNumberFormat_Min = NumberFormatterFactory.getDecimalFormat((int)2, (int)0);
    private static NumberFormat zeroPaddingNumberFormat_Sec = NumberFormat.getFormat((String)"00.000");

    public static Duration hrsMinSecToMilliSeconds(String hrsMinSec) {
        String[] segements = hrsMinSec.split(":");
        long milliseconds = 0L;
        boolean isNegative = false;
        switch (segements.length) {
            case 3: {
                String hoursText = segements[0].trim();
                int hours = Integer.valueOf(hoursText);
                isNegative = Integer.signum(hours) < 0;
                milliseconds = Math.abs(hours) * 3600000;
            }
            case 2: {
                String minutesText = segements[segements.length - 2].trim();
                int minutes = Integer.valueOf(minutesText);
                isNegative = isNegative || Integer.signum(minutes) < 0;
                milliseconds += (long)(Math.abs(minutes) * 60000);
            }
            case 1: {
                String secondsText = segements[segements.length - 1].trim();
                float seconds = Float.valueOf(secondsText).floatValue();
                isNegative = isNegative || Math.signum(seconds) < 0.0f;
                milliseconds += (long)Math.round(seconds * 1000.0f);
            }
        }
        if (isNegative) {
            return new MillisecondsDurationImpl(-milliseconds);
        }
        return new MillisecondsDurationImpl(milliseconds);
    }

    public static String durationToHrsMinSec(Duration duration) {
        if (duration != null) {
            long rest;
            long minutes;
            long milliseconds = duration.asMillis();
            int signum = Long.signum(milliseconds);
            milliseconds = Math.abs(milliseconds);
            StringBuilder result = new StringBuilder();
            long hours = milliseconds / 3600000L;
            if (hours > 0L) {
                result.append(String.valueOf(String.valueOf((long)signum * hours)) + ':');
                signum = 1;
            }
            if ((minutes = (rest = (milliseconds = Math.abs(milliseconds)) % 3600000L) / 60000L) > 0L || result.length() > 0) {
                result.append(String.valueOf(zeroPaddingNumberFormat_Min.format((double)((long)signum * minutes))) + ':');
                signum = 1;
            }
            double seconds = (double)(rest %= 60000L) / 1000.0;
            double toFormat = (double)signum * seconds;
            String localeSpecificFormatedValue = zeroPaddingNumberFormat_Sec.format(toFormat);
            String currentLocaleSeperator = LocaleInfo.getCurrentLocale().getNumberConstants().decimalSeparator();
            result.append(localeSpecificFormatedValue.replace(currentLocaleSeperator, "."));
            return result.toString();
        }
        return "";
    }
}

